import { cvCommonModule } from "common/js/modules";
import FsCallOutTemplates from "../../../adminConsole/js/controllers/columnTemplates/fsCallOut.template";


class cvClientReadinessStatus {
    constructor(){
        this.bindToController = true,
        this.controllerAs = 'ccrStatusCtrl',
        this.scope = {
            clientId: '@',
            clientReadiness: '='
        },
        this.templateUrl = appUtil.appRoot + 'common/partials/cvClientReadinessStatus.jsp',
        this.controller = cvClientReadinessStatusController
    }
    link(scope, ele, attrs, ccrStatusCtrl) {
    }
}


class cvClientReadinessStatusController {
    constructor($scope, $filter, idaService, clientService, clientFactory, cvLoc) {
        this.cvLoc = cvLoc;
        this.$filter = $filter;
        
        let self = this;
        this.$onInit = () => {
            const readinessCheckReq = clientFactory.getReadinessCheckReq(self.clientId);
    
            if (!_.isUndefined(this.clientReadiness)) {
                this.initClientReadiness();
            } else {
                idaService.getClientDetails(self.clientId).then( data => {
                    if (_.has(data, 'data.clientReadiness')) {
                        this.clientReadiness = data.data.clientReadiness;
                        this.initClientReadiness();
                    }
                });
            }
            
            
            self.checkReadiness = function () {
                self.checkReadinessLoading = true;
                clientService.readinessCheck(readinessCheckReq)
                    .success(function (checkReadinessData) {
                        self.checkReadinessLoading = false;
                        _.each(checkReadinessData.summary, summary => {
                            if (summary.entity.entityName === 'Client') {
                                self.readinessStatus = summary.status.split('.')[0];
                                self.clientReadinessLastCheckedText = cvLoc('label.asOfJustNow');
                                self.generateNotReadyReasons(summary.reason);
                                return;
                            }
                        });
                    }).error(function (errMsg) {
                        self.checkReadinessLoading = false;
                    });
            }
        };
    }

    initClientReadiness() {
        const readinessStatus = _.get(this.clientReadiness, 'readinessStatus');
        const ccrTime = _.get(this.clientReadiness, 'ccrTime.time');
        this.readinessStatus = _.isString(readinessStatus) ? readinessStatus.split('.')[0] : null;
        this.clientReadinessLastCheckedText =  ccrTime ? this.cvLoc('label.asOf', this.$filter('customDateTime')(ccrTime)) : '';
        const offlineReasons = _.get(this, 'clientReadiness.offlineReasons[0]');
        this.generateNotReadyReasons(offlineReasons);
    }


    generateNotReadyReasons(offlineReasons) {

        this.notReadyReasonsTemplate = '';
        if (this.readinessStatus.includes('Not') && offlineReasons && _.isString(offlineReasons)) {
            let notReadyReasons = [];
            offlineReasons.split('<BR/>').forEach(  (reason, i) => {
                if (reason) {
                    notReadyReasons.push(_.trimEnd(reason, '.'));
                }
            });
            this.notReadyReasonsTemplate = new FsCallOutTemplates().getListingTemplate(notReadyReasons, this.cvLoc('label.notReadyReasons'), false, false);
        }
    }
}


cvClientReadinessStatusController.$inject = ['$scope', '$filter', 'idaService', 'clientService','clientFactory', 'cvLoc'];

cvCommonModule.directive("cvClientReadinessStatus", () => new cvClientReadinessStatus());
export default cvCommonModule;
