import { cvCommonModule } from "common/js/modules";
import CallOut from "../call-out";
const callOutTemplate = `
<span ng-if="!ctrl.bypass && ctrl.htmlTemplate" class="call-out" cv-toggle="callout" data-content={{ctrl.htmlTemplate}} data-trigger="{{ctrl.trigger}}" data-placement="{{ctrl.placement}}">
    <span ng-if="!ctrl.label" tabindex="-1" class="glyphicon call-out-icon" ng-class="ctrl.icon"></span>
    <span ng-if="ctrl.label" class="call-out-label" ng-bind="ctrl.label"></span>
</span>
<div ng-if="!ctrl.bypass && !ctrl.htmlTemplate && ctrl.templatePath" id="transcluded-content" ng-transclude popover-append-to-body="true" popover-placement="{{ctrl.placement}}" popover-trigger="'{{ctrl.trigger}}'"  popover-class="call-out no-border no-max-width" uib-popover-template="ctrl.templatePath" tabindex="-1">
</div>
<div ng-if="ctrl.bypass" ng-transclude>
</div>
`;


class CvCallOut {
    constructor() {
        this.bindToController = true;
        this.controllerAs = 'ctrl';
        this.scope = {
            htmlTemplate: '=?',
            /* Array of actions 
            [ Object{ actionSelector:  valid CSS selector in call-out template,
            /* onClick: onClickCallBack}] */
            actions: '=?', 
            callOutControls: '=?', //Pass parent scope empty object{} , Controls: 1 .updateCallOut(content) 2. hideCallOut()
            placement: '@',//auto | top | bottom | left | right
            trigger: '@',//click | mouseenter
            icon: '@',
            label: '@',
            // link to jsp file of template, and params to add data to the template
            templatePath: '@',
            bypass: '=?', // To be able to bypass cvcallout conditionally (In case transcluded content exists)
            params: '=?'
        };
        this.template = callOutTemplate;
        this.transclude = true,
        this.controller = CvCallOutController;    
    }

    link(scope, element, attrs, ctrl) {
        if (ctrl.templatePath) {
            return;
        }
        
        ctrl.trigger = ctrl.trigger || 'click';
        ctrl.placement = ctrl.placement || 'right';

        const callOut = new CallOut(element, ctrl.actions, false);
        callOut.build();
        
        if (_.isPlainObject(ctrl.callOutControls)) {
            ctrl.callOutControls.updateCallOut = content => {
                ctrl.htmlTemplate = content;
                callOut.currentCallOutTarget && callOut.update(callOut.currentCallOutTarget, content);
            }
        
            ctrl.callOutControls.hideCallOut = () => callOut.hideCallOut();
        }
        ctrl.callOut = callOut;
    }
}


class CvCallOutController {
    constructor($scope) {
        this.$scope = $scope;
       
        $scope.$on('$destroy', () => {
            this.callOut && this.callOut.destroy();
        });
    }

    $onInit() {
        if (this.templatePath) {
            this.trigger = this.trigger || 'outsideClick';
            this.placement = this.placement || 'auto right';
        }
        this.icon = this.icon || 'glyphicon-info-sign';
        this.transclude = !!this.transclude;
        _.assignIn(this, _.get(this, 'params', {}));
        _.assignIn(this.$scope, _.get(this, 'params', {}));
    }

}


CvCallOutController.$inject = ["$scope"];

cvCommonModule.directive("cvCallOut", () => new CvCallOut());
export default cvCommonModule;
