import { cvCommonModule } from "common/js/modules";

const alertMe = cvCommonModule.directive('cvAlertMe', ['customAPIHeaderFactory', function (customAPIHeaderFactory) {
	return {
        restrict: 'E',
        scope: {
            text: '@',
            selected: '=',
            headerToSet: '@'
        },
        template: `<div class="multiple-checkbox-group">
	                <input id="{{id}}" class="" type="checkbox" ng-change="changed()" ng-model="selected"/>
                     <label class="margin-left-0 overwriteLabel" for="{{id}}"><cv-help-text  help-label="{{text}}" help-text="label.enableAlertHelpText"/></label>
	            </div>`,
		link: function(scope, element, attrs) {
				scope.id = "_" + new Date().getTime();
				
				scope.changed = function(){
					scope.status = scope.selected ? "enabled-activity" : "disabled-activity";
		      		let headerToSet = scope.headerToSet;
		      		if(!headerToSet || headerToSet === '') {
		      			headerToSet = 'notifyUserOnJobCompletion';
		      		}
		      		if(scope.selected){
		      			customAPIHeaderFactory.add(headerToSet, 'true');
		      		} else {
		      			customAPIHeaderFactory.remove(headerToSet);
		      		}
		        }
		        //called on directive load to overwrite previously set custom header value.
		        scope.changed();
		}
    };
}]);



export default alertMe;