const app = angular.module('cvCommon');

const defaultLogoTEMPLATE = `
   <div class="logo-bar">
        <div data-ng-if="!ctrl.useCustom" >
            <div class="logo-bar-default">
                <svg class="default-logo" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 50"><path d="M181.63 4.36l-13.87 8v15.4l13.87 8 13.87-8V12.37zm11.47 22l-11.47 6.62-11.47-6.62V13.75l11.47-6.62 11.47 6.62z" fill="#ff4a6a"/><path d="M180.83 29.85a.15.15 0 0 1-.23.13l-8.1-4.7a.44.44 0 0 1-.23-.4v-9.03a.15.15 0 0 1 .23-.14l8.07 4.67a.46.46 0 0 1 .23.4zM189.67 14.5l-7.73 4.46a.62.62 0 0 1-.62 0l-7.73-4.46a.15.15 0 0 1 0-.26l7.73-4.47a.62.62 0 0 1 .62 0l7.73 4.47a.15.15 0 0 1 0 .26zM189.67 25.9l-7 4a.15.15 0 0 1-.23-.13v-8.05a.15.15 0 0 1 .23-.13l7 4a.16.16 0 0 1 0 .31z" fill="#ff4a6a"/><path d="M18.85 27.97a14.28 14.28 0 0 1-5.06.84q-9.29.04-9.29-8.96 0-8.5 9.29-8.51a14.06 14.06 0 0 1 5.06.85v2.89a12.06 12.06 0 0 0-4.82-1q-6.21 0-6.21 5.73 0 6.21 6.21 6.21a11.9 11.9 0 0 0 4.82-1zM21.01 39.09a11 11 0 0 1 .33-3.54 4 4 0 0 1 4.1-3 4.1 4.1 0 0 1 3.95 2.54.18.18 0 0 1-.07.24l-1.09.53a.17.17 0 0 1-.23-.06.17.17 0 0 1-.02-.03 2.7 2.7 0 0 0-2.54-1.69 2.49 2.49 0 0 0-2.56 1.86 10.73 10.73 0 0 0-.23 3.11 10.77 10.77 0 0 0 .23 3.12 2.49 2.49 0 0 0 2.56 1.85 2.68 2.68 0 0 0 2.54-1.69.18.18 0 0 1 .24-.1l.01.01 1.09.54a.18.18 0 0 1 .07.24 4.12 4.12 0 0 1-3.95 2.54 4 4 0 0 1-4.1-3 10.92 10.92 0 0 1-.33-3.47zm10.49 4.12a7.08 7.08 0 0 1-.29-2.26 7.1 7.1 0 0 1 .29-2.25 3.38 3.38 0 0 1 3.43-2.39 3.36 3.36 0 0 1 3.43 2.39 6.82 6.82 0 0 1 .29 2.25 6.81 6.81 0 0 1-.29 2.26 3.38 3.38 0 0 1-3.43 2.39 3.4 3.4 0 0 1-3.43-2.39zm5.39-.45a6.05 6.05 0 0 0 .2-1.81 5.94 5.94 0 0 0-.2-1.8 2.08 2.08 0 0 0-3.92 0 5.94 5.94 0 0 0-.2 1.8 6.05 6.05 0 0 0 .2 1.81 2.08 2.08 0 0 0 3.92 0zm15.35 2.64a.18.18 0 0 1-.18-.18v-5.2c0-1.43-.64-2.26-1.94-2.26a2 2 0 0 0-2 2v5.45a.18.18 0 0 1-.17.19h-1.17a.18.18 0 0 1-.18-.18v-5.2c0-1.43-.64-2.26-1.94-2.26a2 2 0 0 0-2 2v5.45a.18.18 0 0 1-.17.19h-1.17a.18.18 0 0 1-.18-.18V36.7a.17.17 0 0 1 .16-.18.18.18 0 0 1 .02 0h1.18a.17.17 0 0 1 .18.16.18.18 0 0 1 0 .02v.82a3 3 0 0 1 5 .18 3.21 3.21 0 0 1 2.82-1.39c2 0 3.1 1.32 3.1 3.34v5.56a.18.18 0 0 1-.17.19h-.01zm15.37 0a.18.18 0 0 1-.18-.18v-5.2c0-1.43-.63-2.26-1.94-2.26a2 2 0 0 0-2 2v5.45a.18.18 0 0 1-.17.19h-1.17a.18.18 0 0 1-.18-.18v-5.2c0-1.43-.63-2.26-1.94-2.26a2 2 0 0 0-2 2v5.45a.18.18 0 0 1-.17.19H56.7a.18.18 0 0 1-.18-.18V36.7a.17.17 0 0 1 .16-.18.18.18 0 0 1 .02 0h1.16a.17.17 0 0 1 .18.16.18.18 0 0 1 0 .02v.82a3 3 0 0 1 5 .18 3.22 3.22 0 0 1 2.81-1.39c2 0 3.1 1.32 3.1 3.34v5.56a.18.18 0 0 1-.17.19h-.01zm9.54 0a.18.18 0 0 1-.18-.18v-.79a2.82 2.82 0 0 1-2.57 1.17c-1.65 0-2.92-.87-2.92-2.67s1.27-2.74 3.39-2.74h2a.1.1 0 0 0 .11-.09.1.1 0 0 0 0-.02v-.65c0-1.23-.47-1.75-2.08-1.75a3.35 3.35 0 0 0-2.11.63c-.09.08-.19.08-.25 0l-.49-.86a.2.2 0 0 1 0-.26 4.73 4.73 0 0 1 2.95-.87c2.47 0 3.41.84 3.41 3v5.88a.18.18 0 0 1-.17.19h-.01zm-.22-2.88v-1a.1.1 0 0 0-.09-.11.1.1 0 0 0-.02 0h-1.74c-1.5 0-2.15.44-2.15 1.44s.65 1.39 1.81 1.39c1.36.02 2.19-.62 2.19-1.72zM87 45.4a.18.18 0 0 1-.19-.17.18.18 0 0 1 0-.02v-5.19c0-1.43-.63-2.26-1.94-2.26a2 2 0 0 0-2 2v5.45a.18.18 0 0 1-.17.19h-1.2a.18.18 0 0 1-.18-.18V36.7a.17.17 0 0 1 .16-.18.18.18 0 0 1 .02 0h1.2a.17.17 0 0 1 .18.16.18.18 0 0 1 0 .02v.82a2.72 2.72 0 0 1 2.43-1.21c1.88 0 3 1.32 3 3.34v5.56a.18.18 0 0 1-.17.19h-.01zm9.71 0a.18.18 0 0 1-.18-.18v-.86a2.62 2.62 0 0 1-2.46 1.24 2.86 2.86 0 0 1-3-2.13 7.45 7.45 0 0 1-.31-2.52 7.43 7.43 0 0 1 .31-2.51 2.87 2.87 0 0 1 3-2.13 2.6 2.6 0 0 1 2.43 1.23v-4.56a.18.18 0 0 1 .17-.19h1.17a.18.18 0 0 1 .19.17.18.18 0 0 1 0 .02v12.23a.18.18 0 0 1-.17.19.18.18 0 0 1-.02 0zm-.38-2.55a5.67 5.67 0 0 0 .17-1.9 5.82 5.82 0 0 0-.2-1.86 2 2 0 0 0-3.82 0 6.3 6.3 0 0 0-.2 1.86 6.11 6.11 0 0 0 .22 1.9 2 2 0 0 0 3.82 0zm8.76-3.76a10.7 10.7 0 0 1 .33-3.54 4 4 0 0 1 4.1-3 4.1 4.1 0 0 1 4 2.54.19.19 0 0 1-.07.24l-1.09.53a.18.18 0 0 1-.26-.09 2.69 2.69 0 0 0-2.6-1.65 2.48 2.48 0 0 0-2.56 1.86 10.56 10.56 0 0 0-.24 3.11 10.6 10.6 0 0 0 .24 3.12 2.48 2.48 0 0 0 2.56 1.85 2.68 2.68 0 0 0 2.53-1.69.19.19 0 0 1 .25-.1l.01.01 1.09.54a.19.19 0 0 1 .07.24 4.12 4.12 0 0 1-4 2.54 4 4 0 0 1-4.1-3 10.63 10.63 0 0 1-.26-3.51zm10.48 4.1a7.15 7.15 0 0 1-.29-2.24 7.14 7.14 0 0 1 .27-2.25 3.63 3.63 0 0 1 6.82 0 8 8 0 0 1 .27 2.54.18.18 0 0 1-.17.2.17.17 0 0 1-.03-.01h-5.49a.1.1 0 0 0-.11.09.1.1 0 0 0 0 .02 3.08 3.08 0 0 0 .15 1.07 2.14 2.14 0 0 0 2.19 1.54 2.8 2.8 0 0 0 2.23-1c.09-.09.18-.11.27 0l.74.69a.16.16 0 0 1 0 .26 4.17 4.17 0 0 1-3.39 1.52 3.36 3.36 0 0 1-3.46-2.43zm5.4-3a.1.1 0 0 0 .11-.09.1.1 0 0 0 0-.02 3.29 3.29 0 0 0-.12-1 2.13 2.13 0 0 0-4 0 3.26 3.26 0 0 0-.13 1 .1.1 0 0 0 .09.11.1.1 0 0 0 .02 0zm9.81 5.21a.18.18 0 0 1-.18-.18v-5.2c0-1.43-.63-2.26-1.94-2.26a2 2 0 0 0-2 2v5.45a.18.18 0 0 1-.17.19h-1.17a.18.18 0 0 1-.19-.17.18.18 0 0 1 0-.02V36.7a.18.18 0 0 1 .18-.18h1.19a.17.17 0 0 1 .18.16.18.18 0 0 1 0 .02v.82a2.71 2.71 0 0 1 2.43-1.21c1.88 0 3 1.32 3 3.34v5.56a.18.18 0 0 1-.17.19.18.18 0 0 1-.02 0zm6.8.09c-1.68 0-2.34-.78-2.34-2.52v-5.12c0-.08 0-.11-.1-.11h-.73a.18.18 0 0 1-.18-.18v-.9a.17.17 0 0 1 .16-.18.18.18 0 0 1 .02 0h.73c.07 0 .1 0 .1-.11V33.9a.18.18 0 0 1 .18-.18h1.17a.17.17 0 0 1 .18.16.18.18 0 0 1 0 .02v2.51a.1.1 0 0 0 .09.11.1.1 0 0 0 .02 0h1.37a.18.18 0 0 1 .19.17v.9a.18.18 0 0 1-.17.19.18.18 0 0 1-.02 0h-1.37c-.08 0-.11 0-.11.11v5c0 .89.32 1.13 1.1 1.13h.38a.18.18 0 0 1 .19.17.18.18 0 0 1 0 .02v1.07a.18.18 0 0 1-.17.19.18.18 0 0 1-.02 0zm3.03-2.3a7.15 7.15 0 0 1-.29-2.24 7.14 7.14 0 0 1 .27-2.25 3.63 3.63 0 0 1 6.82 0 8 8 0 0 1 .27 2.54.18.18 0 0 1-.17.2.17.17 0 0 1-.03-.01h-5.49a.1.1 0 0 0-.11.09.1.1 0 0 0 0 .02 3.34 3.34 0 0 0 .15 1.07 2.14 2.14 0 0 0 2.19 1.54 2.8 2.8 0 0 0 2.23-1c.09-.09.18-.11.27 0l.78.7a.16.16 0 0 1 .04.22.16.16 0 0 1-.04.04 4.17 4.17 0 0 1-3.39 1.52 3.36 3.36 0 0 1-3.5-2.44zm5.4-3a.1.1 0 0 0 .11-.09.1.1 0 0 0 0-.02 3.29 3.29 0 0 0-.12-1 2.13 2.13 0 0 0-4 0 3.26 3.26 0 0 0-.13 1 .1.1 0 0 0 .09.11.1.1 0 0 0 .02 0zm4.36 5.21a.18.18 0 0 1-.18-.18V36.7a.17.17 0 0 1 .16-.18.18.18 0 0 1 .02 0h1.13a.17.17 0 0 1 .18.16.18.18 0 0 1 0 .02v.91a2.41 2.41 0 0 1 2.3-1.3 2.64 2.64 0 0 1 1.78.67.17.17 0 0 1 .02.24.16.16 0 0 1-.02.02l-.67.91a.16.16 0 0 1-.22.02.16.16 0 0 1-.03-.02 2.5 2.5 0 0 0-1.34-.42c-1.33 0-1.87 1.05-1.87 2.59v4.86a.18.18 0 0 1-.17.19h-.01zm6.71-10.55h-.05v-1.79h-.53v-.26h1.5l.05.05v.21h-.6v1.71h-.05zm2.91 0h-.05v-1.37l-.47 1a.06.06 0 0 1-.06.05h-.18l-.06-.05-.46-1v1.29h-.27v-2.05h.2a.07.07 0 0 1 .07.05l.62 1.34.61-1.34a.08.08 0 0 1 .07-.05h.2l.05.05v2h-.05zM29.16 11.32q-8.66.01-8.66 8.77.4 8.76 8.68 8.76 8.52 0 8.5-8.76.14-8.78-8.52-8.77zm0 14.77l.02-.05c-3.56 0-5.37-2.03-5.37-5.95s1.79-5.92 5.35-5.92q5.22-.08 5.21 5.92t-5.21 6zM40.21 28.69V11.44h3.29l5.85 13.09 5.75-13.09h3.2v17.25h-2.95v-12l-4.68 12h-2.73l-4.78-12v12h-2.95zM61.92 28.69V11.44h3.32l5.85 13.09 5.72-13.09h3.2v17.25h-3v-12l-4.68 12h-2.68l-4.78-12v12h-2.95zM99.56 11.44L92 28.69h-3.44l-7.23-17.25h3.8l5.37 13.21 5.3-13.21h3.76zM95.99 28.69l7.32-17.25h3.44l7.48 17.25h-3.44l-2.17-4.7h-5.4l1.09-2.78h3.47l-2.83-6.47-5.68 14-3.28-.05zM114.67 21.91V11.44h3.2v10.47q0 4.13 4.22 4.13t4.22-4.13V11.44h3.19v10.47q0 6.9-7.42 6.9t-7.41-6.9zM135.96 11.44v14.48h8v2.77h-11.2V11.44h3.2zM155.36 11.44v2.78h-4.94v14.47h-3.2V14.22h-4.95v-2.78h13.09zM158.59 12.93a.66.66 0 0 0 .31-.13.39.39 0 0 0 .12-.32.46.46 0 0 0-.14-.36.68.68 0 0 0-.44-.12h-.64v1.66h.26v-.71h.27l.45.71h.28zm-.52-.23v-.44h.56a.11.11 0 0 1 .11.11v.22a.11.11 0 0 1-.11.11z"/><path d="M158.38 11.42h-.03a1.41 1.41 0 1 0 .03 0zm-.03 2.62a1.21 1.21 0 1 1 1.21-1.21v.02a1.21 1.21 0 0 1-1.21 1.19z"/></svg>
			</div>
        </div>
        <div data-ng-if="ctrl.useCustom" class="logo-bar-default logo-bar-custom" id="custom-logo-small" data-ng-style='{"background-image": ctrl.themeLogo}'></div>
    </div>
`;
class CVLogoDirective {
    constructor() {
        this.restrict = 'E',
        this.template = defaultLogoTEMPLATE,
        this.controller = cvLogoDirectiveController,
        this.controllerAs='ctrl',
        this.bindToController = true,
        this.scope= {};
    }

    link(scope,element, attrs, ctrl) {
        if(cv.sessionContext) {
            if(cv.sessionContext.theme !==null && !_.isEmpty(cv.sessionContext.theme)) {
                cv.theme = cv.sessionContext.theme;
            }
    
            if(cv.theme !== null && cv?.theme?.customLogoSmall) {
                try {
                    const themeJSON = cv.sessionContext.theme || {};
                    if(themeJSON.customLogoSmall !==null && !_.isEmpty(themeJSON.customLogoSmall)) {
                        ctrl.originialTheme = 'url(data:image/'+themeJSON.customLogoSmall + ')';
                        ctrl.changeLogo(ctrl.originialTheme);
                    }
                } catch (e) {
                    ctrl.$log.error(e);
                }
            } //load OEM logo
            else if(cvApp?.oemId > 1 && cvConfig?.isOEMImageSupported)
            {
                self.defaultPath = `/adminconsole/OEM/${cvApp.oemId}/images/Company_logo.png`;
                ctrl.changeLogo(`url(${self.defaultPath})`);
            }
        }       

    }
} 

class cvLogoDirectiveController {
    constructor($location, $rootScope,$log) {
        this.$location = $location;
        this.$rootScope = $rootScope;
        this.$log = $log;
    }

    $onInit() {
        this.changeLogo = this._changeLogo.bind(this);

        this.init(this);        
        this.registerEvent(this,this.$rootScope);
    }

    init(self) {
        self.useCustom = false;
        // self.defaultPath = self.$location.protocol() + '://' + self.$location.host() + '/webconsole/OEM/' + cvApp.oemId + '/images/';
      	// self.defaultPath = self.$location.protocol() + "://" + self.$location.host() +  ":" + self.$location.port() + '/adminconsole/OEM/' + cvApp.oemId + '/images/'
        //self.defaultSrc = 'Company_logo.png';
        //self.defaultSmall = 'Company_logo_symbol.png';
        

    }

    registerEvent(self, root) {
        root.$on('ChangeLogoImage', (evt,msg)=> {
            msg = msg || (cvApp?.oemId > 1 && cvConfig?.isOEMImageSupported ? `url(/adminconsole/OEM/${cvApp.oemId}/images/Company_logo.png)` : '');
            self.changeLogo(msg)
        });

    }       
    
    _changeLogo (img) {

        if(img) {
            this.useCustom = true;
            this.themeLogo = img;
        }else{
            this.useCustom = false;
            this.themeLogo = this.originialTheme || "" ;
        }
        
    }

}

cvLogoDirectiveController.$inject = ['$location', '$rootScope','$log'];
app.directive('cvLogoDefault', () => new CVLogoDirective);
export default app;
