(function() {
	'use strict';

	var cvAppTypes = angular.module('cvAppTypes', []);
	cvAppTypes.constant('SCPIdaType', {
		WINDOWS : 2,
		UNIX : 3,
		MAC : 4
	});

	cvAppTypes.constant('SolutionType', {
		Databases : 'label.nav.databases',
		FileServers : 'label.nav.servers',
		Virtualization : 'label.nav.virtualizationDashboard',
		Endpoint : 'label.nav.endpointDashboard',
		Exchange : 'label.nav.exchange',
		Archiving : 'label.archiving',
		Archive : 'label.archive',
		CloudApps : 'label.capps',
		OracleEBS : 'label.ebs',
		SharePoint : 'label.sharepoint',
		GovernanceApps : 'label.nav.activate',
		ActiveDirectory : 'label.nav.activeDirectory',
		BigDataApps : 'label.nav.bigDataApps'

	})

	cvAppTypes.constant('AppTypes', {
		WINDOWS_FILESYSTEM : 33,
		MS_WINDOWS_XP_FS_32 : 33,
		MS_WINDOWS_XP_FS_64 : 34,
		MS_WINDOWS_DOTNET_FS_32 : 42,
		MS_WINDOWS_DOTNET_FS_64 : 43,
		APPTYPE_FILESYSTEM : 1,
		APPTYPE_W2000_FILESYSTEM : 11,
		UNIX_FILESYSTEM : 29,
		MAC_FILESYSTEM : 63,
		APPTYPE_HPUX32_FS : 17,
		CV_APPTYPE_SGI_FS : 64,
		CV_APPTYPE_APPLEMAC_FS : 63,
		APPTYPE_HPUX64_FS : 18,
		APPTYPE_SOLARIS32_FS : 19,
		APPTYPE_SOLARIS64_FS : 20,
		APPTYPE_UNIX_TRU_64_FS : 36,
		APPTYPE_LINUX_FS : 29,
		CV_APPTYPE_FREE_BSD : 74,
		APPTYPE_AIX_FS : 21,
		SQL_SERVER : 81,
		AZURE_WEBAPP : 301,
		VMWARE : 106,
		ORACLE : 22,
		SAP_FOR_ORACLE : 61,
		POSTGRESQL : 125,
		SAP_HANA : 135,
		SAP_HANA_PHYSICAL : 136,
		CLOUD_APPS : 134,
		DB2 : 37,
		DB2_MultiNode : 103,
		DB2_On_Unix : 62,
		EXCHANGE_DATABASE : 53,
		INFORMIX_DATABASE : 3,
		MYSQL : 104,
		ORACLE_RAC : 80,
		SYBASE_DATABASE : 5,
		EXCHANGE_MAILBOX_ARCHIVER : 56,
		EXCHANGE_MAILBOX : 137,
		EXCHANGE_PF_ARCHIVER : 82,
		EXCHANGE_COMPLIANCE_ARCHIVER : 67,
		EXCHANGE_MAILBOX_CLASSIC : 54,
		EXCHANGE_PUBLIC_FOLDER : 35,
		FILE_SHARE_ARCHIVER : 73,
		NETWARE_FILE_ARCHIVER : 83,
		UNIX_FILE_ARCHIVER : 66,
		WINDOWS_FILE_ARCHIVER : 58,
		ACTIVE_DIRECTORY : 41,
		AZURE_ACTIVE_DIRECTORY : 139,
		AIX_FILE_SYSTEM : 21,
		DISTRIBUTED_APPS : 64,
		DPM : 91,
		FREE_BSD : 74,
		HP_UX_FILE_SYSTEM : 17,
		IMAGE_LEVEL : 65,
		IMAGE_LEVEL_ON_UNIX : 75,
		IMAGE_LEVEL_PROXYHOST : 76,
		IMAGE_LEVEL_PROXYHOST_ON_UNIX : 87,
		LINUX_FILESYSTEM : 29,
		NAS : 13,
		NETWARE_FILESYSTEM : 12,
		NOVELL_DIRECTORY_SERVICES : 10,
		OBJECT_LINK : 124,
		OBJECT_STORE : 131,
		OES_FILESYSTEM_ON_LINUX : 86,
		OTHER_EXTERNAL_AGENT : 130,
		PROXY_CLIENT_FILE_SYSTEM : 38,
		PROXYHOST_ON_UNIX : 40,
		SOLARIS_64BIT_FILESYSTEM : 20,
		SOLARIS_FILESYSTEM : 19,
		UNIX_TRU64_64BIT_FILESYSTEM : 36,
		MS_SHAREPOINT_ARCHIVER : 89,
		SHAREPOINT_SERVER : 78,
		CV_APPTYPE_SUBCLIENT_POLICY : 1030,
		NOTES6_DB : 59,
		UNIX_LOTUSNOTES6_DB : 77,
		CV_APPTYPE_ADV_IDA : 1039,
		CV_APPTYPE_SAP_FOR_ORACLE : 61,
		CV_APPTYPE_SAP_FOR_ORACLE_FOR_SAPDB : 79,
		APPTYPE_NOTES6_DOC : 60,
		UNUSED_CV_APPTYPE_51 : 51,
		UNUSED_CV_APPTYPE_52 : 52,
		APPTYPE_LOTUSNOTES_DATABASE : 6,
		APPTYPE_LOTUSNOTES_DOCUMENT : 7,
		APPTYPE_MSSQL : 4,
		APPTYPE_MSSQLSERVER_2000 : 16,
		UNUSED_CV_APPTYPE_70 : 70,
		APPTYPE_ORACLE : 2,
		APPTYPE_INFORMIX : 3,
		CV_APPTYPE_SYBASE : 5,
		APPTYPE_ORACLE8I : 23,
		CV_APPTYPE_SRM_SQL : 602,
		CV_APPTYPE_NUTANIX : 94,
		VAULT_TRACKER : 'vaultTracker',
		KUBERNETES : 'KUBERNETES',
		MS_DYNAMICS_365: 'MS_DYNAMICS_365',
		MS_TEAMS: 'MS_TEAMS',
		ONEDRIVE: "ONEDRIVE"
	});

	cvAppTypes.constant('AppGroups', {
		APPGRP_NotesDb_Transaction_Log : 104,
		APPGRP_DOCUMENTUM : 115,
		APPGRP_JOURNALED_MAILS : 8,
		APPGRP_ARCHIVED_FILES : 5,
		APPGRP_POSTGRES : 114,
		APPGRP_ORACLE : 10,
		APPGRP_DB2 : 11,
		APPGRP_AppTypeIndexedBased : 83,
		APPGRP_SqlServerAppType : 82,
		APPGRP_ARCHIVE_DOCS : 2,
		APPGRP_NotesDb : 12,
		APPGRP_DISTRIBUTEDAPPS : 134,
		APPGRP_XchangeDB : 14,
		APPGRP_MySql : 100,
		APPGRP_NotesDocDataMigrator : 67,
		APPGRP_SAP_FOR_MAXDB : 128,
		APPGRP_BACKEDUP_MAILS : 6,
		APPGRP_INFORMIX : 111,
		APPGRP_SAP_FOR_ORACLE : 101,
		APPGRP_ARCHIVED_MAILS : 7,
		APPGRP_SAP_HANA : 129,
		APPGRP_SQL_POLICY : 90,
		APPGRP_CLOUDAPPS : 135,
		APPGRP_Sybase : 13,
		APPGRP_NotesDoc : 68,
		APPGRP_BACKEDUP_FILES : 1,
		APPGRP_BACKEDUP_DOCS : 3,
		APPGRP_W2KFileSystem : 22,
		APPGRP_ACTIVE_DIRECTORY : 138
	});

	cvAppTypes.constant('Packages', {
		PKG_ID_OPENVMS : 1138,
		PKG_ID_IBMI : 1137
	});

	cvAppTypes.service('AppTypesUtil', [
			'AppTypes',
			'cvLoc',
			'AppGroups',
			'SIM_IDS',
			'clientService',
			'SCPIdaType',
			'SolutionType',
			'distributedClusterType',
			'clusterType',
			function(AppTypes, cvLoc, AppGroups, SIM_IDS, clientService, SCPIdaType, SolutionType, distributedClusterType, clusterType) {

				// checkFileSystem function removed, use getClientService from client services instead

				this.isIbmiFileSystem = function(osId) {
					if (osId && (osId == SIM_IDS.SIM_ID_IBM_ISERIES_OS)) {
						return true
					}
					return false;
				}

				this.isOpenvmsFileSystem = function(osId) {
					if (osId && (osId == SIM_IDS.SIM_ID_OPENVMS_OS)) {
						return true;
					}
					return false;
				}

				this.isWindowsFileSystem = function(applicationId) {
					if (applicationId) {
						switch (parseInt(applicationId)) {
						case AppTypes.WINDOWS_FILESYSTEM:
						case AppTypes.MS_WINDOWS_XP_FS_32:
						case AppTypes.MS_WINDOWS_XP_FS_64:
						case AppTypes.MS_WINDOWS_DOTNET_FS_32:
						case AppTypes.MS_WINDOWS_DOTNET_FS_64:
						case AppTypes.APPTYPE_FILESYSTEM:
						case AppTypes.APPTYPE_W2000_FILESYSTEM:
							return true;
						default:
							return false;
						}
					}
					return false;
				};

				this.isUnixFileSystem = function(applicationId) {
					if (applicationId) {
						switch (parseInt(applicationId)) {
						case AppTypes.APPTYPE_HPUX32_FS:
							/* case AppTypes.CV_APPTYPE_SGI_FS: */
						case AppTypes.CV_APPTYPE_APPLEMAC_FS:
						case AppTypes.MAC_FILESYSTEM:
						case AppTypes.APPTYPE_HPUX64_FS:
						case AppTypes.APPTYPE_SOLARIS32_FS:
						case AppTypes.APPTYPE_SOLARIS64_FS:
						case AppTypes.APPTYPE_UNIX_TRU_64_FS:
						case AppTypes.APPTYPE_LINUX_FS:
						case AppTypes.UNIX_FILESYSTEM:
						case AppTypes.CV_APPTYPE_FREE_BSD:
						case AppTypes.APPTYPE_AIX_FS:
						case AppTypes.PROXY_CLIENT_FILE_SYSTEM:
							return true;
						default:
							return false;
						}
					}
					return false;
				};

				this.getUnixFileSystemList = function() {
					return [
						AppTypes.APPTYPE_HPUX32_FS,
						AppTypes.APPTYPE_HPUX64_FS,
						AppTypes.APPTYPE_SOLARIS32_FS,
						AppTypes.APPTYPE_SOLARIS64_FS,
						AppTypes.APPTYPE_AIX_FS,
						AppTypes.APPTYPE_LINUX_FS,
						AppTypes.UNIX_FILESYSTEM,
						AppTypes.APPTYPE_UNIX_TRU_64_FS,
						AppTypes.PROXY_CLIENT_FILE_SYSTEM,
						AppTypes.MAC_FILESYSTEM,
						AppTypes.CV_APPTYPE_APPLEMAC_FS,
						AppTypes.CV_APPTYPE_FREE_BSD
					];
				}

				//this method accepts idaType and checks if its Windows File system. Example : idaType=2
				this.isWindowsIdaType = function(idaType) {
					return SCPIdaType[idaType] == SCPIdaType.WINDOWS;
				};

				//this method accepts applicationId and checks if its hadoop agent
				this.isHadoopAgent = function(applicationId) {
					if (applicationId) {
						switch (parseInt(applicationId)) {
						case AppTypes.CV_APPTYPE_SGI_FS:
							return true;
						default:
							return false;
						}
					} else {
						return false;
					}
				};

				//this method accepts idaType and checks if its UNIX File system. Example : idaType=3
				this.isUnixIdaType = function(idaType) {
					return SCPIdaType[idaType] == SCPIdaType.UNIX;
				};

				this.getAppTypeForIdaType = function(idaType) {
					if (SCPIdaType[idaType] == SCPIdaType.WINDOWS) {
						return AppTypes.WINDOWS_FILESYSTEM;
					} else if (SCPIdaType[idaType] == SCPIdaType.UNIX || SCPIdaType[idaType] == SCPIdaType.MAC) {
						return AppTypes.UNIX_FILESYSTEM;
					}
				};

				this.isFileSystemAgent = function(applicationId) {
					if ((this.isWindowsFileSystem(applicationId)) || (this.isUnixFileSystem(applicationId))) {
						return true;
					}
					return false;
				};

				this.isDB2Agent = function(applicationId) {
					if (applicationId) {
						switch (parseInt(applicationId)) {
						case AppTypes.DB2:
						case AppTypes.DB2_MultiNode:
						case AppTypes.DB2_On_Unix:
							return true;
						default:
							return false;
						}
					}
					return false;
				};

				this.isDBAgent = function(applicationId) {
					if (applicationId) {
						switch (parseInt(applicationId)) {
						case AppTypes.SQL_SERVER:
						case AppTypes.ORACLE:
						case AppTypes.SAP_FOR_ORACLE:
						case AppTypes.ORACLE_RAC:
						case AppTypes.SAP_HANA:
						case AppTypes.POSTGRESQL:
						case AppTypes.MYSQL:
						case AppTypes.CV_APPTYPE_SYBASE:
						case AppTypes.INFORMIX_DATABASE:
							return true;
						default:
							return this.isDB2Agent(applicationId);
						}
					}
					return false;
				};

				this.isOracleAgent = function(applicationId) {
					return applicationId == AppTypes.ORACLE || applicationId == AppTypes.ORACLE_RAC;
				};

				this.isSharePointAgent = function(applicationId) {
					if (applicationId) {
						switch (parseInt(applicationId)) {
						case AppTypes.SHAREPOINT_SERVER:
							return true;
						default:
							return false;
						}
					}
				};

				this.isActiveDirectoryAgent = function(applicationId) {
					return applicationId == AppTypes.ACTIVE_DIRECTORY;
				};

				this.isDistributedAgent = function(applicationId) {
					return applicationId == AppTypes.DISTRIBUTED_APPS;
				};

				this.isNotesDatabaseAgent = function(applicationId) {
					if (applicationId) {
						switch (parseInt(applicationId)) {
						case AppTypes.NOTES6_DB:
						case AppTypes.UNIX_LOTUSNOTES6_DB:
							return true;
						default:
							return false;
						}
					}
				};

				this.isSQLAgent = function(applicationId) {
					if (applicationId) {
						return (parseInt(applicationId) == AppTypes.SQL_SERVER);
					}
					return false;
				};

				this.isNASAgent = function(applicationId) {
					if (applicationId == AppTypes.NAS) {
						return true;
					}
					return false;
				};

				this.isBackupsetSupportedNode = function(nodeEntity) {
					if (nodeEntity && nodeEntity.applicationId) {
						if (nodeEntity.applicationId === AppTypes.SAP_HANA) {
							if (nodeEntity.backupsetName && nodeEntity.backupsetName === 'default') {
								return false;
							} else {
								return true;
							}
						} else {
							return this.isBackupsetSupported(nodeEntity.applicationId);
						}
					}
				};

				this.isBackupsetSupported = function(applicationId) {
					if (applicationId) {
						//TODO: need to add more conditions for applicationIds that are
						//backupset supported and non-filesystem agents
						switch (applicationId) {
						case AppTypes.POSTGRESQL:
							return true;
						case AppTypes.VMWARE:
							return false;
						}
						return this.isFileSystemAgent(applicationId) || this.isSharePointAgent(applicationId)
								|| this.isDB2Agent(applicationId);
					}
				};

				this.isInstanceSupported = function(applicationId) {
					if (applicationId) {
						switch (parseInt(applicationId)) {
						case AppTypes.SQL_SERVER:
						case AppTypes.ORACLE:
						case AppTypes.SAP_FOR_ORACLE:
						case AppTypes.ORACLE_RAC:
						case AppTypes.SAP_HANA:
						case AppTypes.CLOUD_APPS:
						case AppTypes.POSTGRESQL:
						case AppTypes.MYSQL:
						case AppTypes.UNIX_LOTUSNOTES6_DB:
						case AppTypes.NOTES6_DB:
						case AppTypes.DB2_On_Unix:
						case AppTypes.DB2:
						case AppTypes.MYSQL:
						case AppTypes.ORACLE_RAC:
						case AppTypes.WINDOWS_FILE_ARCHIVER:
						case AppTypes.DB2_MultiNode:
						case AppTypes.CV_APPTYPE_SAP_FOR_ORACLE:
						case AppTypes.CV_APPTYPE_SAP_FOR_ORACLE_FOR_SAPDB:
						case AppTypes.APPTYPE_NOTES6_DOC:
						case AppTypes.UNUSED_CV_APPTYPE_51:
						case AppTypes.UNUSED_CV_APPTYPE_52:
						case AppTypes.APPTYPE_LOTUSNOTES_DATABASE:
						case AppTypes.APPTYPE_LOTUSNOTES_DOCUMENT:
						case AppTypes.APPTYPE_MSSQL:
						case AppTypes.APPTYPE_MSSQLSERVER_2000:
						case AppTypes.UNUSED_CV_APPTYPE_70:
						case AppTypes.APPTYPE_ORACLE:
						case AppTypes.APPTYPE_INFORMIX:
						case AppTypes.CV_APPTYPE_SYBASE:
						case AppTypes.APPTYPE_ORACLE8I:
						case AppTypes.CV_APPTYPE_SRM_SQL:
							//TODO: more AppTypes will be added in future
							return true;
						case AppTypes.VMWARE:
							return false;
						default:
							return false;
						}
					}
				};

				this.isClusterTypeFileSystem = function (applicationId, entityClusterType) {
					if (!applicationId || !entityClusterType || parseInt(applicationId) !== AppTypes.DISTRIBUTED_APPS) return false;

					switch (entityClusterType) {
						case distributedClusterType.GPFS:
						case distributedClusterType.GLUSTERFS:
						case distributedClusterType.LUSTREFS:
						case clusterType.GPFS:
						case clusterType.GLUSTERFS:	
						case clusterType.LUSTREFS:
							return true;
					}

					return false;
				}

				this.createAppGroupHierarchy = function() {

					function Node(label, value, isAppGroup) {
						this.label = label;
						this.value = value;
						this.selected = false;
						this.children = [];
						if (angular.isDefined(isAppGroup)) {
							this.isAppGroup = isAppGroup;
						}
					}

					Node.prototype.addChild = function(childNode) {
						if (childNode) {
							this.children.push(childNode);
						}
					}

					var root = new Node(cvLoc('label.treenode.allAgents'), 0);
					root.__ivhTreeviewExpanded = true;

					var ad = new Node(
							cvLoc('label.treenode.activeDirectory'),
							AppGroups.APPGRP_ACTIVE_DIRECTORY,
							true);
					ad.addChild(new Node(
							cvLoc('label.treenode.activeDirectory'),
							AppTypes.ACTIVE_DIRECTORY,
							false));
					ad.addChild(new Node(
							cvLoc('label.treenode.azureActiveDirectory'),
							AppTypes.AZURE_ACTIVE_DIRECTORY,
							false));
					root.addChild(ad);

					var cloudApps = new Node(cvLoc('label.capps'), AppGroups.APPGRP_CLOUDAPPS, true);
					root.addChild(cloudApps);

					var db = new Node(cvLoc('label.treenode.database'), 0);
					var db2 = new Node(cvLoc('label.treenode.db2'), AppGroups.APPGRP_DB2, true);
					db2.addChild(new Node(cvLoc('label.treenode.db2'), AppTypes.DB2, false));
					db2.addChild(new Node(cvLoc('label.treenode.db2MultiNode'), AppTypes.DB2_MultiNode, false));
					db2.addChild(new Node(cvLoc('label.treenode.db2onUnix'), AppTypes.DB2_On_Unix, false));
					db.addChild(db2);

					var exchangeDB = new Node(cvLoc('label.treenode.exchangeDB'), AppGroups.APPGRP_XchangeDB, true);
					exchangeDB.addChild(new Node(
							cvLoc('label.treenode.exchangeDatabase'),
							AppTypes.EXCHANGE_DATABASE,
							false));
					db.addChild(exchangeDB);

					db.addChild(new Node(
							cvLoc('label.treenode.groupwiseDB'),
							AppGroups.APPGRP_AppTypeIndexedBased,
							true));

					var informixDB = new Node(cvLoc('label.treenode.informix'), AppGroups.APPGRP_INFORMIX, true);
					informixDB.addChild(new Node(
							cvLoc('label.treenode.informixDatabase'),
							AppTypes.INFORMIX_DATABASE,
							false));
					db.addChild(informixDB);

					var mysql = new Node(cvLoc('label.treenode.mySql'), AppGroups.APPGRP_MySql, true);
					mysql.addChild(new Node(cvLoc('label.treenode.mySql'), AppTypes.MYSQL, false));
					db.addChild(mysql);

					db.addChild(new Node(cvLoc('label.treenode.notesDB'), AppGroups.APPGRP_NotesDb, true));
					db.addChild(new Node(
							cvLoc('label.treenode.notesDBWithTransactionLog'),
							AppGroups.APPGRP_NotesDb_Transaction_Log,
							true));

					var oracle = new Node(cvLoc('label.treenode.oracle'), AppGroups.APPGRP_ORACLE, true);
					oracle.addChild(new Node(cvLoc('label.treenode.oracleDatabase'), AppTypes.ORACLE, false));
					oracle.addChild(new Node(cvLoc('label.treenode.oracleRac'), AppTypes.ORACLE_RAC, false));
					db.addChild(oracle);

					db.addChild(new Node(cvLoc('label.treenode.postgreSQL'), AppGroups.APPGRP_POSTGRES, true));
					db.addChild(new Node(cvLoc('label.treenode.sapForMaxDB'), AppGroups.APPGRP_SAP_FOR_MAXDB, true));
					db.addChild(new Node(cvLoc('label.treenode.sapForOracle'), AppGroups.APPGRP_SAP_FOR_ORACLE, true));
					db.addChild(new Node(cvLoc('label.treenode.saphana'), AppGroups.APPGRP_SAP_HANA, true));
					db.addChild(new Node(cvLoc('label.treenode.sqlserver'), AppGroups.APPGRP_SQL_POLICY, true));

					var sybase = new Node(cvLoc('label.treenode.sybase'), AppGroups.APPGRP_Sybase, true);
					sybase.addChild(new Node(cvLoc('label.treenode.sybaseDatabase'), AppTypes.SYBASE_DATABASE, false));
					db.addChild(sybase);

					root.addChild(db);

					var distributedApps = new Node(
							cvLoc('label.treenode.distributedApps'),
							AppGroups.APPGRP_DISTRIBUTEDAPPS,
							true);
					root.addChild(distributedApps);

					var documentum = new Node(cvLoc('label.treenode.documentum'), AppGroups.APPGRP_DOCUMENTUM, true);
					root.addChild(documentum);

					var exchangeMail = new Node(cvLoc('label.treenode.exchangeMail'), 0);
					var archivedMail = new Node(
							cvLoc('label.treenode.archivedMail'),
							AppGroups.APPGRP_ARCHIVED_MAILS,
							true);
					archivedMail.addChild(new Node(
							cvLoc('label.treenode.exchangeMailbox'),
							AppTypes.EXCHANGE_MAILBOX,
							false));
					archivedMail.addChild(new Node(
							cvLoc('label.treenode.exchangeMailboxArchiver'),
							AppTypes.EXCHANGE_MAILBOX_ARCHIVER,
							false));
					archivedMail.addChild(new Node(
							cvLoc('label.treenode.exchangePFArchiver'),
							AppTypes.EXCHANGE_PF_ARCHIVER,
							false));
					exchangeMail.addChild(archivedMail);

					var journaledMail = new Node(
							cvLoc('label.treenode.journaledMail'),
							AppGroups.APPGRP_JOURNALED_MAILS,
							true);
					journaledMail.addChild(new Node(
							cvLoc('label.treenode.exchangeComplianceArchiver'),
							AppTypes.EXCHANGE_COMPLIANCE_ARCHIVER,
							false));
					exchangeMail.addChild(journaledMail);

					var protectedMail = new Node(
							cvLoc('label.treenode.protectedMail'),
							AppGroups.APPGRP_BACKEDUP_MAILS,
							true);
					protectedMail.addChild(new Node(
							cvLoc('label.treenode.exchangeMailboxClassic'),
							AppTypes.EXCHANGE_MAILBOX_CLASSIC,
							false));
					protectedMail.addChild(new Node(
							cvLoc('label.treenode.exchangePublicFolder'),
							AppTypes.EXCHANGE_PUBLIC_FOLDER,
							false));
					exchangeMail.addChild(protectedMail);

					root.addChild(exchangeMail);

					var files = new Node(cvLoc('label.treenode.files'), 0);
					var archivedFiles = new Node(
							cvLoc('label.treenode.archivedFiles'),
							AppGroups.APPGRP_ARCHIVED_FILES,
							true);
					archivedFiles.addChild(new Node(
							cvLoc('label.treenode.fileShareArchiver'),
							AppTypes.FILE_SHARE_ARCHIVER,
							false));
					archivedFiles.addChild(new Node(
							cvLoc('label.treenode.netwareFileArchiver'),
							AppTypes.NETWARE_FILE_ARCHIVER,
							false));
					archivedFiles.addChild(new Node(
							cvLoc('label.treenode.unixFileArchiver'),
							AppTypes.UNIX_FILE_ARCHIVER,
							false));
					archivedFiles.addChild(new Node(
							cvLoc('label.treenode.windowsFileArchiver'),
							AppTypes.WINDOWS_FILE_ARCHIVER,
							false));
					files.addChild(archivedFiles);
					var protectedFiles = new Node(
							cvLoc('label.treenode.protectedFiles'),
							AppGroups.APPGRP_BACKEDUP_FILES,
							true);
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.activeDirectory'),
							AppTypes.ACTIVE_DIRECTORY,
							false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.aixFileSystem'),
							AppTypes.AIX_FILE_SYSTEM,
							false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.distributedApps'),
							AppTypes.DISTRIBUTED_APPS,
							false));
					protectedFiles.addChild(new Node(cvLoc('label.treenode.dpm'), AppTypes.DPM, false));
					protectedFiles.addChild(new Node(cvLoc('label.treenode.freeBSD'), AppTypes.FREE_BSD, false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.hpuxFileSystem'),
							AppTypes.HP_UX_FILE_SYSTEM,
							false));
					protectedFiles.addChild(new Node(cvLoc('label.treenode.imageLevel'), AppTypes.IMAGE_LEVEL, false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.imageLevelOnUnix'),
							AppTypes.IMAGE_LEVEL_ON_UNIX,
							false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.imageLevelProxyHost'),
							AppTypes.IMAGE_LEVEL_PROXYHOST,
							false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.imageLevelProxyHostOnUnix'),
							AppTypes.IMAGE_LEVEL_PROXYHOST_ON_UNIX,
							false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.linuxFileSystem'),
							AppTypes.LINUX_FILESYSTEM,
							false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.macFileSystem'),
							AppTypes.MAC_FILESYSTEM,
							false));
					protectedFiles.addChild(new Node(cvLoc('label.treenode.NAS'), AppTypes.NAS, false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.netwareFileSystem'),
							AppTypes.NETWARE_FILESYSTEM,
							false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.novellDirectoryServices'),
							AppTypes.NOVELL_DIRECTORY_SERVICES,
							false));
					protectedFiles.addChild(new Node(cvLoc('label.treenode.objectLink'), AppTypes.OBJECT_LINK, false));
					protectedFiles
							.addChild(new Node(cvLoc('label.treenode.objectStore'), AppTypes.OBJECT_STORE, false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.oesFileSystemOnLinux'),
							AppTypes.OES_FILESYSTEM_ON_LINUX,
							false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.otherExternalAgent'),
							AppTypes.OTHER_EXTERNAL_AGENT,
							false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.proxyClientFileSystem'),
							AppTypes.PROXY_CLIENT_FILE_SYSTEM,
							false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.proxyHostOnUnix'),
							AppTypes.PROXYHOST_ON_UNIX,
							false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.solaris64bitFileSystem'),
							AppTypes.SOLARIS_64BIT_FILESYSTEM,
							false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.solarisFileSystem'),
							AppTypes.SOLARIS_FILESYSTEM,
							false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.unixtru64bitfileSystem'),
							AppTypes.UNIX_TRU64_64BIT_FILESYSTEM,
							false));
					protectedFiles.addChild(new Node(cvLoc('label.treenode.virtualServer'), AppTypes.VMWARE, false));
					protectedFiles.addChild(new Node(
							cvLoc('label.treenode.windowsFileSystem'),
							AppGroups.APPGRP_W2KFileSystem,
							true));

					files.addChild(protectedFiles);

					root.addChild(files);

					var notes = new Node(cvLoc('label.treenode.notes'), 0);
					notes.addChild(new Node(
							cvLoc('label.treenode.dominoMailboxArchiver'),
							AppGroups.APPGRP_NotesDocDataMigrator,
							true));
					notes.addChild(new Node(cvLoc('label.treenode.notesDocument'), AppGroups.APPGRP_NotesDoc, true));
					root.addChild(notes);

					var sharePoint = new Node(cvLoc('label.treenode.sharepoint'), 0);
					var archivedDocuments = new Node(
							cvLoc('label.treenode.archivedDocuments'),
							AppGroups.APPGRP_ARCHIVE_DOCS,
							true);
					archivedDocuments.addChild(new Node(
							cvLoc('label.treenode.msSharePointArchiver'),
							AppTypes.MS_SHAREPOINT_ARCHIVER,
							false));
					sharePoint.addChild(archivedDocuments);

					var protectedDocuments = new Node(
							cvLoc('label.treenode.protectedDocuments'),
							AppGroups.APPGRP_BACKEDUP_DOCS,
							true)
					protectedDocuments.addChild(new Node(
							cvLoc('label.treenode.sharePointServer'),
							AppTypes.SHAREPOINT_SERVER,
							false));
					sharePoint.addChild(protectedDocuments);
					root.addChild(sharePoint);

					return [ root ];
				};

				this.getSolutionType = function(applicationId) {
					applicationId = _.toNumber(applicationId);
					switch (applicationId) {
					case 17: //Windows FS
					case 18:
					case 19:
					case 20:
					case 21:
					case 33:
					case 38:
					case 74:
					case 29: //UNIX FS
					case 1:
					case 11:
					case 34:
					case 42:
					case 43:
					case 63: //MAC FS
						return cvLoc(SolutionType.FileServers);
					case 56:
					case 137:
					case 82:
					case 67:
					case 54:
					case 35:
					case 53:
						return cvLoc(SolutionType.Exchange);
					case 106:
						return cvLoc(SolutionType.Virtualization);
					case 2:
					case 23:
					case 601:
					case 650:
						return cvLoc(SolutionType.OracleEBS);
					case 134:
						return cvLoc(SolutionType.CloudApps);
					case 32:
					case 46:
					case 64:
						return cvLoc(SolutionType.BigDataApps);
					case 69:
					case 78:
					case 607:
						return cvLoc(SolutionType.SharePoint);
					case 41:
					case 139:
						return cvLoc(SolutionType.ActiveDirectory);
						// TODO : need to add more appIds to map to solution name
					default:
						if (this.isDBAgent(applicationId)) {
							return cvLoc(SolutionType.Databases);
						}
						return cvLoc(SolutionType.FileServers);
					}
				}

				this.isCloudAppsType = function(applicationId) {
					return applicationId === AppTypes.CLOUD_APPS;
				};

				this.isNutanixFilesAppsType = function(applicationId) {
					return applicationId === AppTypes.CV_APPTYPE_NUTANIX;
				}
				
				this.isAzureActiveDirectoryAppsType = function(applicationId) {
					return applicationId === AppTypes.AZURE_ACTIVE_DIRECTORY;
				}

				this.isExchangeDBAgent = function(applicationId) {
					return applicationId === AppTypes.EXCHANGE_DATABASE;
				}

				this.isExchangeMailboxAgent = function(applicationId) {
					return applicationId === AppTypes.EXCHANGE_MAILBOX;
				}

				this.isTeamsAppAgent = function(applicationId, cloudAppType){
					return applicationId === AppTypes.CLOUD_APPS && cloudAppType === AppTypes.MS_TEAMS;
				};
				
				this.isDynamic365Agent = function(applicationId, cloudAppType){
					return applicationId === AppTypes.CLOUD_APPS && cloudAppType === AppTypes.MS_DYNAMICS_365;
				};

				this.isOffice365App = function(applicationId, cloudAppsType, isSharepointV2){
					return ((applicationId === AppTypes.CLOUD_APPS && (cloudAppsType === AppTypes.MS_TEAMS || cloudAppsType === AppTypes.MS_DYNAMICS_365 || cloudAppsType === AppTypes.ONEDRIVE)) ||
					applicationId === AppTypes.EXCHANGE_MAILBOX || applicationId === AppTypes.SHAREPOINT_SERVER && (isSharepointV2 || false));
				};
			} ]);

})();
