import { cvModuleSettingsModule } from "common/js/modules";

const cvTimeRelativePicker = [
    function(){
        return {
            restrict: 'E',
            template: `<input type="text" class="time-picker-readonly" uib-popover-template="ctrl.timeRelativePickerUrl" popover-trigger="'outsideClick'" popover-placement="bottom" popover-enable="!ctrl.isDisabled" data-ng-disabled="ctrl.isDisabled" data-ng-model="ctrl.inputValue" data-ng-readonly="ctrl.isDisabled" data-ng-change="ctrl.inputChanged()"/>`,
            replace: true,
            bindToController: true,
            scope: {
                pickerId:'@',
                isDisabled:'=',
                seconds:'=',
                hasError:'@?',
                validationFunc:'&validationFunc',
                timeListValues:'=',						//Time picker unit's list of the format [{label:, value:}, {},...{}],
                										//Default list = [{label:cvLoc('label.day'),value:'Days'},{label:cvLoc('label.hour'),value:'Hours'},{label:cvLoc('label.min'),value:'Minutes'},{label:cvLoc('label.sec'),value:'Seconds'}];
                defaultValues:'=?'						//Initial values for time-picker of the format: { value, unit }. Unit being the position of the Time picker unit in the array timeListValues
                										//relevant if timeListValues is passed

            },
            controllerAs:'ctrl',
            controller:[
                'cvUtil','cvLoc',function(cvUtil,cvLoc){
                    const ctrl = this;
                    this.$onInit = () => {
                        ctrl.timeRelativePickerUrl = appUtil.appRoot + 'common/partials/cvTimeRelativePicker.template.jsp',
                        ctrl.timeM = [{label:cvLoc('label.days'),value:'Days'},{label:cvLoc('label.hours'),value:'Hours'},{label:cvLoc('label.mins'),value:'Minutes'},{label:cvLoc('label.secs'),value:'Seconds'}];
                        ctrl.inputValue = cvLoc('Not available');
                        if(ctrl.timeListValues){
                            ctrl.timeM = ctrl.timeListValues;
                        }

                        ctrl.inputChanged = ()=> {				//to disable input other than from time picker
                            if( _.get(ctrl, 'selectedTimeM.length', 0) > 0 ){
                                ctrl.inputValue = `${ctrl.pickerNum} ${ctrl.selectedTimeM[0].label}`;
                            } else {
                                ctrl.inputValue = `${ctrl.pickerNum} ${ctrl.timeM[ctrl.defaultValues[1]].label}`
                            }
                        }

                        ctrl.changeValue = (data)=>{
                            if(ctrl.pickerNum < 0 || _.isUndefined(ctrl.pickerNum)){
                                ctrl.pickerNum = 0;
                            }
                            if( _.isUndefined(ctrl.timeListValues)){
                                ctrl.seconds = cvUtil.calculateTimeInSecs(ctrl.selectedTimeM[0].value, ctrl.pickerNum);
                            }
                            ctrl.inputValue = `${ctrl.pickerNum} ${ctrl.selectedTimeM[0].label}`;
                            let selectedValues = {													// selectedValues = selected time-picker value, the time-picker unit
                                value: ctrl.pickerNum,
                                label: ctrl.selectedTimeM[0]
                            };
                            if(ctrl.validationFunc){                        						// call the custom method only when it is defined.
                                ctrl.validationFunc({"pickerId": ctrl.pickerId, "seconds": ctrl.seconds, "selectedValues": selectedValues});
                            }
                        }

                        const getTimefromSecs = (time) =>{
                            let unit = 3; // default unit - second
                            let value = 1;

                            if(time === 0){
                                //seconds
                                unit = 3;
                            }else if(!(time % (24*60*60)) ) {
                                // days
                                value = 24*60*60;
                                unit = 0;
                            }else if(!(time % (60*60))){
                                // hours
                                value = 60*60;
                                unit = 1;
                            }else if(!(time % 60)){
                                // minutes
                                value = 60;
                                unit = 2;
                            }
                            return [time/value, unit];
                        }

                        const init = () =>{
                            if(_.isUndefined(ctrl.defaultValues)){
                                if ( _.isUndefined(ctrl.seconds)){
                                    ctrl.seconds = 0;
                                }
                                ctrl.defaultValues = getTimefromSecs(ctrl.seconds);
                            }
                            ctrl.pickerNum = ctrl.defaultValues[0];
                            ctrl.timeM[ctrl.defaultValues[1]].selected = true;
                            ctrl.inputValue = `${ctrl.pickerNum} ${ctrl.timeM[ctrl.defaultValues[1]].label}`;
                        }
                        init();
                    };
                }
            ]
        }
    }
]

cvModuleSettingsModule.directive('cvTimeRelativePicker', cvTimeRelativePicker);
export default cvModuleSettingsModule;