/**
 * @author ssubash
 *
 * Registers all the components on Adminconsole.
 *
 * Use componentRegistry to access the components.
 * This will help us remove or add components without modifying the entire
 * code base
 */
import AutoComplete from './autocomplete';
import ContextMenu from './contextMenu';
import DatePicker from './datetimepicker';
import Dropdown from './dropdown';
import DateTimeDropdown from './datetimedropdown';
import Multiselect from './multiselect';
import { CheckBoxMultiSelect } from './multiselect';
import KendoGrid from './newGrid/kendoGrid';

const singleton = Symbol();
const singletonEnforcer = Symbol();

export default class ComponentRegistry {
	constructor(enforcer) {
		if (enforcer != singletonEnforcer) throw 'Component Registy already exists';
		this.components = new Map();
		this.components.set('autocomplete', AutoComplete);
		this.components.set('contextmenu', ContextMenu);
		this.components.set('dropdown', Dropdown);
		this.components.set('datetimedropdown', DateTimeDropdown);
		this.components.set('datepicker', DatePicker);
		this.components.set('dropdown', Dropdown);
		this.components.set('multiselect', Multiselect);
		this.components.set('checkboxmultiselect', CheckBoxMultiSelect);
		this.components.set('grid', KendoGrid);
	}

	get(key) {
		return this.components.get(key);
	}

	static get instance() {
		if (!this[singleton]) {
			this[singleton] = new ComponentRegistry(singletonEnforcer);
		}
		return this[singleton];
	}
}
