export default class CallOut {
	constructor(element, actions, isKendoGrid) {
        this.element = element;

        /*
		 * Array of action [{ actionSelector: valid CSS selector in call-out template, /* onClick:
		 * onClickCallBack}]
		 */
        this.actions = actions || [];


        /* use 'close-call-out' class in template for hiding call-out */
        this.actions.push({
            actionSelector: '.close-call-out',
            onClick: () => this.hideCallOut.call(this)
        });

        //overriding  default whiteList of sanitizer for popover
        const allowedGlobalAttr = _.get($, `fn.popover.Constructor.Default.whiteList['*']`);
        if (_.isArray(allowedGlobalAttr) && !_.includes(allowedGlobalAttr, 'title')) {
            allowedGlobalAttr.push('title');
        }

        this.callOutId = `callOut${Math.floor(Math.random() * Math.pow(10, 6))}`;
        this.isKendoGrid = _.isUndefined(isKendoGrid) ? true : isKendoGrid;
    }

	build() {
        this.selector = '[cv-toggle="callout"]';
        this.callOutContainer = '.wrapper-inner';
        this.callOutOptions = {
            container: this.callOutContainer,
            template:  `<div class="popover k-call-out ${this.callOutId}" role="tooltip">
                            <div class="arrow"></div>
                            <div class="popover-body"></div>
                        </div>`,
            trigger: 'manual',
            html: true,
            boundary: 'window',
            sanitize: false
        };

        this._attachEvents();

    }

    _isClickTrigger() {
        return this.currentTrigger === 'click';
    }

    _onCallOutTrigger(event) {

        const currentEvent = event.type;
        this.currentTrigger =  $(event.currentTarget).attr('data-trigger') || 'mouseenter';

        this.callOutOptions.placement = $(event.currentTarget).attr('data-placement') || 'top';

        if (this.currentTrigger !== currentEvent && currentEvent !== 'click') {
            return;
        }
        const showOnlyOnOverflow = $(event.currentTarget).attr('data-show-only-on-overflow') || false;
        if (showOnlyOnOverflow && event.currentTarget.scrollWidth <= event.currentTarget.clientWidth) {
            return;
        }

        this.hideExistingCallOut();

        this.currentCallOutTarget = $(event.currentTarget).popover(this.callOutOptions);
        this.currentCallOutTarget.popover('show');
        event.stopPropagation();
    }

    _onOutSideClick(event)  {

        if (!$(event.target).parents().is('.k-call-out')) {
            this.hideCallOut.call(this);
        }
    }

    _onMouseLeave() {
        //In IE, Prevent call-out destroy when hover is present on call-out -- setTimeout
        setTimeout(() => {
            if (this._isClickTrigger() || $('.k-call-out:hover').length) {
                return;
            }
            this.hideCallOut.call(this);
        }, 300);
    }
    
    _onMouseLeaveFromCallOut() {
        setTimeout(() => {
            if (this._isClickTrigger()) {
                return;
            }
            this.hideCallOut.call(this);
        }, 300);
    }

    _onGridOrDetailGridCellLeave(event) {

        if (this._isClickTrigger() || $(event.relatedTarget).parents('.k-call-out').length) {
            return;
        }

        this.hideCallOut.call(this);

    }

    _attachEvents() {

        //Adding namespace to events for safely unbinding it

        //Show call-out on click/hover
        this.element.on('click mouseenter', this.selector, this._onCallOutTrigger.bind(this));

        //Close existing call-out on outside click
        $('body').on(`click.${this.callOutId}`, this._onOutSideClick.bind(this)); //popover trigger


        // Prevent call-out destroy when hover is present on call-out
        this.element.on('mouseleave.callOut', this._onMouseLeave.bind(this));

        //Hide call-out when cursor leaves call-out
        $(this.callOutContainer).on(`mouseleave.${this.callOutId}`, '.k-call-out', this._onMouseLeaveFromCallOut.bind(this));


        //Hide call-out when cursor leaves grid -column element or detail-grid
        if (this.isKendoGrid) {
            $(this.callOutContainer).on(`mouseleave.${this.callOutId}`, 'td[cv-col-id],.k-detail-cell', this._onGridOrDetailGridCellLeave.bind(this));
        }

        this._registerActionEvents();

    }

    _registerActionEvents() {
        _.each(this.actions, action => {
            $(this.callOutContainer).on('click', `.k-call-out.${this.callOutId} ${action.actionSelector}`, event => {
                event.stopPropagation();
                const target = $($(event.target).parents('.k-call-out').data('bs.popover').element);
                action.onClick(target);
            });
        });
    }

    _removeActionEvents() {
        _.each(this.actions, action => {
            $(this.callOutContainer).off('click', `.k-call-out.${this.callOutId} ${action.actionSelector}`);
        });
    }

    hideExistingCallOut () {
        $('[cv-toggle="callout"]').each(function () {
            $(this).popover('hide');
        });
        this.hideCallOut();
    }
    update(target, content) {
        target.attr('data-content', content);
        $(target.data('bs.popover').tip).find('.popover-body').html(content);
        target.data('bs.popover')._popper.update();
    }

    hideCallOut() {
        this.currentCallOutTarget && this.currentCallOutTarget.popover('hide');
    }

    destroy() {
        this.hideExistingCallOut();
        this.element.off('click mouseenter', this.selector);
        $('body').off(`click.${this.callOutId}`);
        this.element.off('mouseleave.callOut');
        $(this.callOutContainer).off(`mouseleave.${this.callOutId}`, '.k-call-out');
        $(this.callOutContainer).off(`mouseleave.${this.callOutId}`, 'td[cv-col-id],.k-detail-cell');
        this._removeActionEvents();
    }

}
