import XmlToJson from './xmlToJson.js';
import * as Utils from '../utils/isXml.js';
export default function CreXMLConverter (input) {
    const result = [];
    let response = {
    		totalRecordCount: input.totalRecordCount
    };
    if(isEmpty(input)) {
        return result;
    }
    input.records.forEach(function(record) {
        const item = {};
        record.forEach(function(cell, index){
            if(input.columns.length != record.length) {
                throw new Error('Record schema mismatch: Number of columns is not equal to number of cells in record')
            }
            if(!validateSchema(input.columns[index]["type"], cell)){
                throw new Error(`Schema datatype mismatch 
                    DataType: ${input.columns[index]["type"]}
                    cell value: ${cell}
                    index: ${index}
                    name: ${input.columns[index]["name"]}
                `);
            }
            const key = input.columns[index]["name"];
            item[key] = Utils.isXml(cell)? XmlToJson(cell): cell;
        });
        result.push(item);
    });
    response.data = result;
    return response;
}

function isEmpty(input) {
    return _.isEmpty(input);
}

function validateSchema(type, value) {
    switch (type ) {
        case "String": return _.isString(value) || _.isEmpty(value);
        case "Integer": return _.isNumber(value) || _.isEmpty(value);
        case "Long": return _.isNumber(value) || _.isEmpty(value);
    }
}