import { cvCommonModule } from "common/js/modules";

const tileTEMPLATE = `
<div class="tile-accordion cv-accordion">
<div uib-collapse="ctrl.isCollapsed">
    <div data-ng-transclude></div>
</div>
<div class="cv-accordion-header" data-ng-class="{'expanded':!ctrl.isCollapsed}">
    <a href="" data-ng-click="ctrl.toggleCollapsed()"><span class="cv-accordion-text" data-ng-bind="ctrl.textMore"></span><span class="cv-accordion-icon k-icon k-i-arrow-chevron-down"></span></a>
</div>
</div>
`;

class tileAccordion {
    constructor(){
        this.bindToController = true,
        this.controllerAs = 'ctrl'
        this.replace = true,
        this.transclude = true,
        this.scope = {

        },
        this.template = tileTEMPLATE;
        this.controller = cvTileAccordionController;
        
    }
}

class cvTileAccordionController {
    constructor(cvLoc) {
        this.isCollapsed = true;
        this.textMore = cvLoc('label.More');
    }

    toggleCollapsed() {
        this.isCollapsed = !this.isCollapsed;
    }
}
cvTileAccordionController.$inject = ['cvLoc'];

cvCommonModule.directive("cvTileAccordion", ()=> new tileAccordion);
export default cvCommonModule;
