const plainTEMPLATE = `
<div class="plain-accordion cv-accordion" data-ng-disabled="ctrl.isDisabled" data-ng-class="{'no-accordion-style': ctrl.disableCollapse}">
<div class="cv-accordion-header" data-ng-class="{'expanded':!ctrl.collapsed}" data-ng-click="ctrl.toggleCollapsed()">
    <span class="cv-accordion-text" data-ng-if="ctrl.accordionLabel"><span ng-bind-html="ctrl.accordionLabel | localizedString"></span><cv-help-component help-text="{{ctrl.accordionHelpLabel | localizedString}}" help-placement="right" ng-if="ctrl.accordionHelpLabel"></cv-help-component></span>
    <span data-ng-if="!ctrl.disableCollapse" class="cv-accordion-icon k-icon k-i-arrow-chevron-down"></span>
</div>
<div uib-collapse="ctrl.collapsed && !ctrl.disableCollapse">
    <div class="cv-accordion-body row no-margin" data-ng-transclude></div>
</div>
</div>
`;

class cvPlainPanel {
    constructor($rootScope) {
        this.bindToController = true;
        this.controllerAs = 'ctrl';
        this.replace = true;
        this.transclude = true;
        this.scope = {
            accordionLabel: '@',
            accordionHelpLabel: '@',
            collapsed: '=?',
            isDisabled: '=',
            disableCollapse: '@'
        };
        this.template = plainTEMPLATE;
        this.controller = CvPlainAccordionController;
    }

    link(scope, attrs, ele, ctrl) {
        scope.$on("OpenOtherAccordions", (evt, data) => {
            ctrl.collapsed = true;
        });
    }

}

class CvPlainAccordionController {
    constructor($rootScope) {
        this.rootScope = $rootScope;
    }

    $onInit() {
        this.triggerCloseOthers = this._triggerCloseOthers.bind(this);
        this.collapsed = !_.isUndefined(this.collapsed) ? this.collapsed : true;
    }

    _triggerCloseOthers() {
        this.rootScope.$broadcast("OpenOtherAccordions", true);
    }

    toggleCollapsed() {
        if (this.collapsed) {
            this.triggerCloseOthers();
            this.collapsed = false;
        } else {
            this.collapsed = true;
        }
    }

}
CvPlainAccordionController.$inject = ['$rootScope'];
export default ["cvPlainAccordion", () => new cvPlainPanel()];
