<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<%@ taglib prefix="enhance" uri="/WEB-INF/webenhance.tld" %>
<%@ taglib uri="https://github.com/d8bitr/packtag" prefix="cvpack" %>
<c:set var="appName" value="${cvSessionContext.acApp.appBase}" />
<c:set var="appLabel" value="${cvSessionContext.acApp.appLabel}" />
<!doctype html>
<html lang="en" data-ng-app="acApp" ng-strict-di>
<head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
	<meta charset="utf-8">
	<meta name="description" content="AdminConsole">
	<meta name="viewport" content="width=device-width">
	<meta http-equiv="Cache-Control" content="no-cache, no-store, must-revalidate" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Expires" content="0" />
	<jsp:include page="favicon.jsp"></jsp:include>
    <title data-ng-bind="(title || '<cv:msg key="label.commandCenter" bundle="messagesJs"/>')"></title>
	<!-- this will normalize all css styles -->
	<!-- <link rel="stylesheet" href="common/css/vendor/normalize.min.css"> -->
	<style>
		#initial-loading-screen {
		    position: fixed;
		    width: 100%;
		    height: 100%;
		    left: 0;
		    top: 0;
		    background: rgba(51,51,51,0.7);
		    z-index: 1000;
			background-color: #0B2E44;
			opacity: 1;
			display:block;
		}
		.center-loading-screen {
			text-align: center;
			width:100%;
			position:absolute;
			top:30%;
		}
		.loading-text{
			color: white;
		}
		.loading-spinner .loading1{
			stroke: white;
			stroke-width: 6px;
			stroke-linecap: round;
			fill:transparent;
			-webkit-animation: circle-ani 3s ease-in-out infinite;
			animation: circle-ani 3s ease-in-out infinite;
		}
		.loading-spinner .loading2{
			display:none;
			width:250px;
			margin:3em auto;
			-webkit-animation: loading2 2s linear infinite;
			animation: loading2 2s linear infinite;
		}
		@media screen and (-ms-high-contrast: active), (-ms-high-contrast: none) {
			.loading-spinner .loading1 {
				display:none;
			}
			.loading-spinner .loading2 {
				display:block;
			}
		}
		.cls-cirl {
			fill: #fff;
		}
		.cls-loding2 {
			fill:#0B2E44;
		}
		.loader-logout-link {
			float: right;
			padding: 20px;
		}
		.loader-logout-link, .loader-logout-link:hover, .loader-logout-link:focus {
			color: white;
		}
		#initial-loading-check:checked ~ #initial-loading-screen {
			-webkit-animation: hide-loading 0.5s ease forwards;
			animation: hide-loading 0.5s ease forwards;
			pointer-events: none;
		}
		@keyframes loading2{
			from {
				-webkit-transform: rotate(0deg);
				transform: rotate(0deg);
			}
			to {
				-webkit-transform: rotate(0deg);
				transform: rotate(360deg);
			}
		}
		@keyframes circle-ani {
			0% {
				stroke-dashoffset: 0;
				stroke-dasharray: 296 296;
				-webkit-transform: rotate(0deg);
				transform: rotate(0deg);
			}
			100% {
				stroke-dashoffset: -587;
				stroke-dasharray: 296 296;
				-webkit-transform: rotate(360deg);
				transform: rotate(360deg);
			}
		}
		@keyframes hide-loading {
			0% {
				opacity: 1;
			}
			70% {
				opacity: 0;
			}
			72%,100% {
				opacity:0;
				display:none;
			}
		}
	</style>

    <cvpack:style prefix="vendor.min" enabled="${cvConfig.isDevMode() eq 'false'}">
        <src>/lib/bower_components/angular-loading-bar/build/loading-bar.min.css</src>
        <src>/lib/bower_components/select2/select2.css</src>
        <src>/lib/loading-bar/loading-bar.custom.min.css</src>
        <src>/lib/ng-grid/ng-grid.min.css</src>
        <src>/lib/ng-grid/ng-grid.custom.css</src>
        <src>/lib/bower_components/angular-ui-grid/ui-grid.min.css</src>
        <src>/lib/bower_components/angular-growl/build/angular-growl.min.css</src>
        <src>/lib/bower_components/angular-awesome-slider/dist/css/angular-awesome-slider.min.css</src>
        <src>/lib/bower_components/angular-ivh-treeview/dist/ivh-treeview.min.css</src>
        <src>/lib/bower_components/angular-ivh-treeview/dist/ivh-treeview-theme-basic.css</src>
        <src>/lib/bower_components/ng-sortable/dist/ng-sortable.min.css</src>
        <src>/lib/bower_components/isteven-angular-multiselect/isteven-multi-select.css</src>
        <src>/lib/bower_components/angular-dragula/dist/dragula.min.css</src>
        <src>/lib/bower_components/Ionicons/css/ionicons.min.css</src>
        <src>/lib/scrollbar/css/perfect-scrollbar.min.css</src>
        <src>/lib/angular-bootstrap-colorpicker/css/colorpicker.min.css</src>
        <src>/common/kendoui/styles/kendo.common.min.css</src>
        <src>/common/kendoui/styles/kendo.common-bootstrap.min.css</src>
        <src>/common/kendoui/styles/kendo.bootstrap.min.css</src>
        <src>/lib/mapbox/mapbox.css</src>
	</cvpack:style>
    <link rel="stylesheet" href="${pageContext.request.contextPath}/common/uiMode.css.do?${applicationScope.BUILD_TS}">
    <link rel="stylesheet" href="${pageContext.request.contextPath}/bareFrameMode.css.do">
    <link rel="stylesheet" href="${pageContext.request.contextPath}/bareFrameNavMode.css.do">
    <link rel="stylesheet" href="${pageContext.request.contextPath}/common/css/template.css?${applicationScope.BUILD_TS}">
	<link rel="stylesheet" href="${pageContext.request.contextPath}/OEM/${cvAppContext.oemId}/css/override.css?${applicationScope.BUILD_TS}">
    <link rel="stylesheet" href="${pageContext.request.contextPath}/common/customTheme.do?${applicationScope.BUILD_TS}">
	<link rel="stylesheet" href="${pageContext.request.contextPath}/centralizeModalMode.css.do">

	<c:if test="${cvSessionContext.nav != null}">
		<script nonce="${sessionScope.cspNonce}" >
			<enhance:out escapeXml="false">
				var localMsg={};
				var enumMap={};
				var cv = cv || {};
				var cvConfig;
				var cvApp;
				var capabilities = capabilities || {};
				<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>;
				<cv:cvMessages bundle="localization.actions"></cv:cvMessages>;
				<cv:cvEnum name="ACApp" enumPackage="commvault.web.users"></cv:cvEnum>;
				<cv:cvEnum name="Api.SupportedSolutionsBitValue"></cv:cvEnum>;
				cv.nav = ${cvSessionContext.nav};
				cv.contextPath = '${pageContext.request.contextPath}';
				cv.theme = '${cvSessionContext.theme}';
				cv.userPref = ${loginContext.userPref.userSettingsAsJson};
				cv.additionalSettings = ${loginContext.userPref.additionalSettingsAsJson};
				cv.loggedInUserSmtp = "${loginContext.userInfo.smtpAddress}";
				cv.loginName = "${loginContext.userEntity.getLoginName()}";
				cv.userGUID = "${loginContext.getUserGUID()}";
				cv.isDomainUser = ${loginContext.domainUser};
				cv.isPasswordChangeAllowed = !cv.isDomainUser || ${loginContext.orgUser};
				cv.isPasswordChangeAllowed = !${loginContext.domainUser};
				cv.sessionContext = ${cvSessionContext.toJson()};
				cvConfig=${cvConfig.cvConfigAsJson};
				cvApp=${cvAppContext.cvAppAsJson};
		        cv.isExpressOEM=${cvAppContext.expressOEM};
		        cv.oemName="${cvAppContext.oemName}";
				cv.timeZone = "${loginContext.csInfo.ccTimeZone}";
				cv.timeZoneId = "${loginContext.csInfo.ccTimeZoneId}";
				cv.ccId = "${loginContext.csInfo.ccId}";
				cv.currentSP = "${loginContext.csInfo.currentSPVersion}"
				cv.isAdmin = ${loginContext.admin};
				cv.isMspAdmin = ${loginContext.isMspAdmin()};
				cv.isUserOnlyMspAdmin = ${loginContext.isUserOnlyMspAdmin()};
				cv.isTenantAdmin = ${loginContext.isTenantAdmin()};
				cv.isUserOnlyTenantAdmin = ${loginContext.isUserOnlyTenantAdmin()};
				cv.isTenantOperator = ${loginContext.isTenantOperator()};
				cv.isReseller = ${loginContext.isReseller()};
				cv.isTenantUser = ${loginContext.isTenantUser()};
				cv.isEdgeOEM=${cvAppContext.edgeOEM};
				cv.isAdminOnCommcellLevel = ${loginContext.isAdminOnCommcellLevel()};
				cv.isOnCommcellLevel = ${loginContext.isAdminOnCommcellLevel() || loginContext.isMspUser()};
				cv.isMspUser = ${loginContext.isMspUser()};
				cv.locale="${cvSessionContext.locale}";
				cv.commcellName="${loginContext.csInfo.ccName}";
				cv.providerId = ${loginContext.getProviderId()};
				cv.commcellHex = "${cvAppContext.commcellHex}";
				cv.userRole = "${loginContext.getUserMappings().getUserRole()}";
				cv.isGlobalNavSettingPresent = ${loginContext.getUserMappings().getIsGlobalNavSettingPresent()};
				cv.loggedInUserId = '${loginContext.userEntity.userId}';
				cv.loggedInUserName = '${loginContext.userEntity.escapedUserName}';
				cv.isNewUserSession = ${loginContext.isNewUserSession()};
				cv.csEnvironmentInfo = ${cvAppContext.csEnvironmentInfo};
				cv.orgId= ${loginContext.getOrganizationId()};
				cv.userPermissions = ${loginContext.getUserPermissions()};
				capabilities.hasAgentManagementCapability = ${loginContext.hasCapability(2)};
				capabilities.hasDownloadCapability = ${loginContext.hasCapability(6)};
				if(cvConfig.showOperators) {
					cv.providers = ${loginContext.providerList};
					cv.deactivatedProviders = ${loginContext.deactivatedProviderList};
				} else {
					cv.providers = [];
					cv.deactivatedProviders = [];
				}
				cv.localeObj=${loginContext.currentLocale};
				cv.mutationsBlocked = ${loginContext.isUserBlockedForMutations()};
				cv.isCometApp = cv.contextPath === '/global';
				var System = cv;
			</enhance:out>
		</script>
	</c:if>
	<c:if test="${cvSessionContext.nav == null}">
		<script nonce="${sessionScope.cspNonce}" >
			window.location.href = "logout.do";
		</script>
	</c:if>
	<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
		<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.job"></cv:cvMessages>
		<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.events"></cv:cvMessages>
		<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.reports"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.browse"></cv:cvMessages>
		<cv:cvMessages bundle="localization.users"></cv:cvMessages>
		<cv:cvMessages bundle="localization.actions"></cv:cvMessages>
		<cv:cvMessages bundle="localization.office365"></cv:cvMessages>
		<cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
		<cv:cvMessages bundle="localization.dr"></cv:cvMessages>
		<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.archiving"></cv:cvMessages>
	</script>
	<c:if test="${cvSessionContext.theme != null}">
	<script nonce="${sessionScope.cspNonce}">
		<%-- theme.toJson uses GSON which escapes single quotes so this should be safe --%>
		localStorage.setItem("customTheme", '${cvSessionContext.theme.toJson()}');
	</script>
	</c:if>
</head>
<body data-ts="${ts}">
	<input type="checkbox" id="initial-loading-check"/>
	<div id="initial-loading-screen" >
		<div class="center-loading-screen">
			<div>
				<div class="loading-spinner">
					<svg class="loading1" width="250px" height="250px" viewBox="0 0 100 100"><circle cx="50" cy="50" r="40"></circle></svg>
					<svg class="loading2" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 250 250">
                    	<path class="cls-cirl" d="M210.06,123A85.83,85.83,0,0,0,126.2,40.29l-2,0a85.83,85.83,0,0,0-85.51,78.92l-19.09-.41A104.85,104.85,0,0,1,124.29,19.91h1.05a105,105,0,0,1,103.8,103.5Z" transform="translate(1 1)"/>
						<path class="cls-loding2" d="M32.45,198.82A118.1,118.1,0,0,1,20,178.33l41-19.5A72.54,72.54,0,1,0,192.22,97h0l-.31-.66L233.05,76.7A118.1,118.1,0,0,1,32.45,198.82Z" transform="translate(1 1)"/>
					</svg>
				</div>
		    	<h1 class="loading-text">
		      		<cv:msg key="Loading" bundle="messages" />
		    	</h1>
		 	</div>
	 	</div>
		<a class="loader-logout-link" href="logout.do">Logout</a>
	</div>
