<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-md-12">
		<cv-changename obj="ctrl.changeNameObj" data-service-method="renameSubclient.do" class="float-left"></cv-changename>
		<span class="server-message {{ctrl.serverMessage.type}}" data-ng-bind="ctrl.serverMessage.message" ></span>
	</div>
</div>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="bigDataSubclientDetails" data-title='<cv:msg key="heading.clientGeneral" bundle="clients" />'  data-loader="ctrl.subclientDetails">
			<ul data-ng-if="ctrl.subclientDetails" class="group list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.instanceName" bundle="clients" /></span>
					<span class="pageDetailColumn" data-ng-bind="ctrl.subclientDetails.subClientEntity.instanceName"></span>
				</li>
				
				<!--BACKUP STREAMS-->
						<li id="backupStreams" class="group" data-ng-if="ctrl.showBackupStreams">
							<span class="pageDetailColumn"><cv:msg key="label.dataBackupStreams" bundle="capps" /></span>
							<span class="pageDetailColumn">
								<span data-ng-bind="ctrl.maxBackupStreams"> </span>
								<span class="float-right tile-content-link" >
									<a data-ng-click="ctrl.editBackupStreams(true)">
										<cv:msg key="label.edit" bundle="clients" />
									</a>
								</span>
							</span>
						</li>
						<li id="editBackupStreams" class="group"  data-ng-if="!ctrl.showBackupStreams">
							<span class="pageDetailColumn"><cv:msg key="label.dataBackupStreams" bundle="capps"/></span>
							<span class="pageDetailColumn inline-editor">
								<div class="inline-editor-input">
									<input class="half-width" type="number" min=2 max="9999" id="maxStream" data-ng-model="ctrl.maxBackupStreams">
								</div> 
								<span class="inline-editor-buttons" data-ng-disabled="ctrl.isLoading">
									<a class="inline-editor-button"  ng-click="ctrl.updateBackupStreams(maxBackupStreams)"><span class="k-icon k-i-check"></span></a>
									<a class="inline-editor-button"  ng-click="ctrl.editBackupStreams(false)"><span class="k-icon k-i-x"></span></a>
								</span>
							</span>
							<div class="help-block margin-top-10" data-ng-show="ctrl.errorMaxStreams"> <cv:msg key="error.max.streams.that.can.be.used" bundle="sharepoint" /></div>
						</li>
						<!--BACKUP STREAMS-->
				
				
				<cv-activity-control label='<cv:msg key="label.backupEnabled" bundle="clients" />' help-text='<cv:msg key="info.help.dataBackup" bundle="clients"/>' ac-params="ctrl.subclientDetails.subClientEntity" enable-backup="ctrl.subclientDetails.commonProperties.enableBackup" enable-delay="ctrl.subclientDetails.commonProperties.enableBackupAfterDelay" delay-time="ctrl.subclientDetails.commonProperties.enableBackupAtDateTime"> </cv-activity-control>
			</ul>
		</cv-tile-component>
	</div>
	
	<div class="col-md-6">
		<cv-tile-component data-ac-id="bigDataSubclientBackuptile" data-ng-show="ctrl.subclientDetails" data-title='<cv:msg key="label.backup" bundle="collections" />'>
			<ul class="serverBackupTile">
				<li><span class="page-details-box-links multiLinks">
					<ul>
						<li data-ng-if="ctrl.showBackup['backup'] && ctrl.backupEnabledStatusInfo!= 'disabled-activity'" class="restoreli"  data-ng-click="ctrl.showBackupOptions()"><a href=""><cv:msg key="action.backupNow" bundle="collections" /></a></li>
						<li><a data-ng-href="#jobs?collectionId={{ctrl.subclientDetails.subClientEntity.subclientId}}&collectionName={{ctrl.changeNameObj.name}}&jobType=Backup"><cv:msg key="action.jobs" bundle="servers" /></a></li>
					</ul>
				</span></li>
				<li data-ng-if="ctrl.showBackup['backup']">
					<p class="info-place-holder">	<cv:msg key="info.nobackupRunning" bundle="collections" /></p>
				</li>
				<li data-ng-if="ctrl.showBackup['submittingJob']">
					<p class="info-place-holder"><cv:msg key="info.submittingJob" bundle="collections" /></p>
				</li>
				<li data-ng-if="ctrl.backupJobs.length>0"><data-cv-job jobs='ctrl.backupJobs' show-backup='ctrl.showBackup'></data-cv-job></li>
			</ul>
		</cv-tile-component>
	</div>
</div>
