<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.genApp"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 ng-bind="ctrl.titleText"></h1>
</div> 
<div class="setup-content">
	<div class="serverMessage" ng-class="ctrl.serverMessage.type" ng-bind="ctrl.serverMessage.message"></div>
	<div class="modal-list bootstrap-wrapper">
		<form id="addDataCenterForm" name="addDataCenterForm" cv-submit="ctrl.addDataCenter()" novalidate autocomplete="off">
			<div class="form-group row" ng-if="!ctrl.isEditMode">
				<label class="col-xs-12 col-sm-4" for="dcName"><cv:msg key="tableHeading.name" bundle="bigData" /></label>
				<div class="col-xs-12 col-sm-8">
					<input type="text" id="dcName" name="dcName" ng-model="ctrl.dcName" />
					<span class="help-block" data-ng-show="ctrl.inputAlertFlags.dcName"><cv:msg key="error.subclientName" bundle="clients" /></span>
				</div>
			</div>
			<div class="form-group row" ng-if="!ctrl.isEditMode">
				<label for="plans" class="col-xs-12 col-sm-4"><cv:msg key="label.profile" bundle="profiles"/></label>
				<div class="col-xs-12 col-sm-8">
					<isteven-multi-select id="splunkAddSubclient_isteven-multi-select_#4438"  
						input-model="ctrl.planList" 
						output-model="ctrl.selectedPlanList" 
						button-label="planName" 
						item-label="planName" 
						tick-property="selected"
						class="isteven-multi-select user-group-select" 
						helper-elements="none" 
						selection-mode="single" 
						on-close="ctrl.parseIStevenOutput()" 
						translation="ctrl.localLang" 
						group-property="msGroup">
					</isteven-multi-select>
					<span class="help-block" ng-show="ctrl.inputAlertFlags.plan"><cv:msg key="error.selectPlan" bundle="profiles"/></span>
				</div>
			</div>
			<div class="cv-modal-wrapper">
				<cv-grid cv-grid-options="ctrl.cvGridOptions" ng-if="ctrl.cvGridOptions"></cv-grid>
				<span class="help-block" ng-show="ctrl.inputAlertFlags.content"><cv:msg key="error.content" bundle="genApp"/></span>
			</div>
			<div class="button-container">
				<button id="splunkAddSubclient_button_#1796" type="button" class="btn btn-default cvBusyOnAjax" ng-click="ctrl.dismissModal()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
				<button id="splunkAddSubclient_button_#4681" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles"/></button> 
			</div>
		</form>
	</div>
</div>