<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
    <cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.restore"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
    <cv:cvMessages bundle="localization.sqlserver"></cv:cvMessages>
    <cv:cvMessages bundle="localization.capps"></cv:cvMessages>
</script>
<div class="setup-title">
    <h1><cv:msg key="header.restore" bundle="serversJs"/></h1>
</div>
<div ng-init="ctrl.init()">
    <div class="serverMessage" ng-class="ctrl.serverMessage.type" ng-bind="ctrl.serverMessage.message"></div>

    <form id="restoreHadoopForm" class="bootstrap-wrapper min-tab form-horizontal edit-users-grid-form" name="restoreBigDataForm" cv-submit="ctrl.restore()" autocomplete="off">

    <div data-ng-if="ctrl.instancesLoaded">
        <div id="modern-tab" class="tab-3" >
           <cv-tabset-component control='ctrl.tabControls' default-tab="ctrl.tabControls.defaultTab">
                <!--
                ****************************************************************************
                In  Place Restore
                ****************************************************************************
                -->
                <cv-tab tabname='<cv:msg key="label.restoreInPlace" bundle="restore" />' data-ng-selected="ctrl.onTabChanged()">
                    <div data-ng-disabled="!ctrl.restoreOptions.outOfPlaceRestore" class="margin-top-20  min-height-0">
                        <div class="form-group row" >
                            <label class="col-xs-12 col-sm-4" for="destinationCluster"><cv:msg key="label.destinationClusterServer" bundle="bigData" /></label>
                             <label class="col-xs-12 col-lg-7 label-as-input">
                                 {{ctrl.selectedClientName}}
                             </label>
                        </div>
                    </div>

                </cv-tab>
                <!--
                ****************************************************************************
                Out of Place Restore:
                ****************************************************************************
                -->
                <cv-tab tabname='<cv:msg key="label.OOPRestore" bundle="restore" />' data-ng-selected="ctrl.onTabChanged()">
                    <div class="margin-top-20" >
                        <div class="form-group row" >
                            <label class="col-xs-12 col-sm-4" for="OOPdestinationClusterServer"><cv:msg key="label.destinationClusterServer" bundle="bigData" /></label>
                            <div class="col-xs-12 col-sm-8" ng-if="ctrl.instanceList" >
                                <isteven-multi-select
                                    id="OOPdestinationClusterServer"
                                    input-model="ctrl.clients"
                                    output-model="ctrl.restoreOptions.selectedClient"
                                    button-label="clientName"
                                    item-label="clientName"
                                    search-property="clientName"
                                    selection-mode="single"
                                    on-item-click="ctrl.clickDestinationClient(data)"
                                    helper-elements="all none filter"
                                    disable-property="disabled"
                                    tick-property="selected">
                                </isteven-multi-select>
                                <span class="help-block" data-ng-show="ctrl.inputAlertFlags.OOPdestinationClusterServer"><cv:msg key="error.destinationClusterServer" bundle="bigData" /></span>
                            </div>
                        </div>

                        <!-- Out of place path-->
                        <div ng-if= "ctrl.backupsetType !== 'HBase'"class="form-group row" >
				            <label for="OOPPath" class="col-xs-12 col-md-4 col-lg-4">
				            	<cv:msg key="label.path" bundle="restore" />
				            </label>
				            <div class="col-xs-12 col-md-8 col-lg-8">
				                <div class="input-group">
				                    <input type="text" name="OOPPath" id="OOPPath" data-ng-class="text-right"
				                    data-ng-model="ctrl.restoreToDiskPath" data-ng-change="ctrl.inputAlertFlags.OOPPath = false;" >

				                    <span class="input-group-btn">
				                         <button id="BrowsePath" type="button" data-ng-click="ctrl.browseClient('OOPPath')" class="btn btn-default browse-btn">
				                        <cv:msg key="action.browse" bundle="bigData"/></button>
				                    </span>
				                </div>
				                <span class="help-block" ng-show="ctrl.inputAlertFlags.OOPPath"><cv:msg key="error.stagingLocation" bundle="bigData" /></span>
				            </div>
				        </div>

                    </div>

                </cv-tab>

                <!--
                ****************************************************************************
                Restore to file system
                ****************************************************************************
                -->
                <cv-tab ng-if="ctrl.fsClients && ctrl.fsClients.length >0 && ctrl.backupsetType !== 'HBase'" tabname='<cv:msg key="label.restoreToFileSystem" bundle="restore" />' data-ng-selected="ctrl.onTabChanged()">

                  <div class="margin-top-20">

                        <div class="form-group row" >
                            <label class="col-xs-12 col-sm-4" for="destinationCluster"><cv:msg key="label.destinationClient" bundle="sqlserver" /></label>
                            <div class="col-xs-12 col-sm-8">
                                <isteven-multi-select
                                    id="bigDataRestoreOptionsModal_isteven-multi-select_#6205"
                                    directive-id="destinationClient"
                                    input-model="ctrl.fsClients"
                                    output-model="ctrl.restoreOptions.selectedClient"
                                    button-label="clientName"
                                    item-label="clientName"
                                    search-property="clientName"
                                    selection-mode="single"
                                    on-item-click="ctrl.clickDestinationClient(data)"
                                    helper-elements="all none filter"
                                    tick-property="selected"
                                    translation="localLangFs">
                                </isteven-multi-select>
                                <span class="help-block" data-ng-show="ctrl.inputAlertFlags.fsdestinationCluster"><cv:msg key="error.destinationClusterServer" bundle="bigData" /></span>      
                            </div>
                        </div>
                        <!-- Restore to DISK Path-->
                        <div class="form-group row" >
				            <label for="restoreToDiskPath" class="col-xs-12 col-md-4 col-lg-4">
				            	<cv:msg key="label.path" bundle="restore" />
				            </label>
				            <div class="col-xs-12 col-md-8 col-lg-8">
				                <div class="input-group">
				                    <input type="text" name="restoreToDiskPath" id="restoreToDiskPath" data-ng-class="text-right"
				                    data-ng-model="ctrl.restoreToDiskPath" data-ng-change="ctrl.inputAlertFlags.restoreToDiskPath = false;" >

				                    <span class="input-group-btn">
				                         <button id="Browse" type="button" data-ng-disabled="!ctrl.selectedClientId" data-ng-click="ctrl.browseClient('restoreToDiskPath')" class="btn btn-default browse-btn">
				                        <cv:msg key="action.browse" bundle="bigData"/></button>
				                    </span>
				                </div>
				                <span class="help-block" ng-show="ctrl.inputAlertFlags.restoreToDiskPath"><cv:msg key="error.stagingLocation" bundle="bigData" /></span>
				            </div>
				        </div>
                  </div>
                </cv-tab>
            </cv-tabset-component>
        </div>

       <div class="form-group row" >

            <cv-plain-accordion ng-if="ctrl.restoreOptions.outOfPlaceRestore  && ctrl.backupsetType == 'HBase' && ctrl.dataTables.length > 0" accordion-label="label.tableDetails" collapsed="ctrl.collapsetableDetails">

                <div class="hadoop-wrapper">
					<div class="destinationTable">
	                    <table class="destinationList" >
			                    <thead>
			                        <tr class="heading">
			                            <th class="dataTabelLabel" data-ng-bind="'<cv:msg key="label.sourceTableName" bundle="restore"/>'"></th>
			                            <th class="dataTabelLabel" id="destinationTableLabel" data-ng-bind="'<cv:msg key="label.destinationTableName" bundle="restore"/>'"></th>
			                        </tr>
			                    </thead>
			                    <tbody>
			                        <tr data-ng-repeat="dataTable in ctrl.dataTables">
			                            <td class="sourceTableName" title="{{dataTable.sourceTableName}}" data-ng-bind="dataTable.sourceTableName" >
	                                	</td>
			                            <td class="destinationInput">
			                            	<input class="input" type="text" id={{dataTable.id}}
	                                     	name="{{dataTable.destinationTableName}}"
	                                      	data-ng-model="dataTable.destinationTableName"
	                                      	data-ng-change="ctrl.verifyDestinationtableName(dataTable.destinationTableName,dataTable.id)"
								  			/>
								  			<span class="help-block" ng-show="ctrl.inputAlertFlags.{{dataTable.id}}"><cv:msg key="error.destinationTableName" bundle="restore" /></span>
								  		</td>
			                        </tr>
			                    </tbody>
		                </table>
	               </div>
                </div>

            </cv-plain-accordion>
        </div>

		<div class="form-group row">
			<div class="col-xs-12">
				<input name="overwrite" id="overwrite" type="checkbox"  data-ng-model="ctrl.restoreOptions.overwrite">
				<label for="overwrite" class="overwriteLabel"><cv:msg key="warning.overwrite" bundle="restore"/></label>
			</div>
		</div>
        <div class="form-group row">
            <div class="col-xs-12"><cv-alert-me selected="false" text="<cv:msg key='label.notifyUserOnJobCompletion' bundle='messages'/>"></cv-alert-me></div>
        </div>

    </div>

	<div class="modal-footer">
        <button id="bigDataRestoreOptionsModal_button_hadoop" type="button" class="btn btn-default cvBusyOnAjax" ng-click="ctrl.dismiss()"><cv:msg key="Cancel" bundle="messages"/></button>
        <button id="bigDataRestoreOptionsModal_button_hadoop_OK" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="OK" bundle="messages"/></button>
    </div>

    </form>

</div>
