<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
    <cv:cvMessages bundle="localization.servers"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
    <cv:cvMessages bundle="localization.restore"></cv:cvMessages>
    <cv:cvMessages bundle="localization.alerts"></cv:cvMessages>
    <cv:cvMessages bundle="localization.users"></cv:cvMessages>
    <cv:cvMessages bundle="localization.subscriptions"></cv:cvMessages>
</script>
    <div class="panel panel-default">
    <div class="panel-body">
    <div class="bootstrap-wrapper form-horizontal padding-bottom-0">
    <form id="createMongoDBGeneral" name="createMongoDBGeneral" autocomplete="off"
    novalidate>

        <div class="form-group">

            <label class="col-xs-12 col-sm-4" for="name">
                <cv:msg key="lable.clusterName" bundle="bigData" />
            </label>
            <div class="col-xs-12 col-sm-8">
                <input type="text" name="clientName" data-ng-class="text-right" id="name" data-ng-model="model.clientName" data-ng-change="inputAlertFlags.clientName = false" required autofocus />
                <span class="help-block" data-ng-show="inputAlertFlags.clientName"><cv:msg key="error.clustername" bundle="bigData" /></span>
            </div>
        </div>

        <div class="form-group">
            <label class="col-xs-12 col-sm-4" for="clientNode">
                <cv-help-text help-label="label.masterNode" help-text="helpText.mongoDBclientNode" />
            </label>
            <div class="col-xs-12 col-sm-7">
                <isteven-multi-select 
                    input-model="dummyModel.distClients" 
                    output-model="model.clientNode" 
                    tick-property="selected"
                    item-label="clientName" 
                    class="isteven-multi-select user-group-select"
                    on-item-click="clickClientNode()" 
                    button-label="clientName" 
                    id="mongoDBClients"
                    helper-elements="filter"
                    selection-mode="single" 
                    translation="localLangMasterNode" 
                    disable-property="disabled">
                </isteven-multi-select>

                <span class="help-block" data-ng-show="inputAlertFlags.clientNode"><cv:msg key="error.mongoDBmasterNode" bundle="bigData" /></span>

            </div>
            <div class="col-xs-12 col-sm-1 padding-left-0" >
                <span class="input-group-btn">
                    <button id="btnAddNewMasterNode"
                        type="button"
                        class="icon-style cv-material-button browse"
                        data-ng-click="openPushInstallDialog()">
                        <div class="cv-material-button-icon cursor-pointer">
                            <span class="k-icon k-i-plus font-size-page-title primary-theme-color cursor-pointer"> </span>
                        </div>
                    </button>
                </span>
            </div>
        </div>

	    <div class="form-group">
            <label for="binPath" class="col-xs-12 col-md-4 col-lg-4"><cv-help-text help-label="label.binaryPath" help-text="helpText.mongobinPath" /></label>
            <div class="col-xs-12 col-md-8 col-lg-8">
                <div class="input-group">
                    <input type="text" name="binPathConfigured" id="binpath" data-ng-class="text-right" data-ng-model="model.binPath" data-ng-change="inputAlertFlags.binPath = false" required autofocus >
                    <span class="input-group-btn">
                         <button id="Browse" type="button" data-ng-click="browseClient(model.clientNode)" class="btn btn-default browse-btn">
                        <cv:msg key="action.browse" bundle="bigData"/></button>
                    </span>
                </div>
                <span class="help-block" ng-show="inputAlertFlags.binPath"><cv:msg key="error.binPath" bundle="bigData" /></span>
            </div>
        </div>



        <div class="form-group">
            <label class="col-xs-12 col-sm-4" for="osUserName">
                <cv-help-text help-label="label.osUserName" help-text="helpText.mongoDBosUserName" />
            </label>
            <div class="col-xs-12 col-sm-8">
                <input type="text" name="osUserName" data-ng-class="text-right" id="osUserName" data-ng-model="model.osUserName" data-ng-change="inputAlertFlags.osUserName = false" required autofocus />
                <span class="help-block" data-ng-if="inputAlertFlags.osUserName"><cv:msg key="error.mongoDBosUserName" bundle="bigData" /></span>
            </div>
        </div>



        <div class="form-group">
            <label class="col-xs-12 col-sm-4" for="portNumber">
                <cv-help-text help-label="label.portNumber" help-text="helpText.mongoDBPortnumber" />
            </label>
            <div class="col-xs-12 col-sm-8">
                <input type="number" name="portNumber" data-ng-class="text-right" id="portNumber" data-ng-model="model.portNumber" data-ng-change="inputAlertFlags.portNumber = false" required autofocus >
                <span class="help-block" data-ng-if="inputAlertFlags.portNumber"><cv:msg key="error.mongoDBportNumber" bundle="bigData" /></span>
            </div>
        </div>

        <uib-accordion close-others="true"  class="text-left margin-top-20">
            <div uib-accordion-group data-is-open="accordionStatus.additionalTab" data-scroll-to-when-open >
                <uib-accordion-heading>
                <cv:msg key="heading.dbAuthentication" bundle="bigData"/> <span class="optional-text">
                    <cv:msg key="label.optional" bundle="subscriptions" /></span>
                 <i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': accordionStatus.additionalTab, 'glyphicon-chevron-right': !accordionStatus.additionalTab}"></i>
                 </uib-accordion-heading>

			<div class="form-group">
	            <label class="col-xs-12 col-sm-4" for="DBUsername">
	                <cv:msg key="label.DBUsername" bundle="bigData" />
	            </label>
	            <div class="col-xs-12 col-sm-8">
	                <input type="text" name="dbUsername" data-ng-class="text-right" id="dbUsername" data-ng-model="model.dbUsername" autocomplete="off"  >
	            </div>
	        </div>

             <div class="form-group">
                 <label class="col-xs-12 col-sm-4" for="DBPassword">
                     <cv:msg key="label.DBPassword" bundle="bigData" />
                 </label>
                 <div class="col-xs-12 col-sm-8">
                     <input type="password" name="dbPassword" data-ng-class="text-right" id="dbPassword" data-ng-model="model.dbPassword" autocomplete="off"  >
                 </div>
             </div>
            </div>
        </uib-accordion>

        <div class="form-group">
            <label class="col-xs-12 col-sm-4" for="plan">
                <cv:msg key="label.plan" bundle="bigData" />
            </label>
            <div class="col-xs-12 col-sm-8">
                <isteven-multi-select
                    input-model="dummyModel.plans"
                    output-model="model.plan"
                    tick-property="selected"
                    item-label="planName"
                    class="isteven-multi-select user-group-select"
                    on-item-click="clickPlan()"
                    button-label="planName"
                    id="plan"
                    helper-elements="filter"
                    selection-mode="single"
                    translation="localLangPlan"
                    disable-property="disabled"
                    >
                </isteven-multi-select>
                <span class="help-block" data-ng-show="inputAlertFlags.plan"><cv:msg key="error.plan" bundle="bigData" /></span>
            </div>
        </div>
        </form>
    </div>
    </div>
    </div>

