<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
</script>

<div data-ng-class="{'col-md-offset-1': addBigDataApp.isSetup && !addBigDataApp.hideForm}">

	<div class="row bootstrap-wrapper form-horizontal padding-bottom-0">
		<div ng-class="addBigDataApp.isSetup ? 'col-xs-12 col-md-6 col-md-offset-3' : 'col-xs-12 col-md-8 col-md-offset-2'"
			data-ng-hide="addBigDataApp.hideForm">
			<h1 ng-bind="addBigDataApp.headerTitle" class="margin-bottom-20"></h1>
			<form class="create-bigDataAttributes-form"
				data-cv-submit="addBigDataApp.submitDetails()"
				novalidate name="addBigDataAppForm" autocomplete="off">
				<!--Setup app selection--Start-->
				<div class="panel panel-default">
					<div class="panel-body">
						<div class="form-group margin-left-20 margin-right-20">
							<label class="col-xs-12 col-md-4" for="bigDataAppType"><cv:msg
									key="label.applicationType" bundle="bigData" /></label>
							<div class="col-xs-12 col-md-8">
								<isteven-multi-select id="createBigDataApp_isteven-multi-select_#4008"
									class="half-width"
									input-model="addBigDataApp.bigDataAppList"
									output-model="addBigDataApp.selectedBigDataAppFromList"
									button-label="appType"
									item-label="appType"
									selection-mode="single"
									helper-elements="filter"
									max-labels="1"
									tick-property="selected"
									on-item-click="addBigDataApp.processBigDataAppSelection()"
									translation="addBigDataApp.localLang">
								</isteven-multi-select>
							</div>
						</div>
					</div>
				</div>

				<!--Setup app selection--END-->

				<!--Hadoop Setup--START-->
				<div data-ng-if= "addBigDataApp.selectedBigDataAppFromList[0].value == 'Hadoop'" class="panel panel-default">
					<div class="panel-body">
						<div data-ng-controller='hadoopSetup as hadoopSetupCtrl' class="padding-bottom-0">
							<ng-include src="addBigDataApp.getModalUrl('hadoopSetup.jsp')"></ng-include>
						</div>
					</div>
				</div>
				<!--Hadoop Setup--END-->

				<!--Cassandra Setup--START-->
				<div data-ng-if= "addBigDataApp.selectedBigDataAppFromList[0].value == 'Cassandra'" class="panel panel-default">
					<div class="panel-body">
						<div data-ng-controller='cassandraSetup as cassandraSetupCtrl' class="padding-bottom-0">
							<ng-include src="addBigDataApp.getModalUrl('cassandraSetup.jsp')"></ng-include>
						</div>
					</div>
				</div>
				<!--Cassandra Setup--END-->

				<!--Splunk Setup--START-->
				<div data-ng-if= "addBigDataApp.selectedBigDataAppFromList[0].value == 'Splunk'" class="panel panel-default">
					<div class="panel-body">
						<div data-ng-controller='splunkSetup as splunkSetupCtrl' class="padding-bottom-0">
							<ng-include src="addBigDataApp.getModalUrl('createSplunkModal.jsp')"></ng-include>
						</div>
					</div>
				</div>
				<!--Splunk Setup--END-->

				<!--MongoDB Setup--START-->
				<div data-ng-if= "addBigDataApp.selectedBigDataAppFromList[0].value == 'MongoDB'" class="panel panel-default">
					<div class="panel-body">
						<div data-ng-controller='mongoDBSetup as mongoDBSetupCtrl'>
							<ng-include src="addBigDataApp.getModalUrl('mongoDBSetup.jsp')" ></ng-include>
						</div>
					</div>
				</div>
				<!--MongoDB Setup--END-->
			</form>
		</div>
	</div>
</div>