<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settings"></cv:cvMessages>
	<cv:cvMessages bundle="localization.browse"></cv:cvMessages>
	<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.search"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-md-12">
		<cv-changename obj="ctrl.changeNameObj" data-service-method="renameSubclient.do" class="float-left"></cv-changename>
		<span class="server-message {{ctrl.serverMessage.type}}" data-ng-bind="ctrl.serverMessage.message" ></span>
		<div id="bigdataSubclientSearch" class="flex-page-actions" data-ng-if="ctrl.clusterType === 'HADOOP'">
			<cv-search-box ng-if="searchModel" query="searchModel.query" on-search="onSubclientSearch(query, fields)" custom-class="searchModel.customClass" field-defs="searchModel.fieldDefs" data-show-in-url="false"></cv-search-box>
		</div>
	</div>
</div>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="bigDataSubclientDetails" data-title='<cv:msg key="heading.clientGeneral" bundle="clients" />'  data-loader="ctrl.subclientDetails">
			<ul data-ng-if="ctrl.subclientDetails" class="group list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.instanceName" bundle="clients" /></span>
					<span class="pageDetailColumn" data-ng-bind="ctrl.subclientDetails.subClientEntity.instanceName"></span>
				</li>
				<cv-activity-control label='<cv:msg key="label.backupEnabled" bundle="clients" />' help-text='<cv:msg key="info.help.dataBackup" bundle="clients"/>' ac-params="ctrl.subclientDetails.subClientEntity" enable-backup="ctrl.subclientDetails.commonProperties.enableBackup" enable-delay="ctrl.subclientDetails.commonProperties.enableBackupAfterDelay" delay-time="ctrl.subclientDetails.commonProperties.enableBackupAtDateTime"> </cv-activity-control>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.lastBackupTime" bundle="storage" /></span>
					<span class="pageDetailColumn" data-ng-bind="ctrl.subclientDetails.commonProperties.lastBackupTime | customDateTime"></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.firstBackupTime" bundle="clients" /></span>
					<span class="pageDetailColumn" data-ng-bind="ctrl.subclientDetails.commonProperties.firstBackupTime | customDateTime"></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.applicationSize" bundle="storage" /></span>
					<span class="pageDetailColumn" data-ng-bind="ctrl.subclientDetails.commonProperties.sizeOnMedia | capacity"></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.totalbackup.size" bundle="clients" /></span>
					<span class="pageDetailColumn" data-ng-bind="ctrl.subclientDetails.commonProperties.totalBackupSize | capacity"></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="header.lastBackupSize" bundle="devicesJs" /></span>
					<span class="pageDetailColumn" data-ng-bind="ctrl.subclientDetails.commonProperties.lastBackupSize | capacity"></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.savingsPercentage" bundle="job" /></span>
					<span class="pageDetailColumn"></span>
						<span data-ng-bind="ctrl.subclientDetails.commonProperties.dedupeRatio"></span>
						<cv-call-out html-template="ctrl.savingsPercentageCallOutTemplate"></cv-call-out>
					</span>
				</li>
			</ul>
		</cv-tile-component>
		<cv-tile-component data-ac-id="bigDataSubclientBackuptile" data-ng-show="ctrl.subclientDetails" data-title='<cv:msg key="label.backup" bundle="collections" />'>
			<ul class="serverBackupTile">
				<li><span class="page-details-box-links multiLinks">
					<ul>
						<li data-ng-if="ctrl.showBackup['backup'] && ctrl.backupEnabledStatusInfo!= 'disabled-activity'" class="restoreli"  data-ng-click="ctrl.showBackupOptions()"><a href=""><cv:msg key="action.backupNow" bundle="collections" /></a></li>
						<li><a data-ng-href="#jobs?collectionId={{ctrl.subclientDetails.subClientEntity.subclientId}}&collectionName={{ctrl.changeNameObj.name}}&jobType=Backup"><cv:msg key="action.jobs" bundle="servers" /></a></li>
					</ul>
				</span></li>
				<li data-ng-if="ctrl.showBackup['backup']">
					<p class="info-place-holder">	<cv:msg key="info.nobackupRunning" bundle="collections" /></p>
				</li>
				<li data-ng-if="ctrl.showBackup['submittingJob']">
					<p class="info-place-holder"><cv:msg key="info.submittingJob" bundle="collections" /></p>
				</li>
				<li data-ng-if="ctrl.backupJobs.length>0"><data-cv-job jobs='ctrl.backupJobs' show-backup='ctrl.showBackup'></data-cv-job></li>
			</ul>
		</cv-tile-component>
	</div>
    <div class="col-sm-6" data-ng-if="ctrl.subclientDetails">
        <cv-backup-history entity="ctrl.backupEntity" params="ctrl.historyParams"
            on-restore="ctrl.performAgentRestore(job, toTimeStr, restoreLevel)" show-no-data-message="true"
        ></cv-backup-history>
    </div>
</div>
