<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.settingsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-md-12">
		<cv-changename obj="ctrl.changeNameObj" data-service-method="renameSubclient.do" class="float-left"></cv-changename>
		<span class="server-message {{ctrl.serverMessage.type}}" data-ng-bind="ctrl.serverMessage.message" ></span>
	</div>
</div>
<div class="row">
	<div class="col-md-6">
		<cv-security-component entity-type='ctrl.entityType' generic-entity = 'ctrl.genericEntity' associations='ctrl.formattedSecurityAssociations' associations-loaded='ctrl.associationsLoaded'>
		</cv-security-component>
		<cv-tile-component ng-if="ctrl.clusterType === 'CASSANDRA'" data-ac-id="bigDataSubclientContent" data-ng-show="ctrl.subclientDetails" data-title='<cv:msg key="header.content" bundle="collections"/>' data-min-height="true">
			<span data-ng-if="!(ctrl.cassandraContent && ctrl.cassandraContent.length>0)"><p class="info-place-holder"><cv:msg key="label.noContent" bundle="clients" /></p></span>
			<ul data-ng-if="ctrl.cassandraContent && ctrl.cassandraContent.length>0" class="list-style__row group">
				<li data-ng-repeat="content in ctrl.cassandraContent"><span data-ng-bind="content | cassandraContent"></span></li>
			</ul>
			<div class="page-details-box-links"><a data-ng-click="ctrl.editContent()"><cv:msg key="action.edit" bundle="settingsJs"/></a></div>
		</cv-tile-component>
		<cv-tile-component ng-if="ctrl.clusterType === 'HADOOP' && !ctrl.hbaseContent" data-ac-id="bigDataSubclientContent" data-ng-show="ctrl.subclientDetails" data-title='<cv:msg key="header.content" bundle="collections"/>' data-min-height="true">
			<span data-ng-if="!ctrl.hdfsContent"><p class="info-place-holder"><cv:msg key="label.noContent" bundle="clients" /></p></span>
			<ul data-ng-if="ctrl.hdfsContent && ctrl.hdfsContent.length>0" class="list-style__row group">
				<li data-ng-repeat="content in ctrl.hdfsContent"><span data-ng-bind="content.path || content.subclientPolicyPath"></span></li>
			</ul>
			<div class="page-details-box-links"><a data-ng-click="ctrl.editHdfsContent()"><cv:msg key="action.edit" bundle="settingsJs"/></a></div>
		</cv-tile-component>
	</div>
	<div class="col-md-6">
		<span data-ng-if="ctrl.subclientDetails">
        	<cv-plan-component app-id="ctrl.applicationId" subclient-id="ctrl.subclientId" client-id="ctrl.clientId" data-dont-show-edit="false" plan-entity="ctrl.planEntity"></cv-plan-component>
		</span>
		<cv-tile-component data-ac-id="bigDataSubclientDataAccessNode" data-ng-show="ctrl.subclientDetails.dfsSubclientProp.distributedDataAccessNodes.dataAccessNodes" data-title='<cv:msg key="label.dataAccessNodes" bundle="bigData"/>' data-min-height="true">
			<span data-ng-if="!(ctrl.subclientDetails.dfsSubclientProp.distributedDataAccessNodes.dataAccessNodes && ctrl.subclientDetails.dfsSubclientProp.distributedDataAccessNodes.dataAccessNodes.length>0)"><p class="info-place-holder"><cv:msg key="label.noDataAccessNodes" bundle="bigData" /></p></span>
			<ul data-ng-if="ctrl.subclientDetails.dfsSubclientProp.distributedDataAccessNodes.dataAccessNodes && ctrl.subclientDetails.dfsSubclientProp.distributedDataAccessNodes.dataAccessNodes.length>0" class="list-style__row group">
				<li data-ng-repeat="client in ctrl.subclientDetails.dfsSubclientProp.distributedDataAccessNodes.dataAccessNodes">{{client.clientName}}</li>
			</ul>
			<div class="page-details-box-links"><a data-ng-click="ctrl.openEditNodesModal()"><cv:msg key="action.edit" bundle="settingsJs"/></a></div>
		</cv-tile-component>
	</div>
</div>
