<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
    <cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.restore"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="header.restore" bundle="serversJs"/></h1>
</div>
<div class="backup-options" ng-init="ctrl.init()">
    <div class="serverMessage" ng-class="ctrl.serverMessage.type" ng-bind="ctrl.serverMessage.message"></div>
    <div class="modal-list bootstrap-wrapper">
        <form id="restoreBigDataForm" name="restoreBigDataForm" cv-submit="ctrl.restore()" novalidate autocomplete="off">
            <cv-tabset-component control='ctrl.tabControls' ng-init="ctrl.initInstances()" default-tab="ctrl.tabControls.defaultTab">
                <cv-tab tabname='<cv:msg key="label.restoreInPlace" bundle="restore" />' data-ng-selected="ctrl.onTabChanged()">
                    <!-- <div class="form-group row">
                        <label class="col-xs-12 col-sm-4" for="destinationInstance"><cv:msg key="label.destinationInstance" bundle="bigData" /></label>
                        <div class="col-xs-12 col-sm-8">
                            <label class="col-xs-12 col-sm-4" name="destinationInstance" >{{ctrl.destination.destinationInstance.clientName}}/{{ctrl.destination.destinationInstance.instanceName}}</label>
                        </div>
                    </div> -->
                    <div class="form-group row">
                        <label class="col-xs-12 col-sm-4" for="stagingLocation"><cv:msg key="label.stagingLocation" bundle="bigData" /></label>
                        <div class="col-xs-12 col-sm-8">
                            <input type="text" id="stagingLocation" name="stagingLocation" ng-model="ctrl.restoreOptions.stagingLocation" ng-change="ctrl.inputAlertFlags.stagingLocation = false;"/>
                            <span class="help-block" ng-show="ctrl.inputAlertFlags.stagingLocation"><cv:msg key="error.stagingLocation" bundle="bigData" /></span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-xs-12 col-sm-4" for="noOfStreams"><cv:msg key="label.noOfStreams" bundle="bigData" /></label>
                        <div class="col-xs-12 col-sm-8">
                            <input type="number" id="noOfStreams" name="noOfStreams" ng-model="ctrl.restoreOptions.noOfStreams" />
                        </div>
                    </div>
                    <div class="form-group row" data-ng-disabled="ctrl.disableSSTableLoader">
                        <toggle-control class="col-xs-1" disabled="ctrl.restoreOptions.outOfPlaceRestore" id="useSSTableLoader" name="useSSTableLoader" data-ng-click="ctrl.restoreOptions.useSSTableLoader=!ctrl.restoreOptions.useSSTableLoader" status="ctrl.restoreOptions.useSSTableLoader?'enabled-activity':'disabled-activity'" title='<cv:msg key="label.enableDisable" bundle="messages"/> <cv:msg key="label.useSSTableLoader" bundle="bigData" />'></toggle-control>
                        <label for="useSSTableLoader" class="col-xs-11 no-margin checkbox-label padding-top-5"><cv:msg key="label.useSSTableLoader" bundle="bigData" /></label>
                    </div>
                    <div class="form-group row" data-ng-disabled="ctrl.disableRunStageFreeRestore">
                        <toggle-control class="col-xs-1" id="runStageFreeRestore" name="runStageFreeRestore" data-ng-click="ctrl.restoreOptions.runStageFreeRestore=!ctrl.restoreOptions.runStageFreeRestore; ctrl.disableRecoverOption=ctrl.restoreOptions.runStageFreeRestore?true:false; ctrl.inputAlertFlags.stagingLocation = false;" status="ctrl.restoreOptions.runStageFreeRestore?'enabled-activity':'disabled-activity'" title='<cv:msg key="label.enableDisable" bundle="messages"/> <cv:msg key="label.runStageFreeRestore" bundle="bigData" />'></toggle-control>
                        <label for="runStageFreeRestore" class="col-xs-11 no-margin checkbox-label padding-top-5"><cv:msg key="label.runStageFreeRestore" bundle="bigData" /></label>
                    </div>
                    <div class="form-group row">
                        <toggle-control class="col-xs-1" true-property="recover" false-property="doNotRecover" data-ng-disabled="ctrl.disableRecoverOption" disabled="ctrl.disableRecoverOption || ctrl.restoreOptions.recoverOption" id="recoverOption" name="recoverOption" data-ng-click="ctrl.restoreOptions.recoverOption=(ctrl.restoreOptions.recoverOption=='recover' && !ctrl.restoreOptions.runStageFreeRestore)?'doNotRecover':'recover'; ctrl.setSSTableLoader()" status="ctrl.restoreOptions.recoverOption" title='<cv:msg key="label.enableDisable" bundle="messages"/> <cv:msg key="label.recover" bundle="bigData" />'></toggle-control>
                        <label for="recoverOption" class="col-xs-11 no-margin checkbox-label padding-top-5"><cv:msg key="label.recover" bundle="bigData" /></label>
                    </div>            
                    <div class="form-group row" data-ng-if="ctrl.enableCommitLog">
                        <toggle-control class="col-xs-1" id="runLogRestore" name="runLogRestore" data-ng-click="ctrl.restoreOptions.runLogRestore=!ctrl.restoreOptions.runLogRestore" status="ctrl.restoreOptions.runLogRestore?'enabled-activity':'disabled-activity'" title='<cv:msg key="label.enableDisable" bundle="messages"/> <cv:msg key="label.runLogRestore" bundle="bigData" />'></toggle-control>
                        <label for="runLogRestore" class="col-xs-11 no-margin checkbox-label padding-top-5"><cv:msg key="label.runLogRestore" bundle="bigData" /></label>
                    </div>
                    </cv-tab>
                <cv-tab tabname='<cv:msg key="label.OOPRestore" bundle="restore" />' data-ng-selected="ctrl.onTabChanged()">
                    <div class="out-of-place-restore" ng-if="ctrl.restoreOptions.outOfPlaceRestore">
                        <div class="form-group row">
                            <label class="col-xs-12 col-sm-4" for="destinationInstance"><cv:msg key="label.destinationInstance" bundle="bigData" /></label>
                            <div class="col-xs-12 col-sm-8" ng-if="ctrl.instanceList" >
                                <isteven-multi-select id="bigDataRestoreOptionsModal_isteven-multi-select_#6203"    
                                    directive-id="destinationInstance"
                                    input-model="ctrl.instanceList"
                                    output-model="ctrl.restoreOptions.selectedInstance"
                                    button-label="instanceLabel"
                                    item-label="instanceLabel"
                                    search-property = "instanceLabel"
                                    selection-mode="single"
                                    on-item-click="ctrl.clickDestination(data)"
                                    tick-property="selected"
                                >
                                </isteven-multi-select>
                            </div>
                        </div>
                    </div>
                    <div data-ng-if="ctrl.clusterView" class="cv-modal-wrapper">
                        <cv-grid class="remove-grid-padding" cv-grid-options="ctrl.cvGridOptions" ng-if="ctrl.sources"></cv-grid>
                        <span class="help-block margin-left-5 padding-top-5" ng-show="ctrl.inputAlertFlags.source"><cv:msg key="error.source" bundle="bigData" /></span>
                    </div>    
                    <div class="form-group row">
                        <label class="col-xs-12 col-sm-4" for="stagingLocation2"><cv:msg key="label.stagingLocation" bundle="bigData" /></label>
                        <div class="col-xs-12 col-sm-8">
                            <input type="text" id="stagingLocation2" name="stagingLocation2" ng-model="ctrl.restoreOptions.stagingLocation" ng-change="ctrl.inputAlertFlags.stagingLocation = false;"/>
                            <span class="help-block" ng-show="ctrl.inputAlertFlags.stagingLocation"><cv:msg key="error.stagingLocation" bundle="bigData" /></span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-xs-12 col-sm-4" for="noOfStreams2"><cv:msg key="label.noOfStreams" bundle="bigData" /></label>
                        <div class="col-xs-12 col-sm-8">
                            <input type="number" id="noOfStreams2" name="noOfStreams2" ng-model="ctrl.restoreOptions.noOfStreams" />
                        </div>
                    </div>
                    <div class="form-group row" data-ng-disabled="ctrl.disableSSTableLoader">
                        <toggle-control class="col-xs-1" id="useSSTableLoader2" name="useSSTableLoader2" data-ng-click="ctrl.restoreOptions.useSSTableLoader=!ctrl.restoreOptions.useSSTableLoader" status="ctrl.restoreOptions.useSSTableLoader?'enabled-activity':'disabled-activity'" title='<cv:msg key="label.enableDisable" bundle="messages"/> <cv:msg key="label.useSSTableLoader" bundle="bigData" />'></toggle-control>
                        <label for="useSSTableLoader2" class="col-xs-11 no-margin checkbox-label padding-top-5"><cv:msg key="label.useSSTableLoader" bundle="bigData" /></label>
                    </div>
                    <div class="form-group row" data-ng-disabled="ctrl.disableRunStageFreeRestore">
                        <toggle-control class="col-xs-1" id="runStageFreeRestore2" name="runStageFreeRestore2" data-ng-click="ctrl.restoreOptions.runStageFreeRestore=!ctrl.restoreOptions.runStageFreeRestore; ctrl.disableRecoverOption=ctrl.restoreOptions.runStageFreeRestore?true:false; ctrl.inputAlertFlags.stagingLocation = false;" status="ctrl.restoreOptions.runStageFreeRestore?'enabled-activity':'disabled-activity'" title='<cv:msg key="label.enableDisable" bundle="messages"/> <cv:msg key="label.runStageFreeRestore" bundle="bigData" />'></toggle-control>
                        <label for="runStageFreeRestore2" class="col-xs-11 no-margin checkbox-label padding-top-5"><cv:msg key="label.runStageFreeRestore" bundle="bigData" /></label>
                    </div>    
                    <div class="form-group row">
                        <toggle-control class="col-xs-1" true-property="recover" false-property="doNotRecover" data-ng-disabled="ctrl.disableRecoverOption" disabled="ctrl.disableRecoverOption || ctrl.restoreOptions.recoverOption" id="recoverOption2" name="recoverOption2" data-ng-click="ctrl.restoreOptions.recoverOption=(ctrl.restoreOptions.recoverOption=='recover' && !ctrl.restoreOptions.runStageFreeRestore)?'doNotRecover':'recover'; ctrl.setSSTableLoader()" status="ctrl.restoreOptions.recoverOption" title='<cv:msg key="label.enableDisable" bundle="messages"/> <cv:msg key="label.recover" bundle="bigData" />'></toggle-control>
                        <label for="recoverOption2" class="col-xs-11 no-margin checkbox-label padding-top-5"><cv:msg key="label.recover" bundle="bigData" /></label>
                    </div>
                    <div class="form-group row" data-ng-if="ctrl.enableCommitLog">
                        <toggle-control class="col-xs-1" id="runLogRestore2" name="runLogRestore2" data-ng-click="ctrl.restoreOptions.runLogRestore=!ctrl.restoreOptions.runLogRestore" status="ctrl.restoreOptions.runLogRestore?'enabled-activity':'disabled-activity'" title='<cv:msg key="label.enableDisable" bundle="messages"/> <cv:msg key="label.runLogRestore" bundle="bigData" />'></toggle-control>
                        <label for="runLogRestore2" class="col-xs-11 no-margin checkbox-label padding-top-5"><cv:msg key="label.runLogRestore" bundle="bigData" /></label>
                    </div>
                    <div data-ng-if="ctrl.clusterView" ng-disabled="ctrl.disableReplaceDeadNode" class="form-group row">
                        <!-- CV TOGGLE DOES NOT UPDATE UI WHEN MODEL IS UPDATED -->
                        <toggle-control class="col-xs-1" disabled="ctrl.disableReplaceDeadNode" id="replaceDeadNode" name="replaceDeadNode" data-ng-click="ctrl.toggleDeadNode()" status="ctrl.restoreOptions.replaceDeadNode?'enabled-activity':'disabled-activity'" title='<cv:msg key="label.enableDisable" bundle="messages"/> <cv:msg key="label.replaceDeadNode" bundle="bigData" />'></toggle-control>
                        <label for="replaceDeadNode" class="col-xs-11 no-margin checkbox-label padding-top-5"><cv:msg key="label.replaceDeadNode" bundle="bigData" /></label>
                    </div>        
                </cv-tab>
            </cv-tabset-component>
            <div class="button-container">
                <button id="bigDataRestoreOptionsModal_button_#7606" type="button" class="btn btn-default cvBusyOnAjax" ng-click="ctrl.dismiss()"><cv:msg key="Cancel" bundle="messages"/></button> 
                <button id="bigDataRestoreOptionsModal_button_#8654" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="OK" bundle="messages"/></button> 
            </div>
        </form>
    </div>
</div>