<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.clients"></cv:cvMessages>
    <cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.servers"></cv:cvMessages>
    <cv:cvMessages bundle="localization.usersJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
    <cv:cvMessages bundle="localization.navJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.settings"></cv:cvMessages>
    <cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
    <cv:cvMessages bundle="localization.sharepoint"></cv:cvMessages>
    <cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.dr"></cv:cvMessages>
    <cv:cvMessages bundle="localization.storage"></cv:cvMessages>
    <cv:cvMessages bundle="localization.job"></cv:cvMessages>
    <cv:cvMessages bundle="localization.browse"></cv:cvMessages>
    <cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
    <cv:cvMessages bundle="localization.fs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.search"></cv:cvMessages>
</script>


<div class="row">
   <div class="col-xs-12">
       <cv-changename obj='ctrl.changeNameObj' service-method='changeServerName.do' class="float-left" callback="ctrl.changeNameSuccess"></cv-changename>
    		<div id="bigdataInstanceSearch" class="flex-page-actions" data-ng-if="ctrl.clusterType === 'HADOOP'">
			    <cv-search-box ng-if="searchModel" query="searchModel.query" on-search="onBackupsetSearch(query, fields)" custom-class="searchModel.customClass" field-defs="searchModel.fieldDefs" data-show-in-url="false"></cv-search-box>
		    </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <span class="server-message {{ctrl.serverMessage.type}}" data-ng-bind="ctrl.serverMessage.message"></span>
    </div>
</div>

<!--  Overview Tab -->

<div class="row" data-ng-if="ctrl.isOverviewTabSelected">
     <div class="col-sm-6">
        <cv-tile-component ng-show="ctrl.clusterType === 'MONGODB' || ctrl.clusterType === 'HADOOP' || ctrl.clusterType === 'CASSANDRA' || ctrl.clusterType === 'SPLUNK' "
        	data-loader = "ctrl.agentDetails"
            data-ac-id="agentDetails-heading_clientGeneral-clients"
            data-title='<cv:msg key="heading.clientGeneral" bundle="clients"/>'>
        <ul class="list-style-secondary">
            <li data-ng-if="ctrl.clientDetails.client.displayName"
                class="group"><span class="pageDetailColumn"><cv:msg
                        key="label.clusterName" bundle="bigData" /></span> <span
                class="pageDetailColumn"
                data-ng-bind="ctrl.clientDetails.client.displayName"></span>
            </li>

            <li data-ng-if="ctrl.agentDetails.AgentProperties.installDate" class="group"><span class="pageDetailColumn"><cv:msg
                        key="header.installDate" bundle="clients" /></span> <span
                class="pageDetailColumn"
                data-ng-bind="ctrl.agentDetails.AgentProperties.installDate | customDateTime"></span>
            </li>

            <li data-ng-if="ctrl.clientDetails.clientProps" class="group"><span class="pageDetailColumn">
                    <cv:msg key="label.column.status" bundle="job" /></span> <span
                    ng-class="{'green-font': ctrl.clientDetails.clientProps.slaStatus === 'MET_SLA', 'red-font': ctrl.clientDetails.clientProps.slaStatus !== 'MISSED_SLA'}"
                    ng-bind="ctrl.clientDetails.status"></span></li>

            <li class="group" data-ng-if="ctrl.agentDetails.idaEntity">
                <cv-plan-select show-edit="ctrl.clusterType==='MONGODB' || ctrl.clusterType==='HADOOP'" plan-entity="ctrl.planEntity" entity="ctrl.agentDetails.idaEntity"></cv-plan-select>
            </li>

            <cv-client-readiness-status client-id="{{ctrl.clientId}}" client-readiness="ctrl.clientDetails.clientReadiness" />

            <li data-ng-if="ctrl.agentDetails" class="group"><span
                class="pageDetailColumn"><cv:msg key="label.lastBackupTime"
                        bundle="storage" /></span> <span
                data-ng-if="ctrl.agentDetails.AgentProperties.commonProperties.lastBackupTime"
                data-ng-bind="ctrl.agentDetails.AgentProperties.commonProperties.lastBackupTime | customDateTime"
                class="pageDetailColumn"></span> <span
                data-ng-if="!ctrl.agentDetails.AgentProperties.commonProperties.lastBackupTime"
                class="pageDetailColumn"><cv:msg key="label.neverBackedUp"
                        bundle="serversJs" /></span></li>

            <li data-ng-if="ctrl.agentDetails" class="group"><span
                class="pageDetailColumn"><cv:msg key="label.firstBackupTime"
                        bundle="clients" /></span> <span
                data-ng-if="ctrl.agentDetails.AgentProperties.commonProperties.firstBackupTime"
                data-ng-bind="ctrl.agentDetails.AgentProperties.commonProperties.firstBackupTime | customDateTime"
                class="pageDetailColumn"></span> <span
                data-ng-if="!ctrl.agentDetails.AgentProperties.commonProperties.firstBackupTime"
                class="pageDetailColumn"><cv:msg key="label.neverBackedUp"
                        bundle="serversJs" /></span></li>

            <li data-ng-if="ctrl.agentDetails" class="group"><span
                class="pageDetailColumn">
                        <cv:msg key="label.applicationSize"
                        bundle="storage" />

                        </span> <span
                data-ng-if="ctrl.agentDetails.AgentProperties.commonProperties.applicationSize!==undefined"
                class="pageDetailColumn"
                data-ng-bind="ctrl.agentDetails.AgentProperties.commonProperties.applicationSize | capacity"></span>
                <span
                data-ng-if="ctrl.agentDetails.AgentProperties.commonProperties.applicationSize===undefined "
                class="pageDetailColumn"><cv:msg key="label.notAvailable"
                        bundle="servers" /></span></li>

            <li class="group" data-ng-if="ctrl.agentDetails"><span
                class="pageDetailColumn">
                <cv:msg key="label.totalbackup.size"
                        bundle="clients" />
                </span> <span
                data-ng-if="ctrl.agentDetails.AgentProperties.commonProperties.totalBackupSize!==undefined"
                class="pageDetailColumn"
                data-ng-bind="ctrl.agentDetails.AgentProperties.commonProperties.totalBackupSize | capacity"></span>
                <span
                data-ng-if="ctrl.agentDetails.AgentProperties.commonProperties.totalBackupSize===undefined "
                class="pageDetailColumn"><cv:msg key="label.notAvailable"
                        bundle="servers" /></span></li>

             <li data-ng-if="ctrl.agentDetails" class="group">
                <span class="pageDetailColumn">
                    <cv:msg key="label.savingsPercentage" bundle="job" />
                </span>
                <span class="pageDetailColumn">
                    <span data-ng-bind="ctrl.agentDetails.AgentProperties.commonProperties.dedupeRatio"> </span>
                    <cv-call-out html-template="ctrl.savingsPercentageCallOutTemplate"></cv-call-out>
                </span>
            </li>
        </ul>
        </cv-tile-component>
    </div>

    <div class="col-sm-6">
        <cv-backup-history entity="backupEntity" params="historyParams"
            on-restore="performAgentRestore(job, toTimeStr, restoreLevel)" show-no-data-message="true"
            ng-show="ctrl.clusterType === 'MONGODB' || ctrl.clusterType === 'HADOOP' || ctrl.clusterType === 'CASSANDRA' || ctrl.clusterType === 'SPLUNK'  "></cv-backup-history>
    </div>
 	<div id="hadoopApps" data-ng-show="ctrl.backupSetLoaded" class="col-sm-12">
 		<div id="fs-content-group-dropdown"></div>
		<cv-server-filter id="backup-set-filter"  ng-if= "ctrl.instanceFilters" filter-label="{{ctrl.backupsetFilterLabel}}" append-to-element-id="fs-content-group-dropdown" filter-list="ctrl.instanceFilters"
			filter-current="ctrl.currentInstanceIndex">
		</cv-server-filter>
		<cv-kendo-grid ng-if="ctrl.clusterType === 'HADOOP'" class="case-inline-grid" cv-grid-options="ctrl.HadoopGridOptions" >
		</cv-kendo-grid>
	</div>
</div>

<!-- --Configuration -->

<div class="row" data-ng-if="!ctrl.isOverviewTabSelected">
       <div class="col-xs-12 col-sm-6">

       <cv-tile-component ng-show="ctrl.clusterType === 'CASSANDRA' || ctrl.clusterType === 'SPLUNK' "  ac-id="bigDataClusterDetails"
            loader="ctrl.generalInfoLoaded" data-title='<cv:msg key="heading.clientGeneral" bundle="clients" />'>
            <div ng-if="ctrl.clusterConfig">
                <ul class="list-style-secondary">
                    <div ng-controller="bigDataGeneralInfoController as gInfoCtrl">
                        <cv-tile-label-value ng-repeat="info in gInfoCtrl.generalInfoList" label="{{info.label}}" value="{{info.value}}" data-ng-if="info.value && info.value!=''"></cv-tile-label-value>
                    </div>
                    <div ng-if="::ctrl.showCommitLog()">
                        <li>
                            <span class="pageDetailColumn"><cv:msg key="label.commitLog" bundle="bigData"/></span>
                            <span class="pageDetailColumn">
                                <toggle-control status="ctrl.clusterConfig.enableCommitLog?'enabled-activity':'disabled-activity'" ng-click="ctrl.toggleCommitLog()" title='<cv:msg key="label.enableDisable" bundle="messages"/> <cv:msg key="label.commitLog" bundle="bigData"/>'></toggle-control>
                                <span class="edit-link-float-right" ng-show="ctrl.clusterConfig.enableCommitLog" ng-click="ctrl.openCommitLogDialog()"><a href="javascript:void(0);"><cv:msg key="label.edit" bundle="bigData"/></a></span>
                            </span>
                        </li>
                    </div>
                </ul>
            </div>
            <div class="page-details-box-links">
                <a href="javascript:void(0);" ng-click="ctrl.authentication=false;ctrl.openEditGeneralInfoModal();"><cv:msg key="label.edit" bundle="clients"/></a>
            </div>
        </cv-tile-component>

        <cv-tile-component ng-show="ctrl.clusterType === 'CASSANDRA' " ac-id="bigDataClusterAuthentication" data-title='<cv:msg key="label.authentication" bundle="settings" />' data-loader="ctrl.clusterConfig">
			<ul class="list-style-secondary">
                <cv-tile-label-value label='<cv:msg key="label.gatewayCQLPort" bundle="bigData"/>' value="{{ctrl.clusterConfig.gateway.gatewayCQLPort}}"></cv-tile-label-value>
                <cv-tile-label-value label='<cv:msg key="label.port" bundle="bigData"/>' value="{{ctrl.clusterConfig.gateway.node.jmxConnection.port}}"></cv-tile-label-value>
				<li class="group">
                    <span class="pageDetailColumn" ng-bind-html="'<cv:msg key="label.CQLAuthentication" bundle="bigData"/>'"></span>
                    <span class="pageDetailColumn">
                        <toggle-control status="ctrl.authParams.CQLAuthentication.status" ng-click="ctrl.toggleAuthentication('CQL')" title='<cv:msg key="label.enableDisable" bundle="messages"/> <cv:msg key="label.CQLAuthentication" bundle="bigData"/>'></toggle-control>
                        <span class="margin-left-10" ng-show="ctrl.authParams.CQLAuthentication.status === 'enabled-activity'" ng-click="ctrl.openAuthDialog('CQL', true)"><a href="javascript:void(0);"><cv:msg key="label.edit" bundle="clients"/></a></span>
                    </span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn" ng-bind-html="'<cv:msg key="label.JMXAuthentication" bundle="bigData"/>'"></span>
                    <span class="pageDetailColumn">
                        <toggle-control status="ctrl.authParams.JMXAuthentication.status" ng-click="ctrl.toggleAuthentication('JMX')" title='<cv:msg key="label.enableDisable" bundle="messages"/> <cv:msg key="label.JMXAuthentication" bundle="bigData"/>'></toggle-control>
                        <span class="margin-left-10" ng-show="ctrl.authParams.JMXAuthentication.status === 'enabled-activity'" ng-click="ctrl.openAuthDialog('JMX', true)"><a href="javascript:void(0);"><cv:msg key="label.edit" bundle="clients"/></a></span>
                    </span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn" ng-bind-html="'<cv:msg key="label.SSLAuthentication" bundle="bigData"/>'"></span>
                    <span class="pageDetailColumn">
                        <toggle-control status="ctrl.authParams.SSLAuthentication.status" ng-click="ctrl.toggleAuthentication('SSL')" title='<cv:msg key="label.enableDisable" bundle="messages"/> <cv:msg key="label.SSLAuthentication" bundle="bigData"/>'></toggle-control>
                        <span class="margin-left-10" ng-show="ctrl.authParams.SSLAuthentication.status === 'enabled-activity'" ng-click="ctrl.openAuthDialog('SSL', true)"><a href="javascript:void(0);"><cv:msg key="label.edit" bundle="clients"/></a></span>
                    </span>
                </li>
            </ul>
            <div class="page-details-box-links">
                <a href="javascript:void(0);" ng-click="ctrl.authentication=true;ctrl.openEditGeneralInfoModal();"><cv:msg key="label.edit" bundle="clients"/></a>
            </div>
		</cv-tile-component>
		 <cv-tile-component ng-show="ctrl.clusterType === 'SPLUNK'" ac-id="bigDataClusterNodes" data-title='<cv:msg key="label.nodes" bundle="bigData" />' data-loader="ctrl.clusterConfig">
			<ul class="list-style-secondary">
					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.nodes" bundle="bigData"/></span>
						<span data-ng-if="ctrl.clusterConfig.nodes.length > 0" class="pageDetailColumn">
							<span class="reduced-size" ng-bind="ctrl.secMemberServerString"></span>
							<span data-ng-if="ctrl.clusterConfig.nodes.length>=3">({{ctrl.clusterConfig.nodes.length}})</span>
						</span>
					</li>
				</ul>



            <div class="page-details-box-links" ng-if="ctrl.clusterConfig"><a href="javascript:void(0);" ng-click="ctrl.openEditNodesModal();" ><cv:msg key="label.edit" bundle="clients"/></a></div>
        </cv-tile-component>

        <!-- Cluster Info for MongoDB -->
        <cv-tile-component ng-show="ctrl.clusterType === 'MONGODB' " ac-id="bigDataClusterDetails"
            loader="ctrl.generalInfoLoaded" data-title='<cv:msg key="heading.clusterdetails" bundle="bigData" />'>
            <div ng-if="ctrl.clusterConfig">
                <ul class="list-style-secondary">
                    <div ng-controller="bigDataGeneralInfoController as gInfoCtrl">
                        <cv-tile-label-value ng-repeat="info in gInfoCtrl.generalInfoList" label="{{info.label}}"
                            value="{{info.value}}" data-ng-if="info.value && info.value!=''"></cv-tile-label-value>
                    </div>
                </ul>
            </div>
            <div class="page-details-box-links">
                <a href="javascript:void(0);" ng-click="ctrl.authentication=false;ctrl.openEditGeneralInfoModal();">
                    <cv:msg key="label.edit" bundle="clients" /></a>
            </div>
        </cv-tile-component>

        <!--  MongoDB Authentication -->
        <cv-tile-component ng-show="ctrl.clusterType === 'MONGODB' " ac-id="bigDataClusterAuthentication"
            data-title='<cv:msg key="heading.dbAuthentication" bundle="bigData" />' data-loader="ctrl.clusterConfig">
            <ul class="list-style-secondary">
                <cv-tile-label-value label='<cv:msg key="label.DBUsername" bundle="bigData"/>'
                    value="{{ctrl.clusterConfig.adminUser.userName}}"></cv-tile-label-value>
            </ul>

            <div class="page-details-box-links">
                <a href="javascript:void(0);" ng-click="ctrl.authentication=true;ctrl.openEditGeneralInfoModal();">
                    <cv:msg key="label.edit" bundle="clients" /></a>
            </div>
        </cv-tile-component>

		<!-- Server group-->
        <cv-tile-component ng-show="ctrl.clusterType === 'HADOOP' " ac-id="bigDataServerGroups"
            loader="ctrl.serverGroupsLoaded" data-title='<cv:msg key="label.nav.serverGroups" bundle="navJs" />'>
            <div data-ng-if="ctrl.serverGroups && ctrl.serverGroups.length > 0">
                <div>
                    <ul class="list-style-secondary">
                            <li data-ng-repeat="data in ctrl.serverGroups"><a href="#/clientDetails/{{data.clientGroupId}}">{{data.clientGroupName}}</a></li>
                    </ul>
                </div>
            </div>
            <div data-ng-show="ctrl.serverGroupsLoaded && !ctrl.serverGroups">
                <div><ul class="list-style-secondary">
                		<li><cv:msg key="label.noServergroups" bundle="clients" /></li>
                	</ul>
				</div>
            </div>
            <div class="page-details-box-links">
                <a href="javascript:void(0);" ng-click="ctrl.openEditClientGroupModal();">
                    <cv:msg key="label.edit" bundle="clients" /></a>
            </div>
        </cv-tile-component>

        <cv-tile-component ng-show="ctrl.clusterType === 'HADOOP' && ctrl.clusterConfig && ctrl.clusterConfig.coordinatorNode && ctrl.clusterConfig.coordinatorNode.clientName" ac-id="ctrl.clusterConfig.coordinatorNode"
            loader="ctrl.clusterConfig.coordinatorNode.clientName" data-title='<cv:msg key="label.coordinatorNode" bundle="bigData" />'>
                <div>
	                <div>
	                    <ul class="list-style-secondary">
	                            <li>{{ctrl.clusterConfig.coordinatorNode.clientName}}</li>
	                    </ul>
	                </div>
            	</div>
            	 <div class="page-details-box-links">
                	<a href="javascript:void(0);" ng-click="ctrl.openEditNodesModal();">
                    <cv:msg key="label.edit" bundle="clients" /></a>
            	</div>
        </cv-tile-component>

		<!-- Nodes : Cassandra Nodes-->
        <cv-tile-component ng-show="ctrl.clusterType === 'CASSANDRA'" ac-id="bigDataClusterNodes"
            data-title='<cv:msg key="label.nodes" bundle="bigData" />' data-loader="ctrl.clusterConfig">
            <div data-ng-if="ctrl.clusterConfig.nodes">
                <ul class="list-style-secondary">
                    <li>
                        <table class="table cv-table-bordered">
                            <thead>
                                <tr>
                                    <th ng-bind-html="'<cv:msg key="header.name" bundle="servers"/>'"></th>
                                    <th ng-bind-html="'<cv:msg key="label.node" bundle="bigData"/>'"></th>
                                    <th ng-bind-html="'<cv:msg key="header.ipAddress" bundle="bigData"/>'"></th>
                                    <th ng-bind-html="'<cv:msg key="label.dataCenter" bundle="bigData"/>'"></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr  ng-repeat="node in ctrl.clusterConfig.nodes  | limitTo: (ctrl.currentPage-1)*ctrl.pageSize - ctrl.noOfNodes() | limitTo: ctrl.pageSize">
                                    <td ng-bind="node.nodeName"></td>
                                    <td ng-bind="node.nodeName"></td>
                                    <td ng-bind="node.ipAddress"></td>
                                    <td ng-bind="node.dataCenter"></td>
                                </tr>
                            </tbody>
                        </table>
                    </li>
                </ul>
                <ul data-ng-if="ctrl.noOfNodes()>ctrl.pageSize" class="margin-left-5" uib-pagination
                    boundary-link-numbers="true" boundary-links="true" max-size="5" force-ellipses="true"
                    items-per-page="ctrl.pageSize" total-items="ctrl.noOfNodes()" ng-model="ctrl.currentPage"
                    class="pagination-sm" previous-text="&lsaquo;" next-text="&rsaquo;" first-text="&laquo;"
                    last-text="&raquo;"></ul>
            </div>
            <div data-ng-if="!ctrl.clusterConfig.nodes">
                <p class="info-place-holder">
                    <cv:msg key="label.noNodes" bundle="bigData" />
                </p>
            </div>
            <div class="page-details-box-links" ng-if="ctrl.clusterConfig"><a href="javascript:void(0);"
                    ng-click="ctrl.openEditNodesModal();">
                    <cv:msg key="label.edit" bundle="clients" /></a></div>
        </cv-tile-component>

    </div>

    <div class="col-xs-12 col-sm-6">
        <cv-security-component entity-type="ctrl.entityType" generic-entity='ctrl.genericEntity' associations='ctrl.secParams.associations' associations-loaded='ctrl.secParams.associationsLoaded' client-props="generatePrivacyParams" show-owners=true></cv-security-component>
        <cv-activity-control-component data-ac-params="ctrl.acParams"></cv-activity-control-component>

    </div>
</div>

<!--SubClient Grid-->
<cv-kendo-grid class="case-inline-grid" cv-grid-options="ctrl.gridOptions" ng-if="ctrl.gridOptions" ng-show="ctrl.clusterType !== 'MONGODB' && ctrl.clusterType !== 'HADOOP' && ctrl.isOverviewTabSelected" ></cv-kendo-grid>

<!--snap engine for MongoDB-->
<div class="row" data-ng-if="ctrl.clusterType === 'MONGODB' && !ctrl.isOverviewTabSelected">
	<div class="col-xs-12 col-sm-6">
    	<cv-snap-shot-engine-tile data-ng-if="ctrl.subclientDetails" subclient-details="ctrl.subclientDetails"></cv-snap-shot-engine-tile>
    </div>
</div>

<!--Discover Nodes For MongoDB-->
<div class="row" data-ng-if="ctrl.clusterType === 'MONGODB' && !ctrl.isOverviewTabSelected" >
    <div class="col-xs-12 col-sm-12">
        <cv-kendo-grid class="case-inline-grid" cv-grid-options="ctrl.mongoDBgridNodeOptions" ng-if="ctrl.mongoDBgridNodeOptions" ></cv-kendo-grid>
    </div>
</div>