<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
		<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
		<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
		<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
		<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
</script>
<div class="setup-title"><h1><cv:msg key="action.subclientCreation" bundle="clients" /></h1></div>
<div class="setup-content" >
    <span class="{{serverMessage.type}}" ng-bind="serverMessage.message"></span>
    <form id="createSubclientForm" name="createSubclientForm" novalidate autocomplete="off">
        <div class="bootstrap-wrapper">
            <div  class="modal-list">
                <h4 class="text-left"><cv:msg key="heading.clientGeneral" bundle="clients"/></h4>
                <div id="subclient-general-tab" class="no-min-height">
                    <div class="form-group row">
                        <label class="col-xs-12 col-sm-4" for="subclientName"><cv:msg key="label.SubclientName" bundle="clients" /></label>
                        <div class="col-xs-12 col-sm-8">
                            <input type="text" name="subclientName" ng-class="text-right" id="subclientName" ng-model="ctrl.subclientInfo.subclientName" ng-change="inputAlertFlags.subclientName = false" required autofocus >
                            <span class="help-block" ng-show="ctrl.inputAlertFlags.subclientName"><cv:msg key="error.subclientName" bundle="clients" /></span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="plans" class="col-xs-12 col-sm-4"><cv:msg key="label.profile" bundle="profiles"/></label>
                        <div class="col-xs-12 col-sm-8">
                            <isteven-multi-select id="bigDataAddSubclient_isteven-multi-select_#0076"  
                                input-model="ctrl.planList" 
                                output-model="ctrl.selectedPlanList" 
                                button-label="planName" 
                                item-label="planName" 
                                tick-property="selected"
                                class="isteven-multi-select user-group-select" 
                                helper-elements="none" 
                                selection-mode="single" 
                                on-close="ctrl.parseIStevenOutput()" 
                                translation="ctrl.localLang" 
                                group-property="msGroup">
                            </isteven-multi-select>
                            <span class="help-block" ng-show="ctrl.inputAlertFlags.plan"><cv:msg key="error.selectPlan" bundle="profiles"/></span>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label for="plans" class="col-xs-12 col-sm-4"><cv:msg key="label.dataAccessNodes" bundle="bigData"/></label>
                        <div class="col-xs-12 col-sm-8">
                            <isteven-multi-select id="bigDataAddSubclient_isteven-multi-select_#2880"  
                                input-model="ctrl.clientList" 
                                output-model="ctrl.selectedClientList" 
                                button-label="clientName" 
                                item-label="clientName" 
                                tick-property="selected"
                                class="isteven-multi-select user-group-select" 
                                helper-elements="none" 
                                selection-mode="multiple" 
                                on-close="ctrl.parseClientsOutput()" 
                                translation="ctrl.localLang">
                            </isteven-multi-select>
                            <span class="help-block" ng-show="ctrl.inputAlertFlags.dataAccessNode"><cv:msg key="error.selectPlan" bundle="profiles"/></span>
                        </div>
                    </div>
                </div>
            </div>
            <uib-accordion close-others="true"  class="text-left">
                <div uib-accordion-group is-open="model.accordionStatus.contentTab" scroll-to-when-open >
					<uib-accordion-heading>
						<cv:msg key="header.content" bundle="collections"/>
						<i class="float-right glyphicon" ng-class="{'glyphicon-chevron-down': model.accordionStatus.contentTab, 'glyphicon-chevron-right': !model.accordionStatus.contentTab}"></i>
					</uib-accordion-heading>
					<div id="subclient-content-tab" class="no-min-height">
						<div class="custom-content-container">
							<div class="form-group row">
								<label class="col-xs-12 col-lg-4" for="customPath"><cv:msg key="label.typeCustomPath" bundle="messages" /></label>
								<div class="col-xs-12 col-lg-8">
								    <input type="text" name="customPath" ng-class="text-right" id="customPath" ng-keypress="($event.which === 13) ? ctrl.addCustomPath(ctrl.model.customPath):0" ng-model="ctrl.model.customPath" required autofocus>
								    <i class="input-icon-right glyphicon glyphicon-plus" ng-click="ctrl.addCustomPath(ctrl.model.customPath)"></i>
								</div>
							</div>								
							<div ng-if="ctrl.subclientInfo.content.typeWiseCounterArray[0].counter == 0">
								<div class="col-xs-12 col-lg-8 col-lg-offset-4">
								    <button id="bigDataAddSubclient_button_#9798" type="button" class="btn btn-primary cvBusyOnAjax" ng-click="ctrl.addContent()"><cv:msg key="label.addEditContent" bundle="messages" /></button> 
								</div>								
                            </div>
                            <div ng-if="ctrl.subclientInfo.content.typeWiseCounterArray[0].counter > 0" id="fs-table-wrapper">
								<ul class="manageCollectionList list-style__row group content-table-header">
									<li><input type="checkbox" ng-change="ctrl.toggleAllPaths(ctrl.model.toggleAllState)" ng-model="ctrl.model.toggleAllState" id="title"><label class="inline-label" for="title"><cv:msg key="label.filesFolders" bundle="messages" /></label></li>
								</ul>
								<span class="modal-page-action-item"><a href="" ng-if="ctrl.showRemovePaths()" ng-click="ctrl.removePaths()"><cv:msg key="label.remove" bundle="clients" /></a><a href="" ng-click="ctrl.addContent()"><cv:msg key="Add" bundle="messages" /></a></span> 
								<div class="limit-modal-height custom-content-wrapper">
								    <!--FS: This div shows only the content of path type.includePath and excludePath type content wont be showed here. -->
									<ul class="manageCollectionList list-style__row">
										<div class="custom-content__UL">
											<li ng-if="ctrl.subclientInfo.content.typeWiseCounterArray[0].counter == 0">
												<div class="form-group row">
													<label class="collection-label col-xs-12 col-md-12 col-lg-12">
														<cv:msg key="label.NoContentAdded" bundle="clients" />
													</label>
												</div>
											</li>
											<li ng-repeat="contentEntity in ctrl.subclientInfo.content.contentEntities" ng-if="contentEntity.type == 0"><input type="checkbox" ng-model="contentEntity.selected" id="{{contentEntity.path}}"><label class="collection-label" ng-bind="contentEntity.path" for="{{contentEntity.path}}"></label></li>
										</div>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
            </uib-accordion>
        </div>
        <div class="button-container">
            <button id="bigDataAddSubclient_button_#7569" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" ng-click="ctrl.cancel()"><cv:msg key="Cancel" bundle="messages" /></button> 
            <button id="bigDataAddSubclient_button_#4685" type="button" class="btn btn-primary cvBusyOnAjax" ng-click="ctrl.addSubclient()" ><cv:msg key="Save" bundle="messages" /></button> 
        </div>
    </form>
</div>
