<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1 ng-bind="ctrl.titleText"></h1>
</div> 
<div class="wrapper-view bootstrap-wrapper">
	<div class="margin-left-0 serverMessage" ng-class="ctrl.serverMessage.type" ng-bind="ctrl.serverMessage.message"></div>
	<div class="bootstrap-wrapper">
		<form class="form-horizontal" id="addDataCenterForm" name="addDataCenterForm" cv-submit="ctrl.addDataCenter()" novalidate autocomplete="off">
			<div class="form-group row" ng-if="!ctrl.isEditMode">
				<label class="col-xs-12 col-sm-4" for="dcName"><cv:msg key="tableHeading.name" bundle="bigData" /></label>
				<div class="col-xs-12 col-sm-8">
					<input type="text" id="dcName" name="dcName" ng-model="ctrl.dcName" data-ng-change="ctrl.inputAlertFlags.dcName = false;"/>
					<span class="help-block" data-ng-show="ctrl.inputAlertFlags.dcName"><cv:msg key="error.dcName" bundle="bigData" /></span>
				</div>
			</div>
			<div class="form-group row" ng-if="!ctrl.isEditMode">
				<label for="plans" class="col-xs-12 col-sm-4"><cv:msg key="label.profile" bundle="profiles"/></label>
				<div class="col-xs-12 col-sm-8">
					<isteven-multi-select id="bigDataAddDataCenterModal_isteven-multi-select_#3487"  
						input-model="ctrl.planList" 
						output-model="ctrl.selectedPlanList" 
						button-label="planName" 
						item-label="planName" 
						tick-property="selected"
						class="isteven-multi-select user-group-select" 
						helper-elements="none" 
						selection-mode="single" 
						on-close="ctrl.parseIStevenOutput()" 
						translation="ctrl.localLang" 
						group-property="msGroup">
					</isteven-multi-select>
					<span class="help-block" ng-show="ctrl.inputAlertFlags.plan"><cv:msg key="error.selectPlan" bundle="profiles"/></span>
				</div>
			</div>
			<div class="cv-modal-wrapper">
				<cv-kendo-grid class="no-padding" cv-grid-options="ctrl.gridOptions" ng-if="ctrl.gridOptions"></cv-kendo-grid>
			</div>
			<div class="button-container">
				<button id="bigDataAddDataCenterModal_button_#8421" type="button" class="btn btn-default cvBusyOnAjax" ng-click="ctrl.dismissModal()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
				<button id="bigDataAddDataCenterModal_button_#0554" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="action.save" bundle="profiles"/></button> 
			</div>
		</form>
	</div>
</div>