<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.bigData"></cv:cvMessages>
	<cv:cvMessages bundle="localization.sendLogs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>
	<div class="panel panel-default">
	<div class="panel-body">
	<div class="bootstrap-wrapper form-horizontal padding-bottom-0">
		<form id="addHDFSForm" name="addHDFSForm" autocomplete="off" novalidate>
			<div class="modal-list">
				<div class="form-group" data-ng-if="showName()">
					<label class="col-xs-12 col-sm-4" for="name">
						<cv-help-text help-label="label.bigDataName" help-text="helpText.HadoopName" />
					</label>
					<div class="col-xs-12 col-sm-8">
						<input type="text" name="name" data-ng-class="text-right" id="name" data-ng-model="model.name" data-ng-change="inputAlertFlags.name = false" required autofocus >
						<span class="help-block" data-ng-show="inputAlertFlags.name"><cv:msg key="error.name" bundle="bigData" /></span>
					</div>
				</div>
                <div class="form-group">
                    <label class="col-xs-12 col-sm-4" for="dataAccessNodes">
                    	<cv:msg key="label.dataAccessNodes" bundle="bigData" />
                    </label>
                    <div class="col-xs-12 col-sm-7">
                        <isteven-multi-select
                            input-model="dummyModel.clients"
                            output-model="model.dataAccessNodes"
                            button-label="clientName"
                            item-label="clientName"
                            tick-property="selected"
                            class="isteven-multi-select user-group-select"
                            id="dataAccessNodes"
                            on-item-click="clickDataAccessNode(data)"
                            max-labels="1"
                            helper-elements="all none filter"
                            translation="localLang"
                            >
                        </isteven-multi-select>
                        <span class="help-block" data-ng-show="inputAlertFlags.dataAccessNodes"><cv:msg key="error.dataAccessNodes" bundle="bigData" /></span>
                    </div>

                     <div class="col-xs-12 col-sm-1  padding-left-0" >
                        <span class="input-group-btn">
                            <button id="selectWithCreateButton_button_#2034"
                                type="button"
                                class="icon-style cv-material-button browse"
                                data-ng-click="openPushInstallDialog()">
                                <div class="cv-material-button-icon cursor-pointer">
                                    <span class="k-icon k-i-plus font-size-page-title primary-theme-color cursor-pointer"> </span>
                                </div>
                            </button>
                        </span>
                    </div>

				</div>
				<div class="form-group">
					<label class="col-xs-12 col-sm-4" for="hdfsUser">
						<cv-help-text help-label="label.hdfsUser" help-text="helpText.hdfsUser" />
					</label>
					<div class="col-xs-12 col-sm-8">
						<input type="text" name="hdfsUser" data-ng-class="text-right" id="hdfsUser" data-ng-model="model.hdfsUser" data-ng-change="inputAlertFlags.hdfsUser = false" required autofocus >
						<span class="help-block" data-ng-show="inputAlertFlags.hdfsUser"><cv:msg key="error.hdfsUser" bundle="bigData" /></span>
					</div>
				</div>
				<!-- PLAN -->
				<div class="form-group">
					<label class="col-xs-12 col-sm-4" for="plan">
						<cv-help-text help-label="label.plan" help-text="helpText.plan" />
					</label>
					<div class="col-xs-12 col-sm-8">
                        <isteven-multi-select
                            input-model="dummyModel.plans"
							output-model="model.plan"
                            tick-property="selected"
                            item-label="planName"
                            class="isteven-multi-select user-group-select"
                            button-label="planName"
							id="plan"
                            helper-elements="filter"
                            selection-mode="single"
                            on-item-click="clickPlan(data)"
							translation="localLang"
                            disable-property="disabled">
                        </isteven-multi-select>
						<span class="help-block" data-ng-show="inputAlertFlags.plan"><cv:msg key="error.plan" bundle="bigData" /></span>
					</div>
				</div>
				<!-- Content start-->
				<div class="position-relative">
					<div class="form-group row margin-top-20" ng-repeat="(key, content) in clientContent">
						<label class="col-xs-12 col-sm-4 line-height-31" ng-bind="content.contentTypeLabel"></label>
						<div class="col-xs-12 col-sm-7 line-height-31 text-left">
							<span class="crop max-width" ng-bind="content.contentLabel" popover-class="no-border" uib-popover-html="getContentPopOver(content)"  popover-trigger="'mouseenter'"></span>
						</div>
					</div>
					<div class="position-absolute top-0 right-0 line-height-31">
						<a class="inline-editor-button text" id="edit-content" ng-click="overrideContentForClient()"><cv:msg key="label.edit" bundle="settingsJs" /></a>
					</div>
				</div>
				<!-- Content end-->
				<uib-accordion close-others="true"  class="text-left margin-top-20">
					<div uib-accordion-group data-is-open="accordionStatus.configureHbase" data-scroll-to-when-open >
						<uib-accordion-heading>
							<cv:msg key="heading.configureHbase" bundle="bigData"/> <span class="optional-text"><cv:msg key="label.optional" bundle="subscriptions"/></span>
							<i class="float-right glyphicon" data-ng-class="{'glyphicon-chevron-down': accordionStatus.configureHbase, 'glyphicon-chevron-right': !accordionStatus.configureHbase}"></i>
						</uib-accordion-heading>
						<div class="form-group">
							<label class="col-xs-12 col-sm-4" for="hbaseuser">
								<cv-help-text help-label="label.hbaseuser" help-text="helpText.hbaseuser" />
							</label>
							<div class="col-xs-12 col-sm-8">
								<input type="text" name="hbaseuser" data-ng-class="text-right" id="hbaseuser" data-ng-model="model.hbaseUser" data-ng-change="inputAlertFlags.hbaseUser = false" required autofocus >
							</div>
						</div>
						<div class="form-group">
							<label class="col-xs-12 col-sm-4" for="stagingLocation">
								<cv-help-text help-label="label.stagingLocation" help-text="helpText.stagingLocation" />
							</label>
							<div class="col-xs-12 col-sm-8">
								<input type="text" name="stagingLocation" data-ng-class="text-right" id="stagingLocation" data-ng-model="model.stagingLocation" data-ng-change="inputAlertFlags.stagingLocation = false" required autofocus >
								<span class="help-block" data-ng-show="inputAlertFlags.stagingLocation"><cv:msg key="error.hadoop.stagingLocation" bundle="bigData" /></span>
							</div>
						</div>
					</div>
				</uib-accordion>
			</div>
		</form>
	</div>
	</div>
</div>