<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="row bootstrap-wrapper">
    <div class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
        <p><a ui-sref="appConfig({ appId: vm.page.appId })">Back to App</a></p>
        <form class="form-horizontal">
            <h1 class="page-header">Page Configuration</h1>
            <div class="panel panel-default">
                <div class="panel-body">
                    <div class="form-group">
                        <label class="col-xs-12 col-lg-3" for="pageName">Name</label>
                        <div class="col-xs-12 col-lg-6">
                            <input type="text" name="pageName" ng-model="vm.page.name" required autofocus/>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-xs-12 col-lg-3" for="pageDesc">Description</label>
                        <div class="col-xs-12 col-lg-6">
                            <textarea name="pageDesc" name="pageDesc" ng-model="vm.page.description"></textarea>
                        </div>
                    </div>
        
                    <div class="form-group">
                        <label class="col-xs-12 col-lg-3" for="pageOrder">Page Order</label>
                        <div class="col-xs-12 col-lg-6">
                            <input type="text" name="pageOrder" ng-model="vm.page.order" id="pageOrder" />
                        </div>
                    </div>
        
                    <div class="form-group">
                        <!-- TODO: [app-designer] need better readonly styles -->
                        <label class="col-xs-12 col-lg-3" for="pageType">Page Type</label>
                        <div class="col-xs-12 col-lg-6">
                            <isteven-multi-select id="pageConfig_isteven-multi-select_#9949" 
                                    input-model="vm.pageTypes"
                                    output-model="vm.selectedType"
                                    button-label="name"
                                    item-label="name"
                                    tick-property="selected"
                                    class="isteven-multi-select user-group-select"
                                    helper-elements="filter"
                                    selection-mode="single"
                                    on-close="vm.onPageTypeChange()"
                            >
                            </isteven-multi-select>
                        </div>
                    </div>
            
                    <div class="form-group" ng-if="vm.appPageType && ((vm.assocType && vm.assocItem.length) || (!vm.assocType))">
                        <label class="col-xs-12 col-lg-3">{{vm.appPageType.name}}</label>
                        <div class="col-xs-12 col-lg-6">
                            <isteven-multi-select id="pageConfig_isteven-multi-select_#4327" 
                                    input-model="vm.list"
                                    output-model="vm.selectedItem"
                                    button-label="name"
                                    item-label="name"
                                    tick-property="selected"
                                    class="isteven-multi-select user-group-select"
                                    helper-elements="filter"
                                    selection-mode="single"
                                    on-close="vm.onItemChange()"
                            >
                            </isteven-multi-select>
                        </div>
                    </div>
                    <div class="form-group" ng-if="vm.appPageType && vm.appPageType.id === 'table' && vm.selectedItem">
                        <label class="col-xs-12 col-lg-3">View</label>
                        <div class="col-xs-12 col-lg-6">
                            <isteven-multi-select id="pageConfig_isteven-multi-select_#8638" 
                                    input-model="vm.viewList"
                                    output-model="vm.selectedView"
                                    button-label="name"
                                    item-label="name"
                                    tick-property="selected"
                                    class="isteven-multi-select user-group-select"
                                    helper-elements="filter"
                                    selection-mode="single"
                            >
                            </isteven-multi-select>
                        </div>
                    </div>
                    <hr/>
                    <small>Created: {{vm.page.created.at | date:'medium'}}</small><br>
                    <small>Modified: {{vm.page.modified.at | date:'medium'}}</small>
                </div>
            </div>
            <div class="button-container">
                <button id="pageConfig_button_#7194" type="button" class="btn cv-delete-link pull-left cvBusyOnAjax" ng-click="vm.handleDeletePage()">Delete</button> 
                <button id="pageConfig_button_#4556" type="button" class="btn btn-default cvBusyOnAjax" ui-sref="appConfig({ appId: vm.page.appId })">Cancel</button> 
                <button id="pageConfig_button_#7316" type="submit" class="btn btn-primary cvBusyOnAjax" ng-click="vm.handleEditPage()">Save Page</button> 
            </div>
        </form>
    </div>
</div>
