<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="app-designer-page save-page-modal">
    <div class="setup-title">
        <h1>{{ ::(vm.isNewColumn()) ? 'Create Column' : 'Edit Column' }}</h1>
    </div>
    <div class="setup-content">
        <div class="addPageMessage serverMessage">{{addAppMessage.message}}</div>
        <form name="addPageForm" cv-submit="vm.saveAndEdit()" autocomplete="off" id="addPageForm">
            <!-- // column name // -->
            <div class="cv-modal-wrapper">
                <label for="columnName" class="cv-label">Name</label>
                <div class="cv-inline-wrapper">
                    <input type="text" name="columnName" ng-model="vm.column.name" id="columnName" ng-keypress="vm.onChangeName($event)" required autofocus/>
                </div>
            </div>
            <div data-ng-class="vm.classes.formGroupClass">
                <!-- TODO: [app-designer] need better readonly styles -->
                <label data-ng-class="vm.classes.labelClass" for="inputType">Field Type</label>
                <div data-ng-class="vm.classes.inputContainerClass">
                    <select required id="inputType"
                            data-ng-model="vm.column.type"
                            data-ng-options="fieldType.name as fieldType.label for fieldType in vm.fieldTypes" class="isteven-multi-select user-group-select">
                        <option value=""></option>
                    </select>
                </div>
            </div>
            <table-field-reference column="vm.column" classes="vm.classes" ng-if="vm.column.type === 'Reference'"></table-field-reference>
            <table-field-file column="vm.column" classes="vm.classes" ng-if="vm.column.type === 'File'"></table-field-file>
            <div class="button-container">
                <button id="columnEditModal_button_#7840" type="button" class="btn btn-default pull-left cvBusyOnAjax" ng-click="vm.cancel()">Cancel</button> 
                <%--<button id="columnEditModal_button_#0944" type="button" class="btn btn-default cvBusyOnAjax" ng-click="vm.saveAndEdit()">Create and edit</button>--%>
                <button id="columnEditModal_button_#1390" type="submit" class="btn btn-primary cvBusyOnAjax">{{ (vm.isNewColumn()) ? 'Create' : 'Save Column' }}</button> 
            </div>
        </form>
    </div>
</div>