<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="app-designer-page row bootstrap-wrapper">
    <div class="col-xs-12 col-md-10 col-md-offset-1 col-lg-8 col-lg-offset-2">
        <p><a ui-sref="tableConfig({ tableId: vm.column.tableId})">Back to table</a></p>
        <form class="form-horizontal">
            <h1 class="page-header">Field Configuration</h1>
            <div class="panel panel-default">
                <div class="panel-body">
                    <div data-ng-class="vm.classes.formGroupClass">
                        <label data-ng-class="vm.classes.labelClass" for="columnName">Name</label>
                        <div data-ng-class="vm.classes.inputContainerClass">
                            <input type="text" name="columnName" ng-model="vm.column.name" id="columnName" required disabled/>
                        </div>
                    </div>
                    <div data-ng-class="vm.classes.formGroupClass">
                        <label data-ng-class="vm.classes.labelClass" for="displayName">Display Name</label>
                        <div data-ng-class="vm.classes.inputContainerClass">
                            <input type="text" name="displayName" ng-model="vm.column.displayName" id="displayName" />
                        </div>
                    </div>
                    <div data-ng-class="vm.classes.formGroupClass">
                        <label data-ng-class="vm.classes.labelClass" for="columnDescription">Description</label>
                        <div data-ng-class="vm.classes.inputContainerClass">
                            <textarea name="columnDesc" id="columnDescription" ng-model="vm.column.description"></textarea>
                        </div>
                    </div>
                    <div data-ng-class="vm.classes.formGroupClass">
                        <!-- TODO: [app-designer] need better readonly styles -->
                        <label data-ng-class="vm.classes.labelClass" for="inputType">Field Type</label>
                        <div data-ng-class="vm.classes.inputContainerClass">
                            <select style="opacity:0.6" disabled id="inputType"
                                    data-ng-model="vm.column.type"
                                    data-ng-options="fieldType.name as fieldType.label for fieldType in vm.fieldTypes" class="isteven-multi-select user-group-select">
                                <option value=""></option>
                            </select>
                        </div>
                    </div>
                    <table-field-number column="vm.column" classes="vm.classes" ng-if="vm.column.type === 'Number'"></table-field-number>
                    <table-field-boolean column="vm.column" classes="vm.classes" ng-if="vm.column.type === 'Boolean'"></table-field-boolean>
                    <table-field-lookup column="vm.column" classes="vm.classes" ng-if="vm.column.type === 'Lookup'"></table-field-lookup>
                    <table-field-text column="vm.column" classes="vm.classes" ng-if="vm.column.type === 'Text'"></table-field-text>
                    <table-field-long-text column="vm.column" classes="vm.classes" ng-if="vm.column.type === 'LongText'"></table-field-long-text>
                    <table-field-rich-text column="vm.column" classes="vm.classes" ng-if="vm.column.type === 'RichText'"></table-field-rich-text>
                    <table-field-reference column="vm.column" classes="vm.classes" ng-if="vm.column.type === 'Reference'"></table-field-reference>
                    <table-field-date column="vm.column" classes="vm.classes" ng-if="vm.column.type === 'Date'"></table-field-date>
                    <table-field-date-time column="vm.column" classes="vm.classes" ng-if="vm.column.type === 'DateTime'"></table-field-date-time>
                    <table-field-file column="vm.column" classes="vm.classes" ng-if="vm.column.type === 'File'" disabled="true"></table-field-file>
                    <table-field-choices column="vm.column" classes="vm.classes"
                                         ng-if="vm.column.type === 'Number' || vm.column.type === 'Date' || vm.column.type === 'Text' || vm.column.type === 'DateTime'"></table-field-choices>
                    <div data-ng-class="vm.classes.formGroupClass">
                        <label data-ng-class="vm.classes.labelClass" for="columnRequired">Required</label>
                        <div data-ng-class="vm.classes.inputContainerClass" style="display: flex; height: 40px; align-items: center;">
                            <input id="columnRequired" type="checkbox" class="inputRadio" data-ng-model="vm.column.required" />
                        </div>
                    </div>
                    <div data-ng-class="vm.classes.formGroupClass" ng-if="vm.column.type !== 'Boolean' && vm.column.type !== 'File' && vm.column.type !== 'LongText' && vm.column.type !== 'RichText'">
                        <label data-ng-class="vm.classes.labelClass" for="columnUnique">Unique</label>
                        <div data-ng-class="vm.classes.inputContainerClass" style="display: flex; height: 40px; align-items: center;">
                            <input id="columnUnique" type="checkbox" class="inputRadio" data-ng-model="vm.column.unique" />
                        </div>
                    </div>
                                        
                    <hr/>
                    <small>Created: {{vm.column.created.at | date:'medium'}}</small><br>
                    <small>Modified: {{vm.column.modified.at | date:'medium'}}</small>
                </div>
            </div>
            <div class="button-container">
                <button id="columnConfig_button_#1682" type="button" class="btn cv-delete-link pull-left cvBusyOnAjax" ng-click="vm.handleDeleteColumn()">Delete</button> 
                <button id="columnConfig_button_#4719" type="button" class="btn btn-default cvBusyOnAjax" ui-sref="tableConfig({ tableId: vm.column.tableId})">Cancel</button> 
                <button id="columnConfig_button_#6020" type="submit" class="btn btn-primary cvBusyOnAjax" ng-click="vm.handleEditColumn()">Save Column</button> 
            </div>
        </form>
    </div>
</div>
