import get from 'lodash/get';

export function cellBusinessRuleNameTemplate(label, href) {
	return `
        <a class="crop"
            title="{{${label}}}"
            href="${href}"
        >{{${label}}}</a>
    `;
}

export function cellNameTemplate(label, sref) {
	return `
        <a class="crop" 
            title="{{${label}}}" 
            ui-sref="${sref}"
        >{{${label}}}</a>
    `;
}

export function cellBusinessRuleTriggerTemplate(ruleTriggers) {
	const triggers = Object.keys(ruleTriggers);

	return `{{${Object.keys(ruleTriggers).join(', ')}}}`;
}

export function pathAccess(p, o) {
	const logic = o => p.reduce((xs, x) => (xs && xs[x] ? xs[x] : null), o);
	return !o ? o => logic : logic(o);
}

export function getErrMessage(err) {
	return get(err, ['data', 'errorMessage']) || err.errorMessage;
}

export function cellActionTemplate(actionItems = []) {
	let templateItems = [];

	actionItems.forEach(item => {
		templateItems.push(`
            <li>
                <a href="javascript:void(0)" class="ui-grid-action-items" ng-click="${item.action}" ${item.sref &&
			"ui-sref='" + item.sref + "'"}">
                    ${item.label}
                </a>
            </li>
        `);
	});

	return `
        <div class="btn-group" uib-dropdown>
            <a href class="uib-dropdown-toggle" uib-dropdown-toggle><span class="grid-action-icon"></span></a>
            <ul uib-dropdown-menu class="dropdown-menu" role="menu">${templateItems.join('')}</ul>
        </div>
    `;
}

export function objToString(obj) {
	return JSON.stringify(obj);
}

export function cloneObjectInstance(obj) {
	// this will ensure instances of classes maintain the correct prototype
	// a basic Object.assign({}, obj) would not do that
	return Object.assign(Object.create(Object.getPrototypeOf(obj)), obj);
}

export function formatSecurityAssociations(securityAssociations) {
	let associations = $.extend([], true, securityAssociations.associations) || [];
	let ownerId = null;

	if (associations) {
		for (var index = 0; index < associations.length; index++) {
			var curAssoc = associations[index];
			if (curAssoc.userOrGroup[0].externalGroupName)
				if (curAssoc.userOrGroup[0].providerDomainName)
					curAssoc.userOrGroup[0].externalGroupName =
						curAssoc.userOrGroup[0].providerDomainName + '\\' + curAssoc.userOrGroup[0].externalGroupName;
		}
	}

	const owner = associations.find((e, i) => {
		ownerId = i;
		return e['properties'].isCreatorAssociation === true;
	});

	if (owner) {
		associations.splice(ownerId, 1);
		associations.splice(0, 0, owner);
	}

	return { ...securityAssociations, associations };
}
