import { appDesignerModule } from 'common/js/modules';

import '../../services/reports.svc';
import '../../services/tables.svc';

function TableFieldReference(reportService, customReportSvc, ReportsService, TablesService) {
	return {
		restrict: 'E',
		templateUrl: appUtil.appRoot + 'appDesigner/js/table-fields/reference/reference.html',
		scope: {
			column: '=',
			classes: '='
		},
		link: function($scope, element, attrs) {
			$scope.fields = [];
			$scope.sortOptions = ['label', 'value', 'None'];
			$scope.sortDirs = ['Asc', 'Desc'];
			$scope.columnsTableRef = [];

			// $scope.column.fieldOptions = schema;

			$scope.getTables = function() {
				TablesService.getTables().then(function(data) {
					$scope.tableList = data;
				});
			};

			$scope.getTableColumns = function(table) {
				table.getColumns().then(function(data) {
					$scope.columnsTableRef = data;
				});
			};

			$scope.getDataSets = function() {
				$scope.dsList = [];
				reportService
					.getAllDataSets(true)
					.then(
						function(data) {
							if (data.data.dataSet) {
								$scope.dsList = $scope.dsList.concat(data.data.dataSet);
							}
							if ($scope.column.fieldOptions.dataSetEntity) {
								$scope.dsList.forEach(dataSet => {
									if (dataSet.dataSet.dataSetName === $scope.column.fieldOptions.dataSetEntity.dataSetName) {
										$scope.column.fieldOptions.dataSetEntity = dataSet.dataSet;
										return;
									}
								});

								$scope.getFieldsFromDataSet($scope.column.fieldOptions.dataSetEntity);
							}
						},
						function(error) {
							alert(error.data);
						}
					)
					.catch(function(err) {});
			};

			$scope.getFieldsFromDataSet = function(datasetEntity) {
				if (!datasetEntity) return;
				const datasetId = datasetEntity.dataSetId;
				$scope.fields = [];
				ReportsService.getFieldsForDataSet(datasetId).then(data => {
					$scope.fields = data.data.columns.map(column => column.name);
					$scope.column.fieldOptions = schema;
				});
			};

			$scope.getTables();
		}
	};
}

TableFieldReference.$inject = ['reportService', 'customReportSvc', 'ReportsService', 'TablesService', '$log', '$q'];

appDesignerModule.directive('tableFieldReference', TableFieldReference);
