import { appDesignerModule } from 'common/js/modules';

import '../../services/reports.svc';
import '../../services/tables.svc';

function TableFieldFile(reportService, customReportSvc, ReportsService, TablesService, cvUtil) {
	return {
		restrict: 'E',
		templateUrl: appUtil.appRoot + 'appDesigner/js/table-fields/file/file.html',
		scope: {
			column: '=',
			classes: '=',
			disabled: '='
		},
		link: function($scope, element, attrs) {
			if ($scope.column) {
				if ($scope.column.defaultValue === undefined) {
					$scope.column.defaultValue = null;
				}
			}

			TablesService.getFileStores().then(fileStores => {
				$scope.fileStores = fileStores
					? fileStores.map(fileStore => {
							if (fileStore['privateShare']) {
								return {
									shareName: fileStore['objectStore'].clientName,
									shareId: fileStore['privateShare'].shareId
								};
							}
					  })
					: [];
			});
		}
	};
}

TableFieldFile.$inject = [
	'reportService',
	'customReportSvc',
	'ReportsService',
	'TablesService',
	'cvUtil',
	'$log',
	'$q'
];

appDesignerModule.directive('tableFieldFile', TableFieldFile);
