import { appDesignerModule } from 'common/js/modules';

import '../controllers/tableEditModal.ctrl';
import { getErrMessage } from '../util';

function TableEditModalService(cvLoc, $modal, cvToaster) {
	this.openModal = function openModal(table) {
		let modalInstance = $modal.open({
			templateUrl: appUtil.appRoot + 'appDesigner/partials/tableEditModal.jsp',
			backdrop: 'static',
			controllerAs: 'vm',
			controller: 'TableEditModalCtrl',
			resolve: {
				table: function() {
					return table;
				}
			}
		});
		modalInstance.result.then(onSave, onCancel);

		function onSave(table) {
			cvToaster.showSuccessMessage({
				message: cvLoc('appdesigner.msg.saveSuccessful', '<b>' + table.name + '</b>')
			});
		}

		function onCancel(err) {
			if (err === 'close') return;
			if (err === 'escape key press') return;
			if (err) {
				const message = getErrMessage(err);
				cvToaster.showErrorMessage({
					message
				});
			}
		}

		return modalInstance.result;
	};
}

TableEditModalService.$inject = ['cvLoc', '$uibModal', 'cvToaster'];

appDesignerModule.service('TableEditModalService', TableEditModalService);

export default appDesignerModule;
