import { appDesignerModule } from 'common/js/modules';

import '../controllers/columnEditModal.ctrl';
import '../../../reportsplus/security/showSecurityModal';
import '../../../reportsplus/js/checklist-model.js';

import { getErrMessage } from '../util';

function ShowSecurityModalService(cvLoc, $modal, cvToaster) {
	this.openModal = function openModal(entity) {
		let modalInstance = $modal.open({
			templateUrl: appUtil.appRoot + 'reportsplus/security/showSecurityModal.jsp',
			backdrop: 'static',
			controllerAs: 'vm',
			controller: 'showSecurityModalCtrl',
			resolve: {
				entity: function() {
					return entity;
				}
			}
		});
		modalInstance.result.then(onSave, onCancel);

		function onSave(entity) {
			if (!entity) return;
			cvToaster.showSuccessMessage({
				message: cvLoc('appdesigner.msg.saveSuccessful', '<b>' + entity.name + '</b>')
			});
		}

		function onCancel(err) {
			if (err === 'close') return;
			if (err === 'escape key press') return;
			if (err) {
				const message = getErrMessage(err);
				cvToaster.showErrorMessage({
					message
				});
			}
		}

		return modalInstance.result;
	};
}

ShowSecurityModalService.$inject = ['cvLoc', '$uibModal', 'cvToaster'];

appDesignerModule.service('ShowSecurityModalService', ShowSecurityModalService);

export default appDesignerModule;
