import { appDesignerModule } from 'common/js/modules';

// TODO: [app-designer] the hash in this url, is it specific to CRV2?
let endpoint =
	window.location.pathname + 'proxy/cr/reportsplusengine/datasets/e4e45625-80c0-4589-ba33-d1e4cba4af95/data/';
let apiFields = datasetId => `${window.location.pathname}proxy/cr/reportsplusengine/datasets/${datasetId}/fields/`;

function ReportsService($http, $log, $q) {
	this.getReports = function getReports() {
		return $http
			.get(endpoint, {
				params: {
					fields: 'reportId,name,description,guid'
				},
				cache: true
			})
			.then(onGetReportsSuccess, onRequestFailure);

		function onGetReportsSuccess(res) {
			// some post processing of the response to shape things into something usable…
			return res.data.records.map(record => {
				let report = {
					id: record[0].toString(),
					name: record[1],
					description: record[2],
					guid: record[3]
				};
				return report;
			});
		}
	};

	function onRequestFailure(err) {
		// TODO: [app-designer] better error handler
		$log.error(err);
		return $q.reject(err);
	}

	this.getFieldsFromDataSet = function(datasetId) {
		const url = apiFields(datasetId);
		return $http.get(url, { cache: true });
	};
}

ReportsService.$inject = ['$http', '$log', '$q'];

appDesignerModule.service('ReportsService', ReportsService);

export default appDesignerModule;
