import { appDesignerModule } from 'common/js/modules';

// dependencies injected by Angular
import '../controllers/appEditModal.ctrl';
import { getErrMessage, pathAccess } from '../util';

function AppEditModalService(cvLoc, $modal, cvToaster) {
	this.openModal = function openModal(app) {
		if (app === undefined) {
			throw new Error('App instance requried');
		}

		let modalInstance = $modal.open({
			templateUrl: appUtil.appRoot + 'appDesigner/partials/appEditModal.jsp',
			backdrop: 'static',
			controllerAs: 'vm',
			controller: 'AppEditModalCtrl',
			resolve: {
				app: function() {
					return app;
				}
			}
		});
		modalInstance.result.then(onSave, onCancel);

		function onSave(app) {
			cvToaster.showSuccessMessage({
				message: cvLoc('appdesigner.msg.saveSuccessful', '<b>' + app.name + '</b>')
			});
		}

		function onCancel(err) {
			if (err === 'close') return;
			if (err === 'escape key press') return;
			const message = getErrMessage(err);
			cvToaster.showErrorMessage({
				message
			});
		}

		return modalInstance.result;
	};
}

AppEditModalService.$inject = ['cvLoc', '$uibModal', 'cvToaster'];

appDesignerModule.service('AppEditModalService', AppEditModalService);

export default appDesignerModule;
