import { appDesignerModule } from 'common/js/modules';

import { cloneObjectInstance } from '../util';

function TableEditModalCtrl($uibModalInstance, table) {
	let vm = this;

	let tableId = table.id;

	// work with copy not original instance
	vm.table = cloneObjectInstance(table);

	vm.isNewTable = function isNewTable() {
		return tableId === undefined;
	};

	/**
	 * When the cancel button is pressed.
	 */
	vm.cancel = function cancel() {
		$uibModalInstance.dismiss();
	};

	vm.saveTable = function saveTable() {
		vm.table.save().then(onRequestSuccess, onRequestFailure);

		function onRequestSuccess(res) {
			$uibModalInstance.close(res);
		}
		function onRequestFailure(err) {
			$uibModalInstance.dismiss(err);
		}
	};
}

TableEditModalCtrl.$inject = ['$uibModalInstance', 'table'];

appDesignerModule.controller('TableEditModalCtrl', TableEditModalCtrl);

export default appDesignerModule;
