import { appDesignerModule, cvCommon } from 'common/js/modules';
import get from 'lodash/get';
// dependencies
import '../services/apps.svc';
import '../services/pageType.svc';
import { getErrMessage } from '../util';

function PageEditModalCtrl($state, $uibModalInstance, AppsService, page, PageTypeService, cvToaster, cvLoc) {
	let vm = this;

	let pageId = page.sys_id || null;

	vm.pageTypes = AppsService.getPageTypes();
	vm.loading = true;
	vm.page = page;
	vm.selectedType = [];
	vm.viewsList = null;
	vm.list;
	vm.selectedItem;

	vm.appPageType = {};

	/**
	 * When the cancel button is pressed.
	 */
	vm.cancel = function cancel() {
		$uibModalInstance.dismiss();
	};

	vm.savePage = function savePage() {
		if (vm.page.type == null) {
			cvToaster.showErrorMessage({
				message: cvLoc('appDesigner.msg.noPageTypeSelected')
			});
			return;
		}

		if (vm.page.itemId == null) {
			var msg = cvLoc('appDesigner.msg.noReportSelected');
			if (vm.page.type == 'table') {
				msg = cvLoc('appDesigner.msg.noTableSelected');
			}

			cvToaster.showErrorMessage({
				message: msg
			});
			return;
		}

		if (vm.selectedView && vm.selectedView.length) {
			vm.page.itemId = `${vm.selectedView[0].id}`;
			vm.page.properties = vm.selectedItem && {
				assocId: vm.selectedItem[0].id,
				subtype: `view`
			};
		}

		vm.page.properties.itemGUID = vm.page.itemId;

		if (vm.page.type == 'table') {
			if (vm.selectedView && vm.selectedView.length) vm.page.itemId = vm.selectedView[0].id;
			else {
				delete vm.page.properties.subtype;
				vm.page.itemId = vm.selectedItem[0].rowId;
			}
		} else if (vm.page.type == 'report') {
			vm.page.itemId = vm.selectedItem[0].id;
		}

		vm.page.save().then(onRequestSuccess, onRequestFailure);

		function onRequestSuccess(res) {
			$uibModalInstance.close(res);
		}
		function onRequestFailure(err) {
			$uibModalInstance.dismiss(err);
		}
	};

	vm.onAssocItemChange = function() {
		fetchItemList();
	};

	vm.onItemChange = function() {
		const item = vm.selectedItem[0];
		if (!item) return;
		vm.page.itemId = getItemId(vm.page.type, item);
		if (vm.appPageType.id === 'table') fetchViews(item.id);
	};

	vm.onPageTypeChange = function onPageTypeChange() {
		if (vm.selectedType && vm.selectedType[0].id === vm.appPageType.id) return;
		vm.page.type = vm.selectedType[0].id;
		vm.appPageType = vm.selectedType[0];
		vm.assocType = vm.appPageType.association ? AppsService.getPageTypeNameById(vm.appPageType.association) : null;
		fetchLists();
	};

	vm.handleDeletePage = function handleDeletePage() {
		let pageName = vm.page.name;

		$dialogs.confirm(
			cvLoc('appdesigner.label.confirmDelete'),
			cvLoc('appdesigner.msg.confirmDelete', `<b>${pageName}</b>`),
			{
				noFunction: function() {},
				yesFunction: function() {
					vm.page.remove().then(onDeleteSuccess, onDeleteFailure);
				}
			}
		);

		function onDeleteSuccess() {
			$state.go('appConfig', { appId: appId });
		}

		function onDeleteFailure(err) {
			if (err) {
				const message = getErrMessage(err);
				cvToaster.showErrorMessage({
					message
				});
			}
		}
	};

	function fetchItemList() {
		if (!vm.appPageType) return;
		const pageType = vm.page.type;

		vm.appPageType.getList().then(data => {
			vm.list = data;
			data.forEach(function(item) {
				if (pageType === 'report' && vm.page.itemId === item.guid) {
					item.selected = true;
					vm.selectedItem = [item];
				}
				if (pageType === 'table') {
					if (vm.page.properties.subtype === 'view') {
						if (vm.page.properties.assocId === item.id) {
							vm.selectedItem = [Object.assign(item, { selected: true })];
						}
					} else {
						if (vm.page.itemId === `${item.id}`) {
							vm.selectedItem = [Object.assign(item, { selected: true })];
						}
					}
				}
			});
			if (pageType === 'table' && vm.selectedItem) fetchViews(vm.selectedItem[0].id);
		});
	}

	function fetchLists() {
		vm.list = [];
		fetchItemList();
	}

	function fetchViews(tableId) {
		if (!vm.appPageType.views) return;

		vm.appPageType.views.getList(tableId).then(data => {
			vm.viewList = data;
			if (vm.page.properties.subtype !== 'view') return;
			data.forEach(function(item) {
				if (vm.page.itemId === `${item.id}`) {
					vm.selectedView = [Object.assign(item, { selected: true })];
				}
			});
		});
	}

	function getItemId(type, item) {
		if (vm.page.type === 'report') return item.guid;
		return `${type}:${item.id}`;
	}

	function onRequestFailure(err) {
		$uibModalInstance.dismiss(err);
	}
}

PageEditModalCtrl.$inject = [
	'$state',
	'$uibModalInstance',
	'AppsService',
	'page',
	'PageTypeService',
	'cvToaster',
	'cvLoc'
];

appDesignerModule.controller('PageEditModalCtrl', PageEditModalCtrl);

export default appDesignerModule;
