import { appDesignerModule } from 'common/js/modules';

// temporary localization App Designer strings
import '../../js/temp.localization';

// dependencies injected/need by Angular
import '../services/business.svc';
import '../services/cloneHelperService.svc';

import '../table-fields/tableField.directive';
import { getErrMessage } from '../util';

function BusinessRuleConfigCtrl(
	$stateParams,
	$log,
	cvLoc,
	$dialogs,
	cvToaster,
	$state,
	BusinessRulesService,
	CloneHelperService
) {
	let { tableId, businessRuleId, businessRule } = $stateParams;
	let vm = this;
	vm.tab = 'businessrule';
	vm.tableId = tableId;

	let cloneId = CloneHelperService.getItemClone();

	vm.classes = {
		labelClass: 'col-xs-12 col-lg-3',
		formGroupClass: 'form-group',
		inputContainerClass: 'col-xs-12 col-lg-6'
	};

	RuleBuilder.setFetcher(() =>
		Promise.all([fetchInputForm(), BusinessRulesService.getWorkflows()]).then(resp => {
			CloneHelperService.setItemClone(null);

			return {
				inputForm: resp[0],
				workflowEntities: resp[1]
			};
		})
	);
	RuleBuilder.openAppStudioBusinessRuleBuilder();

	vm.loading = true;
	vm.businessRule = null;

	vm.handleEditBusinessRule = function handleBusinessRuleEdit() {
		const rule = RuleBuilder.getRuleData();
		if (!rule.isValid) {
			return;
		}
		const ruleData = rule.rules.rules[0];
		const ruleTrigger = ruleData.ruleTriggers;

		if (
			$.isEmptyObject(ruleTrigger) ||
			((ruleTrigger.onRecordAdded == undefined || ruleTrigger.onRecordAdded === false) &&
				(ruleTrigger.onRecordUpdated == undefined || ruleTrigger.onRecordUpdated === false) &&
				(ruleTrigger.onRecordDelete == undefined || ruleTrigger.onRecordDelete === false))
		) {
			cvToaster.showErrorMessage({
				message: cvLoc('appDesigner.msg.noRuletriggerSelected')
			});
			return;
		}

		const actions = ruleData.actions.map(action =>
			Object.assign({}, action, {
				actionDetails: JSON.stringify(action.actionDetails)
			})
		);

		ruleData.actions = actions;

		const BusinessRule = BusinessRulesService.getBusinessRuleFromData(
			businessRuleId,
			tableId,
			Object.assign({}, rule, { sys_id: businessRuleId })
		);

		BusinessRule.save().then(onRequestSuccess, onRequestFailure);

		const title = ruleData.title;
		function onRequestSuccess(res) {
			$state.go('tableConfig', { tableId, tab: vm.tab });
			cvToaster.showSuccessMessage({
				message: cvLoc('appdesigner.msg.saveSuccessful', '<b>' + title + '</b>')
			});
		}

		function onRequestFailure(err) {
			if (err) {
				const message = getErrMessage(err);
				cvToaster.showErrorMessage({
					message
				});
			}
		}
	};

	vm.handleDeleteBusinessRule = function handleDeleteBusinessRule() {
		const rule = RuleBuilder.getRuleData();

		const BusinessRule = BusinessRulesService.getBusinessRuleFromData(
			businessRuleId,
			tableId,
			Object.assign({}, rule, { sys_id: businessRuleId })
		);

		let businessRuleName = BusinessRule.title;

		$dialogs.confirm(
			cvLoc('appdesigner.label.confirmDelete'),
			cvLoc('appdesigner.msg.confirmDelete', `<b>${businessRuleName}</b>`),
			{
				noFunction: function() {},
				yesFunction: function() {
					BusinessRule.remove().then(onDeleteSuccess, onDeleteFailure);
				}
			}
		);

		function onDeleteSuccess() {
			$state.go('tableConfig', { tableId, tab: vm.tab });
		}

		function onDeleteFailure(err) {
			if (err) {
				const message = getErrMessage(err);
				cvToaster.showErrorMessage({
					message
				});
			}
		}
	};

	function fetchInputForm() {
		return BusinessRulesService.getInputForm(cloneId || businessRuleId, tableId).then(
			onRequestSuccess,
			onRequestFailure
		);

		function onRequestSuccess(data) {
			if (cloneId) {
				data.properties.rules.rules && delete data.properties.rules.rules[0].title;
			}

			return data;
		}

		function onRequestFailure(err) {
			if (err) {
				const message = getErrMessage(err);
				cvToaster.showErrorMessage({
					message
				});
			}
			$log.error(err);
		}
	}
}

BusinessRuleConfigCtrl.$inject = [
	'$stateParams',
	'$log',
	'cvLoc',
	'$dialogs',
	'cvToaster',
	'$state',
	'BusinessRulesService',
	'CloneHelperService'
];

appDesignerModule.controller('BusinessRuleConfigCtrl', BusinessRuleConfigCtrl);

export default appDesignerModule;
