import { appDesignerModule } from 'common/js/modules';

// temporary localization App Designer strings
import './../temp.localization';

// dependencies injected by Angular
import '../services/apps.svc';

function AppPageViewerCtrl(AppsService, $scope, $state, $rootScope, $timeout) {
	$scope.partialToView = '';

	const $ele = $(wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT);
	$ele.find('.wfContainer').remove();
	$ele.children().removeClass('wfBlurInnerDivs');
	$ele.scrollTop(0);
	$ele.removeClass('wfHeightOverflow');

	$scope.page = $state.params.page || '';
	$scope.app = $state.params.app || '';
	$scope.reportName = $state.params.reportName || '';

	$scope.partialToView =
		'reportView.do?reportId=' + $scope.page + '&app=' + $scope.app + '&reportName=' + $scope.reportName;
	console.log('LazyLoad Working');

	$timeout(function() {
		$rootScope.$apply($scope);
	});

	var currUrl = window.location.href;
	var tableId = wfUtils.functions.getParameterByName('tableId', currUrl, '').trim();
	var formId = wfUtils.functions.getParameterByName('formId', currUrl, '').trim();
	var rowId = wfUtils.functions.getParameterByName('rowId', currUrl, '').trim();

	if (tableId != '' && (formId != '' || rowId != '')) {
		openTableForm({
			tableId: tableId,
			sysRowId: rowId,
			formId: formId,
			targetElement: wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT,
			doNotUpdateURL: true
		});
	}
}

AppPageViewerCtrl.$inject = ['AppsService', '$scope', '$state', '$rootScope', '$timeout'];

appDesignerModule.controller('AppPageViewerCtrl', AppPageViewerCtrl);

export default appDesignerModule;
