
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
</script>
<div>
	<div class="form-group" data-ng-if="!cappsClConfigODCtrl.dontUseOAuth">
		<label class="col-xs-12 col-lg-3" for="commvaultApp"><cv:msg
				key="label.azureAppDetails" bundle="exchange" /></label>
		<div class="col-xs-12 col-lg-8">
			<div class="multiple-radio-group">
				<label><input type="radio" id="commvaultApp" name="azureMethod" data-ng-change="cappsClConfigODCtrl.selectAzureMethod('commvault')" data-ng-model="cappsClConfigODCtrl.azureMethod"	value="commvault" required/>
				<cv:msg key="label.useDefaultApp"	bundle="exchange" /></label>
			</div>
			<div class="multiple-radio-group">
				<label><input type="radio" id="customApp" name="azureMethod" data-ng-change="cappsClConfigODCtrl.selectAzureMethod('custom')" data-ng-model="cappsClConfigODCtrl.azureMethod" value="custom" required/>
					<cv:msg key="label.useCustomApp" bundle="exchange" /></label>
			</div>
			<div class="help-block" data-ng-show="cappsClConfigODCtrl.errors.azureMethod ||cv.oneDriveClientConfigForm.needsAttention(oneDriveClientConfigForm.azureMethod)">
				<cv:msg key="error.noServerName" bundle="exchange" />
			</div>
		</div>
	</div>
	<div data-uib-collapse="!cappsClConfigODCtrl.azureMethod">
		<!--Client ID -->
		<div class="form-group" data-ng-if="cappsClConfigODCtrl.azureMethod !== 'commvault'">
			<label class="col-xs-12 col-lg-3" for="odClientId"><cv:msg key="label.onedrive.clientId" bundle="capps" /></label>
			<div class="col-xs-12" data-ng-class="{'col-lg-6': cappsClConfigODCtrl.isAddMode, 'col-lg-9' : !cappsClConfigODCtrl.isAddMode}">
				<input type="text" id="odClientId" name="odClientId" placeholder='<cv:msg key="label.help.applicationId" bundle="exchange"/>' data-ng-disabled="cappsClConfigODCtrl.azureMethod !== 'custom'"
				 data-ng-model="cappsClConfigODCtrl.cappsClientInstancePropModel.instancePropOneDriveClientId" required/>
				<span class="help-block" data-ng-show="cappsClConfigODCtrl.errors.odClientId || cv.oneDriveClientConfigForm.needsAttention(oneDriveClientConfigForm.odClientId)"><cv:msg key="error.onedrive.clientId" bundle="capps"/></span>
			</div>
		</div>
		<!--Client Secret -->
		<div class="form-group" data-ng-if="cappsClConfigODCtrl.azureMethod !== 'commvault'">
			<label class="col-xs-12 col-lg-3" for="clientSecret"><cv:msg key="label.onedrive.clientSecret" bundle="capps" /></label>
			<div class="col-xs-12" data-ng-class="{'col-lg-6': cappsClConfigODCtrl.isAddMode, 'col-lg-9' : !cappsClConfigODCtrl.isAddMode}">
				<input type="password" id="clientSecret" name="clientSecret" placeholder='<cv:msg key="label.help.secretAccessKey" bundle="exchange"/>' data-ng-disabled="cappsClConfigODCtrl.azureMethod !== 'custom'" data-ng-model="cappsClConfigODCtrl.cappsClientInstancePropModel.instancePropOneDriveSecretKey" required />
				<span class="help-block" data-ng-show="cv.oneDriveClientConfigForm.needsAttention(oneDriveClientConfigForm.clientSecret)"><cv:msg key="error.onedrive.clientSecret" bundle="capps"/></span>
			</div>
		</div>
		<!--Tenant -->
		<div class="form-group">
			<label class="col-xs-12 col-lg-3" for="clientTenant"><cv:msg key="label.azureDirectoryID" bundle="messages" /></label>
			<div class="col-xs-12" data-ng-class="{'col-lg-6': cappsClConfigODCtrl.isAddMode, 'col-lg-9' : !cappsClConfigODCtrl.isAddMode}">
				<div data-ng-class="{'input-group': cappsClConfigODCtrl.azureMethod === 'commvault'}">
					<input type="text" id="clientTenant" name="clientTenant" placeholder='<cv:msg key="label.help.azureDirectoryID" bundle="messages"/>' data-ng-model="cappsClConfigODCtrl.cappsClientInstancePropModel.instancePropOneDriveTenant" required />
					<span class="input-group-btn" data-ng-if="cappsClConfigODCtrl.azureMethod === 'commvault'">
						<button id="oneDriveConnectionFormElements_button_#6160" class="btn btn-primary" type="button" data-ng-click="cappsClConfigODCtrl.loginToMicrosoftAzure()"> 
							<cv:msg key="label.signInToAzure" bundle="exchange" />
						</button>
					</span>
				</div>
				<div class="text-muted" data-ng-if="cappsClConfigODCtrl.azureMethod === 'commvault'">
					<cv:msg key="label.canRetrieveThisForYou" bundle="exchange"></cv:msg>
				</div>
				<div class="help-block" data-ng-show="cappsClConfigODCtrl.errors.clientTenant || cv.oneDriveClientConfigForm.needsAttention(oneDriveClientConfigForm.clientTenant)"><cv:msg key="error.azureDirectoryID" bundle="messages"/></div>
			</div>
		</div>
	</div>
</div>
