<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
</script>
<div data-ng-controller="cappsClientConfigAnalyticsController as cappsClConfigAnalyticsCtrl">
<div class="setup-title">
	<h1><cv:msg key="label.editDataAnalytics" bundle="capps"/></h1>
</div>
<div class="setup-content">
	<div class="{{cappsClConfigAnalyticsCtrl.serverMessage.type}} serverMessage">{{cappsClConfigAnalyticsCtrl.serverMessage.message}}</div>
	<form id="editAnalyticsForm" name="editAnalyticsForm" data-cv-submit="cappsClConfigAnalyticsCtrl.saveAnalyticsForClient()" novalidate autocomplete="off">
	<div>
    <input type="checkbox" id="enableAnalytics" name="enableAnalytics" data-ng-model="cappsClConfigAnalyticsCtrl.enableAnalytics" >
    <label for="enableAnalytics">{{'label.enableDataAnalysis' | cvLoc}}</label>
  	</div>
	<div data-ng-show="cappsClConfigAnalyticsCtrl.enableAnalytics">
		<label for="plan" class="select-label add-server">
			<cv:msg key="label.plan" bundle="capps"/>
			<select name="plan"
			data-ng-options="profile.planName for profile in cappsClConfigAnalyticsCtrl.planList | orderBy: 'planName'"
			data-ng-model="cappsClConfigAnalyticsCtrl.selectedPlan" data-ng-required="cappsClConfigAnalyticsCtrl.enableAnalytics">
				<option value=""><cv:msg key="placeholder.plan" bundle="capps"/></option>
			</select>
			<span class="help-block" data-ng-show="cv.editAnalyticsForm.needsAttention(editAnalyticsForm.plan)"><cv:msg key="error.plan" bundle="capps"/></span>
		</label>
	</div>
	
	<div class="button-container">
		<button id="oneDriveClientConfigAnalytics_button_#9334" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cappsClConfigAnalyticsCtrl.cancel()"><cv:msg key="action.cancel" bundle="profiles"/></button> 
		<button id="oneDriveClientConfigAnalytics_button_#6119" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="action.save" bundle="profiles"/></button> 
	</div>
	</form>
</div>
</div>