<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
</script>
	<div>
		<div class="setup-title">
			<h1><cv:msg key="pageHeader.editProxy" bundle="capps"/></h1>
		</div>
		<div class="setup-content collection">
		
			<span class="{{epc.serverMessage.type}} serverMessage">{{epc.serverMessage.message}}</span>
			<form name="editProxyForm" novalidate data-cv-submit="epc.editProxy()" autocomplete="off" >
				<label for="backupClient" class="select-label add-server" ><cv:msg key="label.backupClient" bundle="capps"/>
					<select name="backupClient" data-ng-options="backupClient.clientId as backupClient.clientName for backupClient in epc.proxyServers | orderBy: 'clientName'"
					data-ng-model="epc.selectedOption.clientId" required>
					</select>
					<span class="help-block" data-ng-show="cv.addCAppServerForm.needsAttention(editProxyForm.backupClient)"><cv:msg key="error.backupClient" bundle="capps"/></span>
					<span class="help-block" data-ng-show="epc.inputAlerts.backupClient"><cv:msg key="error.backupClient" bundle="capps"/></span>
				</label>
				<!-- Key path is required for Google apps only -->
				<div data-ng-if="(epc.instanceModel.cloudAppType === epc.cloudAppTypeGoogleDrive) || (epc.instanceModel.cloudAppType === epc.cloudAppTypeGoogleMail)">
					<label for="appPrivateKeyPath" class="storage-path-label"><cv:msg key="label.appPrivateKeyPath" bundle="capps"/>
						<input type="text" name="appPrivateKeyPath" data-ng-model="epc.instanceModel.appPrivateKeyPath" required data-ng-pattern='pathPattern'/>
						<span class="help-block" data-ng-show="epc.inputAlerts.keyPath"><cv:msg key="error.backupClient" bundle="capps"/></span>
					</label>
					<button id="editProxyModal_button_#5117" type="button" data-ng-click="epc.browse()" class="btn btn-default browse-btn"> 
						<cv:msg key="Browse" bundle="storage"/>
					</button>
					<label>
						<span class="help-block" data-ng-show="cv.editProxyForm.needsAttention(editProxyForm.appPrivateKeyPath)"><cv:msg key="error.appPrivateKeyPath" bundle="capps"/></span>
					</label>
				</div>
				<div class="button-container">
					<button id="editProxyModal_button_#6473" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="epc.cancel()"> 
					<cv:msg key="Cancel" bundle="messages" />
					</button>
					<button id="editProxyModal_button_#2368" type="submit" class="btn btn-primary cvBusyOnAjax"> 
						<cv:msg key="Save" bundle="messages" />
					</button>
				</div>
			</form>
		</div>
	</div>
