<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.gsuite"></cv:cvMessages>
</script>

<form
	data-cv-submit="gsuiteAddServiceAccountCtrl.saveInfo()"
	name="addGSuiteServiceAccountForm"
	class="form-horizontal bootstrap-wrapper"
	novalidate
	autocomplete="off"
>
	<div class="modal-header">
		<h1 class="modal-title">
			<cv:msg key="action.addServiceAccount" bundle="gsuite" />
		</h1>
	</div>

	<div class="modal-body">
		<div class="form-group">
			<div class="col-xs-12 col-md-4">
				<label class="margin-top-10">
					<cv:msg key="label.serviceAccount" bundle="gsuite"/>
				</label>
			</div>
			<div class="col-xs-12 col-md-8">
				<input
					type="text"
					name="serviceAccount"
					id="serviceAccount"
					data-ng-model="gsuiteAddServiceAccountCtrl.appEmailId"
					data-ng-pattern="gsuiteAddServiceAccountCtrl.emailPattern"
					required
				/>
				<div
					class="margin-left-0 help-block"
					data-ng-show="addGSuiteServiceAccountForm.serviceAccount.$error.required && cv.addGSuiteServiceAccountForm.needsAttention(addGSuiteServiceAccountForm.serviceAccount)"
				>
					<cv:msg key="error.invalidEmailId" bundle="capps" />
				</div>
				<div
					class="margin-left-0 help-block"
					data-ng-show="addGSuiteServiceAccountForm.serviceAccount.$error.pattern && cv.addGSuiteServiceAccountForm.needsAttention(addGSuiteServiceAccountForm.serviceAccount)"
				>
					<cv:msg key="error.invalidEmailId" bundle="capps" />
				</div>
			</div>
		</div>

		<div class="form-group">
			<div class="col-xs-12 col-md-4">
				<cv-help-text
					help-label="label.appPrivateKeyPath"
					help-text="info.gApplicationPrivateKey"
				/>
			</div>
			<div class="col-xs-12 col-md-8">
				<div class="input-group">
					<input
						type="text"
						name="appPrivateKeyPath"
						id="appPrivateKeyPath"
						data-ng-model="gsuiteAddServiceAccountCtrl.appKey"
						required
					/>
					<span class="input-group-btn">
						<button
							id="gsuiteAddServiceAccount_button_#2313"
							type="button"
							data-ng-click="gsuiteAddServiceAccountCtrl.browse()"
							class="icon-style cv-material-button browse"
						>
							<div class="cv-material-button-icon cursor-pointer">
								<svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
									<path d="M0 0h24v24H0z" fill="none" />
									<path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z" />
								</svg>
							</div>
							<div class="cv-material-button-tooltip">
								<cv:msg key="Browse" bundle="storage" />
							</div>
						</button>
					</span>
				</div>
				<div
					class="margin-left-0 help-block"
					data-ng-show="addGSuiteServiceAccountForm.appPrivateKeyPath.$error.required && cv.addGSuiteServiceAccountForm.needsAttention(addGSuiteServiceAccountForm.appPrivateKeyPath)"
				>
					<cv:msg key="error.appPrivateKeyPath" bundle="capps" />
				</div>
			</div>
		</div>

	</div>
	
	<div class="modal-footer">
		<button
			type="button"
			class="btn btn-default cvBusyOnAjax"
			data-ng-click="gsuiteAddServiceAccountCtrl.cancel()"
		>
			<cv:msg key="Cancel" bundle="messages" />
		</button>

		<button
			type="submit"
			class="btn btn-primary cvBusyOnAjax"
		>
			<cv:msg key="Save" bundle="messages" />
		</button>
	</div>
</form>