<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
    <div class="bootstrap-wrapper form-horizontal modal-margin">
     	 <p class="restore-help-text padding-top-20" for="restoreToDiskRestoreDescription">
				  <cv:msg key="title.restoreToDiskRestoreDescription" bundle="cloudStorageApp" />
		 </p>
		 <p>
			<span class="{{cloudStorageAppRestoreCtrl.serverMessage.type}} serverMessage no-margin">{{cloudStorageAppRestoreCtrl.serverMessage.message}}</span>
		 </p>
		 <div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="target"><cv:msg key="label.destinationServer" bundle="cloudStorageApp" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<isteven-multi-select id="cloudStorageAppRestoreToDisk_isteven-multi-select_#1264"
                                input-model="cloudStorageAppRestoreCtrl.destinationTargetClients"
                                output-model="cloudStorageAppRestoreCtrl.restoreData.selectedTargetClientItem"
                                button-label="clientName"
                                item-label="clientName"
                                directive-id="destinationTargetAccount"
                                tick-property="selected"
                                selection-mode="single"
                                class="isteven-multi-select user-group-select single-select"
                                name="destinationTargetAccount"
                                helper-elements="filter"
                                search-limit="10"
                                max-labels="1"
                                translation="cloudStorageAppRestoreCtrl.localLang"
                                on-close="cloudStorageAppRestoreCtrl.changedDestinationTarget(cloudStorageAppRestoreCtrl.restoreData.selectedTargetClientItem)"
                                on-item-click="function()">
                </isteven-multi-select>
				 <span class="help-block" data-ng-show="cloudStorageAppRestoreCtrl.restoreAttempted && (!cloudStorageAppRestoreCtrl.restoreData.selectedTargetClient || !cloudStorageAppRestoreCtrl.restoreData.selectedTargetClient.clientId)">
                      <cv:msg key="error.destinationServer" bundle="cloudStorageApp" />
                </span>
			</div>
        </div>
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="streams"><cv:msg key="label.noOfStreams" bundle="cloudStorageApp" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<input type="number" data-ng-model="cloudStorageAppRestoreCtrl.restoreData.noOfStreams" id="dataStreams" name="dataStreams" min="1" max="100" />
				<span class="help-block" data-ng-show="!cloudStorageAppRestoreCtrl.restoreData.noOfStreams">
                	<cv:msg key="error.numberOfStreams" bundle="cloudStorageApp" />
           	 	</span>
			</div>
        </div>
        <div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="destinationPathOOP"><cv:msg key="label.destinationPath" bundle="cloudStorageApp" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<div class="input-group">
					<input name="destinationPathOOP" id="destinationPathOOP"  type="text" data-ng-model="cloudStorageAppRestoreCtrl.restoreData.destinationPathRTD"/>
					<span class="input-group-btn">
						<button id="cloudStorageAppRestoreToDisk_button_#6760" data-ng-disabled="cloudStorageAppRestoreCtrl.isDisableBrowse()" data-ng-click="cloudStorageAppRestoreCtrl.openDestinationPath()" type="button" class="btn btn-default browse-btn margin-top-3"><cv:msg key="label.browse" bundle="restore" /></button>
					</span>
				</div>
				 <span class="help-block" data-ng-show="cloudStorageAppRestoreCtrl.restoreAttempted && !cloudStorageAppRestoreCtrl.restoreData.destinationPathRTD">
                      <cv:msg key="error.destinationPath" bundle="cloudStorageApp" />
                </span>
                <span class="help-block" data-ng-show="cloudStorageAppRestoreCtrl.restoreAttempted && !cloudStorageAppRestoreCtrl.destinationPathValid">
                      <cv:msg key="error.invalidPath" bundle="clients" />
                </span>
			</div>
		</div>
        <div class="form-group" data-ng-if="!cloudStorageAppRestoreCtrl.isGitApp">
			<div class="col-xs-12 col-md-12 col-lg-12">
                <label for="unconditional">
	                <input id="overwriteRestoreToDisk" name="overwriteRestoreToDisk" data-ng-model="cloudStorageAppRestoreCtrl.restoreData.overwrite" value="unConditionalOverwrite"
	                    type="radio"/>
	                <cv:msg key="label.unconditionalOverwrite" bundle="cloudStorageApp" />
                </label>
			</div>
			<div class="col-xs-12 col-md-12 col-lg-12">
                <label for="overwriteIfNewer"><input id="overwriteRestoreToDisk" name="overwriteRestoreToDisk" data-ng-model="cloudStorageAppRestoreCtrl.restoreData.overwrite" value="overWriteIfNewer"
                    type="radio" />
                    <cv:msg key="label.overwriteIfFileInBackupIsNewer" bundle="cloudStorageApp" />
                </label>
			</div>
		</div>
		<div class="form-group" data-ng-if="cloudStorageAppRestoreCtrl.isGitApp">
			<div class="col-xs-12 col-md-12 col-lg-12">
				<label for="unconditional">
					<cv-toggle  value="unConditionalOverwrite"
						on-click="cloudStorageAppRestoreCtrl.toggleOverwrite(data, type.key)"></cv-toggle>
					<cv:msg key="label.unconditionalOverwrite" bundle="cloudStorageApp" />
				</label>
			</div>
		</div>
    </div>
