<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
    <div class="bootstrap-wrapper form-horizontal modal-margin">
 		<p class="restore-help-text padding-top-20"  for="outOfPlaceRestoreDescription">
			 <cv:msg key="title.outOfPlaceRestoreDescription" bundle="cloudStorageApp" />
		</p>
		<p>
			<span class="{{cloudStorageAppRestoreCtrl.serverMessage.type}} serverMessage no-margin">{{cloudStorageAppRestoreCtrl.serverMessage.message}}</span>
		</p>
        <div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="target" data-ng-bind="cloudStorageAppRestoreCtrl.objectStorageLabelName"></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<isteven-multi-select id="cloudStorageAppOutOfPlaceRestore_isteven-multi-select_#6093"
                                input-model="cloudStorageAppRestoreCtrl.destinationTargetAccounts"
                                output-model="cloudStorageAppRestoreCtrl.restoreData.selectedTargetAccountItem"
                                button-label="instanceName"
                                item-label="instanceName"
                                directive-id="destinationTargetAccount"
                                tick-property="selected"
                                selection-mode="single"
                                class="isteven-multi-select user-group-select single-select"
                                name="destinationTargetAccount"
                                helper-elements="filter"
                                search-limit="10"
                                max-labels="1"
                                translation="cloudStorageAppRestoreCtrl.localLang"
                                on-close="cloudStorageAppRestoreCtrl.changedDestinationTarget(cloudStorageAppRestoreCtrl.restoreData.selectedTargetAccountItem)"
                                on-item-click="function()">
                </isteven-multi-select>
				 <span class="help-block" data-ng-show="cloudStorageAppRestoreCtrl.restoreAttempted && (!cloudStorageAppRestoreCtrl.restoreData.selectedTargetAccount || !cloudStorageAppRestoreCtrl.restoreData.selectedTargetAccount.clientId)">
                      <cv:msg key="error.cloudTarget" bundle="cloudStorageApp" />
                </span>
			</div>
        </div>
		<div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="streams"><cv:msg key="label.noOfStreams" bundle="cloudStorageApp" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<input type="number" data-ng-model="cloudStorageAppRestoreCtrl.restoreData.noOfStreams" id="dataStreams" name="dataStreams" min="1" max="100" />
				<span class="help-block" data-ng-show="!cloudStorageAppRestoreCtrl.restoreData.noOfStreams">
                	<cv:msg key="error.numberOfStreams" bundle="cloudStorageApp" />
           	 	</span>
			</div>
        </div>
        <div class="form-group" ng-if="!cloudStorageAppRestoreCtrl.isGitApp">
			<label class="col-xs-12 col-md-4 col-lg-4" for="destinationPathOOP"><cv:msg key="label.destinationPath" bundle="cloudStorageApp" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<div class="input-group">
					<input name="destinationPathOOP" id="destinationPathOOP"  type="text" data-ng-model="cloudStorageAppRestoreCtrl.restoreData.destinationPathOOP"/>
					<span class="input-group-btn">
						<button id="cloudStorageAppOutOfPlaceRestore_button_#0438" data-ng-disabled="cloudStorageAppRestoreCtrl.isDisableBrowse()" data-ng-click="cloudStorageAppRestoreCtrl.openDestinationPath()" type="button" class="btn btn-default browse-btn margin-top-3"><cv:msg key="label.browse" bundle="restore" /></button>
					</span>
				</div>
				 <span class="help-block" data-ng-show="cloudStorageAppRestoreCtrl.restoreAttempted && !cloudStorageAppRestoreCtrl.restoreData.destinationPathOOP">
                      <cv:msg key="error.destinationPath" bundle="cloudStorageApp" />
                </span>
                <span class="help-block" data-ng-show="cloudStorageAppRestoreCtrl.restoreAttempted && !cloudStorageAppRestoreCtrl.destinationPathValid">
                      <cv:msg key="error.invalidPath" bundle="clients" />
                </span>
			</div>
		</div>
		<div ng-if="cloudStorageAppRestoreCtrl.isGitApp">
			<div class="form-group" data-ng-if="cloudStorageAppRestoreCtrl.showAccountType">
				<label class="col-xs-12 col-md-4 col-lg-4" for="gitAppTypeKey"><cv:msg key="label.accountType" bundle="capps" /></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<isteven-multi-select id="addCloudStorageContent_isteven-multi-select_#6986"
									input-model="cloudStorageAppRestoreCtrl.organizationType"
									output-model="cloudStorageAppRestoreCtrl.restoreData.selectedOrganizationType"
									button-label="name"
									item-label="name"
									directive-id="gitAppTypeKey"
									tick-property="selected"
									selection-mode="single"
									class="isteven-multi-select user-group-select single-select"
									name="gitAppTypeKey"
									helper-elements="filter"
									search-limit="10"
									max-labels="1"
									translation="aGApp.localLang"
									on-close="function()"
									on-item-click="cloudStorageAppRestoreCtrl.changeGitAppOrganizationType(cloudStorageAppRestoreCtrl.restoreData.selectedOrganizationType)">
					</isteven-multi-select>
					<span class="help-block" data-ng-show="cloudStorageAppRestoreCtrl.restoreAttempted && cloudStorageAppRestoreCtrl.showAccountType && !cloudStorageAppRestoreCtrl.restoreData.selectedOrganizationType">
						<cv:msg key="error.organizationType" bundle="capps" />
					</span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-md-4 col-lg-4" for="organizationName" data-ng-bind="cloudStorageAppRestoreCtrl.organizationName"></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input type="text" name="hostURL" id="hostURL" placeholder="{{aGApp.model.hostURLToolTip}}"  data-ng-model="cloudStorageAppRestoreCtrl.restoreData.organizationName" data-ng-required="false"/>
					<span class="help-block" data-ng-show="cloudStorageAppRestoreCtrl.restoreAttempted && !cloudStorageAppRestoreCtrl.restoreData.organizationName">
						<cv:msg key="error.gOrganizationName" bundle="capps" />
					</span>
				</div>
			</div>
			<div class="form-group" data-ng-if="cloudStorageAppRestoreCtrl.showProjectName">
				<label class="col-xs-12 col-md-4 col-lg-4" for="projectName" data-ng-bind="cloudStorageAppRestoreCtrl.projectName"></label>
				<div class="col-xs-12 col-md-8 col-lg-8">
					<input type="text" name="projectName" id="projectName" data-ng-model="cloudStorageAppRestoreCtrl.restoreData.projectName" data-ng-required="false"/>
					<span class="help-block" data-ng-show="cloudStorageAppRestoreCtrl.restoreAttempted && cloudStorageAppRestoreCtrl.projectName && !cloudStorageAppRestoreCtrl.restoreData.projectName">
						<cv:msg key="error.projectName" bundle="capps" />
					</span>
				</div>
			</div>
		</div>
        <div class="form-group" data-ng-if="!cloudStorageAppRestoreCtrl.isGitApp">
			<div class="col-xs-12 col-md-12 col-lg-12">
                <label for="unconditional">
	                <input id="overwriteOutOfPlace" name="overwriteOutOfPlace" data-ng-model="cloudStorageAppRestoreCtrl.restoreData.overwrite" value="unConditionalOverwrite"
	                    type="radio"/>
	                <cv:msg key="label.unconditionalOverwrite" bundle="cloudStorageApp" />
                </label>
			</div>
			<div class="col-xs-12 col-md-12 col-lg-12">
                <label for="overwriteIfNewer"><input id="overwriteOutOfPlace" name="overwriteOutOfPlace" data-ng-model="cloudStorageAppRestoreCtrl.restoreData.overwrite" value="overWriteIfNewer"
                    type="radio" />
                    <cv:msg key="label.overwriteIfFileInBackupIsNewer" bundle="cloudStorageApp" />
                </label>
			</div>
			<div class="col-xs-12 col-sm-12" data-ng-if="cloudStorageAppRestoreCtrl.isShowACLOption">
	        	<input type="checkbox" id="restoreACL" name="restoreACL" data-ng-model="cloudStorageAppRestoreCtrl.restoreACLs"/>
	        	<label for="restoreACL">
	            	<cv:msg key="label.restoreAcls" bundle="restore"/>
	        	</label>
	    	</div>
		</div>
		<br>
		<br>
		<div class="form-group" data-ng-if="cloudStorageAppRestoreCtrl.isGitApp">
			<div class="col-xs-12 col-md-12 col-lg-12">
				<label>
					<cv:msg key="label.overwriteNote" bundle="capps" />
				</label>
			</div>
		</div>
    </div>
