<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.job"></cv:cvMessages>
	<cv:cvMessages bundle="localization.fs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.cloudStorageApp"></cv:cvMessages>
	<cv:cvMessages bundle="localization.cloudStorageAppJs"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-xs-12">
		<span>
			<cv-changename obj="cloudStorageCGDetails.changeNameObj" service-method="renameSubclient.do" class="float-left"></cv-changename>
		</span>
	</div>
</div>
<cv-tab-nav></cv-tab-nav>
<div class="row collectMetaDiv">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="cloudStorageAccountContentGroupDetails-heading_clientGeneral-clients" data-title='<cv:msg key="heading.clientGeneral" bundle="clients" />' loader="cloudStorageCGDetails.subclientDetails">
			<ul class="group list-style-secondary">
				<li class="group" data-ng-if="cloudStorageCGDetails.instanceSupported == 'true' "><span class="pageDetailColumn"><cv:msg key="label.instanceName" bundle="clients" /></span>
					 <span class="pageDetailColumn"	data-ng-bind="cloudStorageCGDetails.subclientDetails.subClientEntity.instanceName"></span></li></span>
				<cv-activity-control label='<cv:msg key="label.backupEnabled" bundle="clients" />' ac-params="cloudStorageCGDetails.subclientDetails.subClientEntity" enable-backup="cloudStorageCGDetails.subclientDetails.commonProperties.enableBackup" enable-delay ="cloudStorageCGDetails.subclientDetails.commonProperties.enableBackupAfterDelay" delay-time="cloudStorageCGDetails.subclientDetails.commonProperties.enableBackupAtDateTime"> </cv-activity-control>
				<li data-ng-if='cloudStorageCGDetails.subclientDetails.commonProperties.lastBackupTime' class="group"><span class="pageDetailColumn"><cv:msg key="header.lastBackup" bundle="devicesJs" /></span>
					<span class="pageDetailColumn"><div class="time crop" val="{{cloudStorageCGDetails.subclientDetails.commonProperties.lastBackupTime}}"></div></span></li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.lastbackup.size" bundle="collections" /></span>
					<span class="pageDetailColumn" data-ng-bind="cloudStorageCGDetails.subclientDetails.commonProperties.lastBackupSize | capacity"></span></li>
				<li class="group"><span class="pageDetailColumn"><cv:msg key="label.totalbackup.size" bundle="collections" /></span>
					<span class="pageDetailColumn"	data-ng-bind="cloudStorageCGDetails.subclientDetails.commonProperties.totalBackupSize	| capacity"></span></li>
				<!--  <li data-ng-if='subclientDetails.commonProperties.nextBackupTime' class="group"><span class="pageDetailColumn"><cv:msg key="header.nextBackup" bundle="devicesJs" /></span>
					<span  class="pageDetailColumn"><div class="time crop"	val="{{subclientDetails.commonProperties.nextBackupTime}}"></div></span></li>
				-->
				<li class="group inline-editor">
					<span class="pageDetailColumn">
						<cv:msg key="label.numberBackupStreams" bundle="oracle" />
					</span>
					<span class="pageDetailColumn" data-ng-hide="cloudStorageCGDetails.editStreams">
						<span class="col-lg-2 no-padding inline-editor-input">
							<label data-ng-bind="cloudStorageCGDetails.subclientDetails.commonProperties.numberOfBackupStreams" class="col-lg-2 no-padding" ></label>
						</span>
						<span class="inline-editor-buttons">
								<a class="inline-editor-button" title='<cv:msg key="action.edit" bundle="settingsJs"/>'  data-ng-click="cloudStorageCGDetails._changeStreams('Edit')"><cv:msg key="action.edit" bundle="settingsJs"/></a>
						</span>
					</span>
					<span class="pageDetailColumn"data-ng-show="cloudStorageCGDetails.editStreams" >
						<span>
							<span class="col-lg-2 no-padding inline-editor-input">
								<input type="number" data-ng-model="cloudStorageCGDetails.subInfoData.numberOfBackupStreams" id="dataStreams" name="dataStreams" min="1" max="100" />
							</span>
							<span class="inline-editor-buttons">
								<span class="padding-left-10 inline-editor-button">
									<a title='<cv:msg key="Save" bundle="messages" />' class="padding-left-10" data-ng-click="cloudStorageCGDetails._changeStreams('Save')"><i class="k-icon k-i-check"></i></a>
								</span>
								<span class="padding-left-10 inline-editor-button">
									<a title='<cv:msg key="Cancel" bundle="messages" />' class="padding-left-10" data-ng-click="cloudStorageCGDetails._changeStreams('cancel')"><i class="k-icon k-i-close"></i></a>
								</span>
							</span>
						</span>
						<span class="help-block" data-ng-show="cloudStorageCGDetails.showNoOfStreamsError" >
                			<cv:msg key="error.numberOfStreams" bundle="cloudStorageApp" />
						</span>
					</span>
				</li>
				<!--- Collect ACL  option -->
				<span data-ng-if="cloudStorageCGDetails.isACLApplicable">
					<li class="group">
						<span class="pageDetailColumn">
							<cv-help-text
								help-label="<cv:msg key="label.collectAcl" bundle="cloudStorageApp" />"
								help-text="'<cv:msg key='info.collectAcl' bundle='cloudStorageApp' />'">
							</cv-help-text>
						</span>
						<span class="pageDetailColumn">
							<toggle-control class="{{backupEnabledStatusInfo}}"
								status="cloudStorageCGDetails.collectACL==true?'enabled-activity':'disabled-activity'"
								data-ng-click="cloudStorageCGDetails._manageACL()"
								title='<cv:msg key="label.enableDisable" bundle="messages"/>'>
							</toggle-control>
						</span>
					</li>
				</span>
			</ul>
		</cv-tile-component>
		<cv-tile-component data-ac-id="cloudStorageCGDetails-header_content-collections" data-ng-if="cloudStorageCGDetails.subclientDetails" data-title='<cv:msg key="header.content" bundle="collections"/>' data-min-height="true">
            <span data-ng-if="!cloudStorageCGDetails.contentEntityDetails || !cloudStorageCGDetails.contentEntityDetails.length"><p class="info-place-holder"><cv:msg key="label.noContent" bundle="clients" /></p></span>
            <ul class="list-style__row group" data-ng-repeat="contentEntity in cloudStorageCGDetails.contentEntityDetails">
                    <li> {{contentEntity.path}} </li>
                    <span data-ng-if="cloudStorageCGDetails.contentEntity.path == '/'" class='laptop-content-help-text less-padding'> - &nbsp;<cv:msg key='label.allContents' bundle='profiles'/></span>
            </ul>
             <div data-ng-if="!cloudStorageCGDetails.isSubclientEntity" class="page-details-box-links"><a  data-ng-click="cloudStorageCGDetails._manageContentGroupContent()"><cv:msg key="action.edit" bundle="settingsJs"/></a></div>
        </cv-tile-component>
	</div>
	<div class="col-md-6" data-ng-if="!!cloudStorageCGDetails.subclientDetails && !!cloudStorageCGDetails.subclientDetails.subClientEntity">
		<cv-backup-history params="cloudStorageCGDetails.params" entity="cloudStorageCGDetails.subclientDetails.subClientEntity" on-restore="cloudStorageCGDetails._performRestore(job, fromTimeStr, toTimeStr)"  ></cv-backup-history>
	</div>
</div>
