<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
    <cv:cvMessages bundle="localization.cloudStorageApp"></cv:cvMessages>
    <cv:cvMessages bundle="localization.cloudStorageAppJs"></cv:cvMessages>
    <cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper modal-margin">
    <p>
		<span class="{{aCsAcc.type}} serverMessage no-margin">{{aCsAcc.addCloudStorageMessage.message}}</span>
	</p>
    <form class="form-horizontal" name="addCloudStorageForm" novalidate data-cv-submit="aCsAcc.addOrEditCloudStorage()" autocomplete="off">
        <input style="display:none" type="text" name="cloudStorageName"/>
        <input style="display:none" type="text" name="hostURL"/>
        <input style="display:none" type="text" name="accessKey"/>
        <input style="display:none" type="text" name="cappsInstanceUserName"/>
        <input style="display:none" type="password" name="cappsInstancePassword"/>
        <input style="display:none" type="password" name="secretKey"/>
        <div class="form-group" data-ng-if="aCsAcc.showStorageAppType">
			<label class="col-xs-12 col-md-4 col-lg-4" for="cloudStorageAppTypeKey"><cv:msg key="label.vendorType" bundle="cloudStorageApp" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
				<isteven-multi-select id="addCloudStorageContent_isteven-multi-select_#6986"
                                input-model="aCsAcc.model.cloudStorageAppTypes"
                                output-model="aCsAcc.model.selectedCloudStorageAppType"
                                button-label="name"
                                item-label="name"
                                directive-id="cloudStorageAppTypeKey"
                                tick-property="selected"
                                selection-mode="single"
                                class="isteven-multi-select user-group-select single-select"
                                name="cloudStorageAppTypeKey"
                                helper-elements="filter"
                                search-limit="10"
                                max-labels="1"
                                translation="aCsAcc.localLang"
                                on-close="function()"
                                on-item-click="aCsAcc.changeLabelsByCloudStorageAppType(aCsAcc.model.selectedCloudStorageAppType)">
                </isteven-multi-select>
                <span class="help-block" data-ng-show="aCsAcc.addCloudStorageAttempted && !aCsAcc.model.cloudStorageAppTypeKey">
                	<cv:msg key="error.vendorType" bundle="cloudStorageApp" />
                </span>
			</div>
		</div>
        <div class="form-group">
			<label class="col-xs-12 col-md-4 col-lg-4" for="cloudStorageName"><cv:msg key="label.cloudStorageName" bundle="cloudStorageApp" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
                <input type="text" name="cloudStorageName" id="cloudStorageName" data-ng-model="aCsAcc.model.cloudStorageName" data-ng-required="true" />
                <span class="help-block" data-ng-show="cv.addCloudStorageForm.needsAttention(addCloudStorageForm.cloudStorageName)">
                      <cv:msg key="error.cloudStorageName" bundle="cloudStorageApp" />
                </span>
			</div>
		</div>
        <div class="form-group" data-ng-if="aCsAcc.isServerAndAccountNameDifferent">
			<label class="col-xs-12 col-md-4 col-lg-4" for="accoutName"><cv:msg key="label.accountName" bundle="cloudStorageApp" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
                <input type="text" name="accountName" id="accountName" data-ng-model="aCsAcc.model.accountName" data-ng-required="true" />
                <span class="help-block" data-ng-show="cv.addCloudStorageForm.needsAttention(addCloudStorageForm.accountName)">
                      <cv:msg key="error.accountName" bundle="cloudStorageApp" />
                </span>
			</div>
		</div>
        <div class="form-group" data-ng-if="!!aCsAcc.model.cloudStorageAppTypeKey">
			<label class="col-xs-12 col-md-4 col-lg-4" for="hostURL"><cv:msg key="label.hostURL" bundle="cloudStorageApp" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
                <input type="text" name="hostURL" id="hostURL" placeholder="{{aCsAcc.model.hostURLToolTip}}"  data-ng-model="aCsAcc.model.hostURL" data-ng-required="true"/>
                <span class="help-block" data-ng-show="cv.addCloudStorageForm.needsAttention(addCloudStorageForm.hostURL)">
                      <cv:msg key="error.hostURL" bundle="cloudStorageApp" />
                </span>
			</div>
		</div>
		<div class="form-group" data-ng-if="aCsAcc.showAuthenticationType()">
			<label for="authenticationType" class="col-xs-4 col-sm-4"><cv:msg key="label.authentication" bundle="storage" /></label>
			<div class="col-xs-8 col-sm-8">
				<select id="authenticationType" name="authenticationType" data-ng-model="aCsAcc.storageAuthenticationType"
						data-ng-change="aCsAcc.loadCredentials()"
						data-ng-options="authenticationType as authenticationType.displayName | cvLoc for authenticationType in aCsAcc.storageAuthenticationTypeList | orderBy:'id' track by authenticationType.id" required
						data-ng-class="{'has-error': cv.addCloudStorageForm.needsAttention(addCloudStorageForm.authenticationType)}">
					<option value=""><cv:msg key="placeholder.authenticationType" bundle="storage" /></option>
				</select>
				<span class="help-block" data-ng-show="cv.addCloudStorageForm.needsAttention(addCloudStorageForm.authenticationType)"><cv:msg key="error.authenticationType" bundle="storage"/></span>
			</div>
		</div>

		<!-- Credential manager code -->
	    <div class="form-group margin-bottom-10" data-ng-if="aCsAcc.storageAuthenticationType.showCredential">
			<label for="credential" class="col-xs-4 col-sm-4"> <cv:msg key="label.credentialName" bundle="storage"/></label>
			<div class="col-xs-8 col-sm-8">
				<select-with-create-button
					select-id="credential"
					select-name="credential"
					key-label="credentialName"
					key-id="credentialId"
					option-list="aCsAcc.savedCredentials"
					on-change-option="aCsAcc.onChangeCredential"
					selected-option="aCsAcc.libraryInfo.selectedCredential"
					on-click-create-button="aCsAcc.openCreateCredentialModal"
					has-error="cv.addCloudStorageForm.needsAttention(addCloudStorageForm.credential)"
					class="no-float-auto tile-large-width"
					placeholder='<cv:msg key="placeholder.credential" bundle="storage"/>'
					edit-disabled="aCsAcc.libraryInfo.selectedCredential === null"
					on-click-edit-button="aCsAcc.openEditCredentialModal"
					is-credential="true">
				</select-with-create-button>
				<span class="help-block" data-ng-show="aCsAcc.credentialNotSelectedError">
					<cv:msg key="error.credential.required" bundle="storage"/>
				</span>
			</div>
		</div>
		<div class="form-group" data-ng-if="aCsAcc.isShowAccountName()">
			<label class="col-xs-12 col-md-4 col-lg-4" for="adAccoutName"><cv:msg key="label.accountName" bundle="cloudStorageApp" /></label>
			<div class="col-xs-12 col-md-8 col-lg-8">
                <input type="text" name="adAccoutName" id="adAccoutName" data-ng-model="aCsAcc.model.adAccoutName" data-ng-required="true" />
                <span class="help-block" data-ng-show="cv.addCloudStorageForm.needsAttention(addCloudStorageForm.adAccoutName)">
                      <cv:msg key="error.accountName" bundle="cloudStorageApp" />
                </span>
			</div>
		</div>

    <div class="form-group margin-bottom-10">
		<label class="col-xs-12 col-md-4 col-lg-4" for="accessNode">
		<cv-help-text help-text="'<cv:msg key='info.accessNodeHelpText' bundle='cloudStorageApp'/>'"
									help-label="<cv:msg key="label.accessNode" bundle="cloudStorageApp" />"></cv-help-text></label>
		<div class="col-xs-12 col-md-8 col-lg-8">
            <isteven-multi-select id="addCloudStorageContent_isteven-multi-select_#2484"
                                input-model="aCsAcc.accessNodes"
                                output-model="aCsAcc.model.accessNode"
                                button-label="displayName"
                                item-label="displayName"
                                directive-id="accessNode"
                                tick-property="selected"
                                selection-mode="single"
                                class="isteven-multi-select user-group-select single-select"
                                name="accessNode"
                                helper-elements="filter"
                                search-limit="10"
                                max-labels="1"
                                translation="aCsAcc.localLang"
                                on-close="function()"
                                on-item-click="function()">
                </isteven-multi-select>
            <span class="help-block" data-ng-show="cv.addCloudStorageForm.needsAttention(addCloudStorageForm.accessNode) && !aCsAcc.model.accessNode">
                      <cv:msg key="error.accessNode" bundle="cloudStorageApp" />
            </span>
		</div>
	</div>
	<div class="margin-top-10">
	    <cv-entity-plan-policy-select data-ng-if="!aCsAcc.isAnalytics" data-cv-hide-policy-toggle-option="aCsAcc.hidePolicyToggleOption" data-cv-model="aCsAcc.planPolicyModel" data-cv-app-id="aCsAcc.applicationId" data-cv-client-id="aCsAcc.clientId" data-cv-wrapper-class="'form-group'" data-cv-label-class="'col-xs-12 col-md-4 col-lg-4'" data-cv-select-class="'col-xs-12 col-md-8 col-lg-8'">
	    </cv-entity-plan-policy-select>
	</div>
    <div class="button-container">
        <button id="addCloudStorageContent_button_#2780" type="button" data-ng-if="!isSetup" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="aCsAcc.close()">
            <cv:msg key="Cancel" bundle="messages" />
        </button>
        <button id="addCloudStorageContent_button_skip" type="button" data-ng-if="isSetup" class="btn btn-default cvBusyOnAjax" data-ng-click="skipSetup()">
				<cv:msg key="action.doItLater" bundle="profiles" />
		</button>
        <button id="addCloudStorageContent_button_#0001" type="submit" class="btn btn-primary cvBusyOnAjax">
            <cv:msg key="Save" bundle="messages" />
        </button>
	</div>
   </form>
</div>
