<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.cloudStorageApp"></cv:cvMessages>
	<cv:cvMessages bundle="localization.cloudStorageAppJs"></cv:cvMessages>
</script>
<div class="row">
	<div class="col-xs-12">
		<span class="cv-k-grid-title">
			<cv-changename data-ng-if="sfOrgSettingsCtrl.changeNameObj" obj="sfOrgSettingsCtrl.changeNameObj" service-method="salesforceOrganizationName.do" class="float-left"
				callback="sfOrgSettingsCtrl.changeNameSuccess" ></cv-changename>

			<div data-ng-if="sfOrgSettingsCtrl.instanceId > 0" class="page-action-item">
				<cv-capps-salesforce-instance-filter
					client-id="sfOrgSettingsCtrl.clientId"
					instance-id="sfOrgSettingsCtrl.instanceId"
					backupset-id="sfOrgSettingsCtrl.backupsetId"
					on-instance-list-call-back="sfOrgSettingsCtrl._onGetInstanceListCallBack(instanceList)"></cv-capps-salesforce-instance-filter>
			</div>
		</span>
	</div>
</div>
<cv-tab-nav></cv-tab-nav>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="accountDetails-label_accountl"
			data-title='<cv:msg key="title.accountDetails" bundle="capps"/>'
			loader="sfOrgSettingsCtrl.orgDetails.salesforceAccount">
		<ul class="list-style-secondary">
			<li class="group"><span class="pageDetailColumn"><cv:msg
						key="label.userName" bundle="capps" /></span> <span
				class="pageDetailColumn"><a
					data-ng-bind="sfOrgSettingsCtrl.orgDetails.salesforceAccount.userCredentials.userName"
					data-ng-click="sfOrgSettingsCtrl.UpdateProps('salesforceAccount')"></a></span>
			</li>
			<li class="group"><span class="pageDetailColumn"> <cv-help-text
						help-label="{{sfOrgSettingsCtrl.filesPerBackupLabel}}"
						help-text="sfOrgSettingsCtrl.filesPerBackupHelpText"></cv-help-text>
			</span> <span class="pageDetailColumn" data-ng-click="sfOrgSettingsCtrl.UpdateProps('filesPerBackup')">
				<a data-ng-if="sfOrgSettingsCtrl.orgDetails.filesPerBackupLabel.length"
					data-ng-bind="sfOrgSettingsCtrl.orgDetails.filesPerBackupLabel"></a>
					<a data-ng-if="!sfOrgSettingsCtrl.orgDetails.filesPerBackupLabel.length">
						<cv:msg key="label.notSet" bundle="capps" /></a></span>
			</li>
		</ul>
		</cv-tile-component>
	</div>
	<div class="col-md-6" data-ng-if="sfOrgSettingsCtrl.acParams">
		<cv-activity-control-component
			data-ac-params="sfOrgSettingsCtrl.acParams">
		</cv-activity-control-component>
	</div>
</div>
<div class="row">
	<div class="col-md-6" data-ng-if="sfOrgSettingsCtrl.showInfrastructureSettings">
		<cv-tile-component data-ac-id="accountDetails-label_accountl"
			data-title='<cv:msg key="title.infrastructureSettings" bundle="capps"/>'
			loader="sfOrgSettingsCtrl.orgDetails">
		<ul class="list-style-secondary">
			<li class="group"><span class="pageDetailColumn"><cv:msg
						key="label.numberBackupStreams" bundle="capps" /></span> <span
				class="pageDetailColumn" data-ng-click="sfOrgSettingsCtrl.UpdateProps('noOfStreams')">
				<a data-ng-if="sfOrgSettingsCtrl.orgDetails.noOfBackupStreams" data-ng-bind="sfOrgSettingsCtrl.orgDetails.noOfBackupStreams"></a>
				<a data-ng-if="!sfOrgSettingsCtrl.orgDetails.noOfBackupStreams">
						<cv:msg key="label.notSet" bundle="capps" /></a>
				</span></li>
			<li class="group"><span class="pageDetailColumn"><cv:msg
						key="label.backupClientAccNode" bundle="capps" /></span> <span
				class="pageDetailColumn"
				data-ng-click="sfOrgSettingsCtrl.UpdateProps('accessNode')">
					<a
					data-ng-if="sfOrgSettingsCtrl.orgDetails.accessNodes[0].client.clientName"
					data-ng-bind="sfOrgSettingsCtrl.orgDetails.accessNodes[0].client.clientName"></a>
					<a
					data-ng-if="sfOrgSettingsCtrl.orgDetails.accessNodes[0].client.clientGroupName"
					data-ng-bind="sfOrgSettingsCtrl.orgDetails.accessNodes[0].client.clientGroupName"></a>
					<a
					data-ng-if="!sfOrgSettingsCtrl.orgDetails.accessNodes[0].client.clientName && !sfOrgSettingsCtrl.orgDetails.accessNodes[0].client.clientGroupName">
						<cv:msg key="label.notSet" bundle="capps" /></a>
			</span></li>
			<li class="group"><span class="pageDetailColumn"><cv:msg
						key="label.downloadCachePath" bundle="capps" /></span> <span
				class="pageDetailColumn"
				data-ng-click="sfOrgSettingsCtrl.UpdateProps('downloadCachePath')">
					<a
					data-ng-if="sfOrgSettingsCtrl.orgDetails.downloadCachePath.length"
					data-ng-bind="sfOrgSettingsCtrl.orgDetails.downloadCachePath"></a>
					<a
					data-ng-if="!sfOrgSettingsCtrl.orgDetails.downloadCachePath.length">
						<cv:msg key="label.notSet" bundle="capps" />
				</a>
			</span></li>
			<li class="group"><span class="pageDetailColumn"><cv:msg
						key="label.syncDatabase" bundle="capps" /></span> <span
				class="pageDetailColumn"
				data-ng-click="sfOrgSettingsCtrl.UpdateProps('syncDatabase')">
					<a
					data-ng-if="!sfOrgSettingsCtrl.orgDetails.syncDatabase.dbEnabled"><cv:msg
							key="label.notSet" bundle="capps" /> </a> <a
					data-ng-if="sfOrgSettingsCtrl.orgDetails.syncDatabase.dbEnabled"
					data-ng-bind="sfOrgSettingsCtrl.orgDetails.syncDatabase.dbName"></a>
			</span></li>
		</ul>
		</cv-tile-component>
	</div>
	<div class="col-md-6" data-ng-if="sfOrgSettingsCtrl.clientEntity">
		<cv-security-component entity-type='sfOrgSettingsCtrl.entityType'
			generic-entity='sfOrgSettingsCtrl.clientEntity'
			associations-loaded="sfOrgSettingsCtrl.associationsLoaded"
			associations='sfOrgSettingsCtrl.formattedSecurityAssociations'>
		</cv-security-component>
	</div>
</div>