<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<fmt:setBundle basename="localization.messages" var="common" />
<fmt:bundle basename="localization.capps">
<div id="sf-mask-config-modal" class="bootstrap-wrapper">
	<div class="setup-title">
		<h1>
			<label>
				{{configModalCtrl.modalTitle}}
			</label>
		</h1>
	</div>
	<div data-ng-if="configModalCtrl.serverMessage.message" class="margin-bottom-0 serverMessage {{configModalCtrl.serverMessage.type}}" data-ng-bind="configModalCtrl.serverMessage.message"></div>
	<div class="remove-top-padding">
		<div class="form-group">
			<div class="col-xs-12 col-sm-5" data-ng-class="{'margin-top-0': configModalCtrl.serverMessage.message, 'margin-top-20': !configModalCtrl.serverMessage.message}">
				 <label  for="object-select"><fmt:message key="salesforce.label.Object" /></label>
			</div>
			<div class="col-xs-12 col-sm-7" data-ng-show="!configModalCtrl.objectsLoading" data-ng-class="{'margin-top-0': configModalCtrl.serverMessage.message, 'margin-top-15': !configModalCtrl.serverMessage.message}">
					<isteven-multi-select
						input-model="configModalCtrl.objectList"
						output-model="configModalCtrl.selectedObject"
						item-label="label"
						button-label="label"
						tick-property="checked"
						disable-property="disabled"
						helper-elements="filter"
						class="isteven-multi-select isteven-multi-select-arrow-fix  user-group-select"
						name="object-select"
						id="object-select"
						max-labels="2"
						on-item-click="configModalCtrl.objectSelectionChanged()"
						data-selection-mode="single"
						translation="configModalCtrl.localLangObject">
					</isteven-multi-select>
			</div>
			<div class="col-xs-12 col-sm-7 margin-top-20" data-ng-show="configModalCtrl.objectsLoading" >
			 	<label><fmt:message key="Loading" bundle="${common }"/></label>
			</div>
		</div>
		<div data-ng-disabled="!configModalCtrl.selectedObject || configModalCtrl.selectedObject.length == 0" >
				<div  class="form-group">
					<div class="col-xs-12 col-sm-5 margin-top-20">
						<label  for="columns"><fmt:message key="salesforce.label.columns" /></label>
					</div>
					<div class="col-xs-12 col-sm-7  margin-top-15">
						<isteven-multi-select
							input-model="configModalCtrl.columnList"
							output-model="configModalCtrl.selectedColumns"
							item-label="nameTypeTemplate"
							button-label="name"
							tick-property="checked"
							disable-property="disabled"
							helper-elements="filter"
							class="isteven-multi-select isteven-multi-select-arrow-fix column-select user-group-select"
							name="columns"
							id="columns"
							max-labels="2"
							on-close="configModalCtrl.updateMaskTypes()"
							translation="configModalCtrl.localLangFields">
						</isteven-multi-select>
					</div>
				</div>
				<div class="form-group">
					<div class="col-xs-12 col-sm-5 margin-top-20">
						<label for="maskType"><fmt:message key="salesforce.label.maskingType" /></label>
					</div>
					<div class="col-xs-12 col-sm-7  margin-top-15">
						<isteven-multi-select
								input-model="configModalCtrl.maskTypeOptions"
								output-model= "configModalCtrl.selectedMaskType"
								item-label="name"
								button-label="name"
								tick-property="checked"
								disable-property="disabled"
								helper-elements="filter"
								class="isteven-multi-select isteven-multi-select-arrow-fix  user-group-select"
								name="maskType"
								id="maskType"
								max-labels="2"
								on-item-click="configModalCtrl.updateRequiredParams()"
								data-selection-mode="single"
								translation="configModalCtrl.localLangMaskType">
							</isteven-multi-select>
					</div>
				</div>
				<div  class="form-group" data-ng-repeat="param in configModalCtrl.requiredParams">
					<div class="col-xs-12 col-sm-5 margin-top-20">
						<label for="param_{{param.name}}">{{param.name}}</label>
					</div>
					<div class="col-xs-12 col-sm-7  margin-top-15">
						<input type="{{param.type}}" name="param_{{param.name}}" data-ng-model="param.value" />
					</div>
				</div>
		</div>
		<div class="button-container">
				<button id="maskPolicyConfig_button_#3040" class="btn btn-default cvBusyOnAjax" type="button" data-ng-click="configModalCtrl.cancelConfigModal()"> 
			  		{{configModalCtrl.modalOptions.closeButtonText}}
		  		</button>
		  		<button id="maskPolicyConfig_button_#1169" class="btn btn-primary cvBusyOnAjax" type="submit"  data-ng-click="configModalCtrl.addConfigAndCloseModal()" data-ng-disabled="configModalCtrl.isAddConfigDisabled()"> 
		  			{{configModalCtrl.modalOptions.addButtonText}}
				</button>
		</div>
	</div>
</div>
</fmt:bundle>
