<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.oracle"></cv:cvMessages>
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messages"></cv:cvMessages>
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.collections"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.dbs"></cv:cvMessages>
</script>
<div class="bootstrap-wrapper">
	<div class="modal-header">
		<h1>{{sfProps.modalTitle}}</h1>
	</div>
	<span class="{{sfProps.serverMessage.type}}"
		data-ng-bind="sfProps.serverMessage.message"></span>
	<form name="updateSfProps" class="form-horizontal" novalidate
		data-cv-submit="sfProps.submit()" autocomplete="off">
		<div class="panel">
			<div class="panel-body">
				<!-- Files per backup -->
				<div class="form-group" data-ng-if="sfProps.isFilesPerBackup">
					<label class="col-xs-12 col-sm-5" for="filesPerBackup"> <cv-help-text
							help-label="{{sfProps.filesPerBackupLabel}}"
							help-text="sfProps.filesPerBackupHelpText"></cv-help-text>
					</label>
					<div class="col-xs-12 col-sm-7">
						<input id="filesPerBackup" type="number" min="1" max="90"
							data-ng-model="sfProps.orgDetails.filesPerBackup" /> <span
							class="help-block"
							data-ng-show="cv.updateSfProps.needsAttention(updateSfProps.filesPerBackup)">
							<cv:msg key="error.filesPerBackup" bundle="capps" />
						</span>
					</div>
				</div>

				<!-- Number of Backup streams -->
				<div class="form-group" data-ng-if="sfProps.isNoOfStreams">
					<label class="col-xs-12 col-sm-5" for="noOfStreams"> <cv:msg
							key="label.numberBackupStreams" bundle="capps" />
					</label>
					<div class="col-xs-12 col-sm-7">
						<input id="noOfStreams" type="number" min="1" max="32"
							data-ng-model="sfProps.orgDetails.noOfBackupStreams" /> <span
							class="help-block"
							data-ng-show="cv.updateSfProps.needsAttention(updateSfProps.noOfStreams)">
							<cv:msg key="error.noOfStreams" bundle="capps" />
						</span>
					</div>
				</div>

				<!-- Download Cache Path -->
				<div class="form-group" data-ng-if="sfProps.isDownloadCachePath">
					<label class="col-xs-12 col-sm-5" for="downloadCachePath">
						<cv:msg key="label.downloadCachePath" bundle="capps" />
					</label>
					<div class="col-xs-12 col-sm-7">
						<input id="downloadCachePath" type="text"
							data-ng-model="sfProps.orgDetails.downloadCachePath" /> <span
							class="help-block"
							data-ng-show="cv.updateSfProps.needsAttention(updateSfProps.downloadCachePath)">
							<cv:msg key="error.downloadCachePath" bundle="capps" />
						</span>
					</div>
				</div>

				<!-- Sync database options -->
				<div data-ng-if="sfProps.isSyncDatabaseOptions">
					<cv-sync-database sync-database="sfProps.orgDetails.syncDatabase"
						show-dummy-password="true" server-message="sfProps.serverMessage"
						proxy-servers="sfProps.orgDetails.accessNodes"
						entity="sfProps.orgDetails.entity"
						always-enable="true"> </cv-sync-database>
				</div>

				<!-- Access nodes -->
				<div data-ng-if="sfProps.isAccessNodes">
					<cv-capps-access-nodes instance-type="sfProps.instanceType"
						selected-access-nodes-list="sfProps.orgDetails.accessNodes">
					</cv-capps-access-nodes>
				</div>

				<!-- Salesforce Account -->
				<div data-ng-if="sfProps.isSalesforceAccount">
					<cv-salesforce-account-details
						salesforce-account="sfProps.orgDetails.salesforceAccount"
						proxy-servers="sfProps.orgDetails.accessNodes"
						entity="sfProps.orgDetails.entity">
					</cv-salesforce-account-details>
				</div>

			</div>
		</div>
		<div class="modal-footer">
			<button id="sfProps_button_#9807" type="button"
				class="btn btn-default cvBusyOnAjax"
				data-ng-click="sfProps.cancel()">
				<cv:msg key="Cancel" bundle="messages" />
			</button>
			<button id="sfProps_button_#7110"
				class="btn btn-primary cvBusyOnAjax" type="submit">
				<cv:msg key="Save" bundle="messages" />
			</button>
		</div>
	</form>

</div>
