<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.clients"></cv:cvMessages>
	<cv:cvMessages bundle="localization.capps"></cv:cvMessages>
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>
<fmt:setBundle basename="localization.messages" var="common" />
<fmt:bundle basename="localization.capps">
<div id="salesforce-masking-modal" class="bootstrap-wrapper">
	<div class="setup-title">
		<h1>
			<label>
				{{modalCtrl.modalTitle}}
				<cv-help-component help-text="<fmt:message key="salesforce.maskingTooltip" />"></cv-help-component>
			</label>
		</h1>
	</div>
	<div data-ng-if="modalCtrl.serverMessage.message" class="margin-bottom-0 margin-left-15 margin-top-10 serverMessage {{modalCtrl.serverMessage.type}}" data-ng-bind="modalCtrl.serverMessage.message"></div>
	<div class="remove-top-padding" data-ng-disabled="modalCtrl.loadingModalData">
		<form name="createSFMaskingPolicyForm" novalidate autocomplete="off" cv-submit="modalCtrl.saveAndCloseModal()">
			<div class="form-group">
				<div class="col-xs-12 col-sm-5"  data-ng-class="{'margin-top-0': modalCtrl.serverMessage.message, 'margin-top-10': !modalCtrl.serverMessage.message}">
					<label  for="policyName">
						<fmt:message key="salesforce.label.policyName" />
					</label>
				</div>
				 <div class="col-xs-12 col-sm-7"  data-ng-class="{'margin-top-0': modalCtrl.serverMessage.message, 'margin-top-10': !modalCtrl.serverMessage.message}">
					<input type="text" name="policyName" maxlength="150" data-ng-model="modalCtrl.policy.policy.policyName" required />
					<span class="serverMessage error" data-ng-show="createSFMaskingPolicyForm.policyName.$error.required && cv.createSFMaskingPolicyForm.needsAttention(createSFMaskingPolicyForm.policyName)">
						<cv:msg key="salesforce.help.enterPolicyName" bundle="capps"/>
					</span>
				</div>
			</div>
			<div class="form-group">
				<div class="col-xs-12 col-sm-5 margin-top-20">
					 <label for="sf-backupset-name"><fmt:message key="label.username"/> </label>
				</div>
				<div data-ng-if="modalCtrl.backupsets.length ==1" class="col-xs-12 col-sm-7 margin-top-20" data-ng-disabled="!modalCtrl.isNew">
					<label name="sf-backupset-name">{{modalCtrl.selectedBackupset[0].backupsetName}}</label>
				</div>
				<div data-ng-if="modalCtrl.backupsets.length >1" class="col-xs-12 col-sm-7 margin-top-20">
					<isteven-multi-select
								input-model="modalCtrl.backupsets"
								output-model= "modalCtrl.selectedBackupset"
								item-label="backupsetName"
								button-label="backupsetName"
								tick-property="checked"
								disable-property="disabled"
								helper-elements="filter"
								class="isteven-multi-select isteven-multi-select-arrow-fix  user-group-select"
								name="sf-backupset-name"
								id="sf-backupset-name"
								max-labels="1"
								on-item-click="modalCtrl.backupsetSelectionChanged()"
								data-selection-mode="single"
								translation="modalCtrl.localLang">
						</isteven-multi-select>
				</div>
			</div>
			<div class="form-group sf-mask-config-table margin-left-10" data-ng-disabled="!modalCtrl.hasBackup">
					<cv-salesforce-mask-config-table
						instance-id= "modalCtrl.policy.association.instanceId"
						policy="modalCtrl.policy"
						selected-backupset="modalCtrl.selectedBackupset">
					</cv-salesforce-mask-config-table>
			</div>
			<div class="button-container">
				<button id="cappsSalesforceCreateMaskingPolicy_button_#1779" class="btn btn-default cvBusyOnAjax" type="button" data-ng-click="modalCtrl.cancelModal()"> 
			  		{{modalCtrl.modalOptions.closeButtonText}}
		  		</button>
		  		<button id="cappsSalesforceCreateMaskingPolicy_button_#0552" class="btn btn-primary cvBusyOnAjax" type="submit"  data-ng-click="modalCtrl.saveAndCloseModal()" data-ng-disabled="!modalCtrl.isValidEntry()"> 
		  			{{modalCtrl.modalOptions.saveButtonText}}
				</button>
			</div>
		</form>
	</div>
</div>
</fmt:bundle>
